/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.json;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JsonPrinter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Object object, Writer writer) {
        PrintWriter out = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
        try {
            this.printValue("", object, out);
        }
        finally {
            out.flush();
        }
    }

    protected void printValue(String indent, Object value, PrintWriter out) {
        if (value instanceof Map) {
            this.printObject(indent, (Map)value, out);
        } else if (value instanceof List) {
            this.printList(indent, (List)value, out);
        } else {
            this.printString(value, out);
        }
    }

    protected void printObject(String indent, Map object, PrintWriter out) {
        out.println("{");
        Iterator i = object.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            out.print(indent + "    ");
            this.printString(e.getKey(), out);
            out.print(" : ");
            this.printValue(indent + "    ", e.getValue(), out);
            if (!i.hasNext()) continue;
            out.println(",");
        }
        out.println();
        out.print(indent + "}");
    }

    protected void printList(String indent, List list, PrintWriter out) {
        out.println("[");
        Iterator i = list.iterator();
        while (i.hasNext()) {
            out.print(indent + "    ");
            this.printValue(indent + "    ", i.next(), out);
            if (!i.hasNext()) continue;
            out.println(",");
        }
        out.println();
        out.print(indent + "]");
    }

    protected static String escape(String s) {
        if (s.indexOf(92) >= 0) {
            s = s.replaceAll("\\\\", "\\\\\\\\");
        }
        if (s.indexOf(34) >= 0) {
            s = s.replaceAll("\"", "\\\\\"");
        }
        if (s.indexOf(7) >= 0) {
            s = s.replaceAll("\\a", "\\\\b");
        }
        if (s.indexOf(9) >= 0) {
            s = s.replaceAll("\\t", "\\\\t");
        }
        if (s.indexOf(10) >= 0) {
            s = s.replaceAll("\\n", "\\\\n");
        }
        if (s.indexOf(13) >= 0) {
            s = s.replaceAll("\\r", "\\\\r");
        }
        if (s.indexOf(12) >= 0) {
            s = s.replaceAll("\\f", "\\\\f");
        }
        return s;
    }

    protected void printString(Object object, PrintWriter out) {
        if (object == null || object instanceof Number || object instanceof Boolean) {
            out.print(object);
            return;
        }
        out.print('\"');
        out.print(JsonPrinter.escape(String.valueOf(object)));
        out.print('\"');
    }

    public static void main(String ... args) {
        for (String s : args) {
            System.out.println("original:" + s);
            System.out.println("escaped:" + JsonPrinter.escape(s));
        }
    }
}

