/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.bounding.BoundingBox;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Quad;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.OptionPanel;
import com.simsilica.lemur.event.BaseAppState;
import com.simsilica.lemur.event.ConsumingMouseListener;
import com.simsilica.lemur.event.MouseEventControl;
import com.simsilica.lemur.event.MouseListener;
import com.simsilica.lemur.style.ElementId;

public class OptionPanelState
extends BaseAppState {
    private OptionPanel current;
    private Geometry blocker;
    private Node guiNode;
    private String style;
    private ElementId defaultElementId = new ElementId("optionPanel");

    public OptionPanelState() {
    }

    public OptionPanelState(String style) {
        this.style = style;
    }

    public OptionPanelState(ElementId defaultElementId, String style) {
        this.defaultElementId = defaultElementId;
        this.style = style;
    }

    public OptionPanelState(Node guiNode) {
        this.guiNode = guiNode;
    }

    public void show(String title, String message, Action ... options) {
        this.show(title, message, this.defaultElementId, options);
    }

    public void show(String title, String message, ElementId elementId, Action ... options) {
        this.show(new OptionPanel(title, message, elementId, this.style, options));
    }

    protected String getName(Throwable t) {
        String name = t.getClass().getSimpleName();
        StringBuilder sb = new StringBuilder();
        boolean last = true;
        sb.append(Character.toUpperCase(name.charAt(0)));
        for (int i = 1; i < name.length(); ++i) {
            char c = name.charAt(i);
            boolean upper = Character.isUpperCase(c);
            if (upper && !last) {
                sb.append(" ");
                last = true;
            }
            sb.append(c);
            last = upper;
        }
        return sb.toString();
    }

    public void showError(String title, Throwable t) {
        this.show(title, this.getName(t) + "\n" + t.getMessage(), this.defaultElementId, new Action[0]);
    }

    public void showError(String title, Throwable t, ElementId elementId) {
        this.show(title, this.getName(t) + "\n" + t.getMessage(), elementId, new Action[0]);
    }

    public void show(OptionPanel panel) {
        if (this.current != null) {
            this.current.close();
        }
        this.current = panel;
        Vector3f size = this.current.getPreferredSize();
        Camera cam = this.getApplication().getCamera();
        Vector3f camSize = new Vector3f((float)cam.getWidth(), (float)cam.getHeight(), 0.0f);
        Vector3f pos = camSize.mult(0.5f);
        pos.x -= size.x * 0.5f;
        pos.y += size.y * 0.5f;
        BoundingBox bb = (BoundingBox)this.getGuiNode().getWorldBound();
        if (bb != null) {
            pos.z = bb.getCenter().z + bb.getZExtent() * 2.0f;
        }
        this.setupBlocker(pos.z, camSize);
        pos.z += 1.0f;
        panel.setLocalTranslation(pos);
        this.getGuiNode().attachChild((Spatial)panel);
        panel.runEffect("open");
    }

    public void close() {
        if (this.current != null) {
            this.current.close();
        }
    }

    public OptionPanel getCurrent() {
        return this.current;
    }

    protected void setupBlocker(float z, Vector3f screenSize) {
        if (this.blocker == null) {
            Quad quad = new Quad(screenSize.x, screenSize.y);
            this.blocker = new Geometry("blocker", (Mesh)quad);
            ColorRGBA transparent = new ColorRGBA(0.0f, 0.0f, 0.0f, 0.0f);
            Material mat = GuiGlobals.getInstance().createMaterial(transparent, false).getMaterial();
            mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
            this.blocker.setMaterial(mat);
            this.blocker.setQueueBucket(RenderQueue.Bucket.Transparent);
            MouseEventControl.addListenersToSpatial((Spatial)this.blocker, (MouseListener[])new MouseListener[]{ConsumingMouseListener.INSTANCE});
        } else {
            Quad quad = (Quad)this.blocker.getMesh();
            if (quad.getWidth() != screenSize.x || quad.getHeight() != screenSize.y) {
                quad.updateGeometry(screenSize.x, screenSize.y);
            }
        }
        this.blocker.setLocalTranslation(0.0f, 0.0f, z);
        this.getGuiNode().attachChild((Spatial)this.blocker);
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyle() {
        return this.style;
    }

    public void setGuiNode(Node guiNode) {
        this.guiNode = guiNode;
    }

    public Node getGuiNode() {
        if (this.guiNode != null) {
            return this.guiNode;
        }
        Application app = this.getApplication();
        if (app instanceof SimpleApplication) {
            this.guiNode = ((SimpleApplication)app).getGuiNode();
        }
        return this.guiNode;
    }

    protected void initialize(Application app) {
    }

    protected void cleanup(Application app) {
    }

    protected void enable() {
    }

    public void update(float tpf) {
        if (this.current != null && !this.current.isVisible()) {
            this.current = null;
            this.blocker.removeFromParent();
        }
    }

    protected void disable() {
    }
}

