/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.core;

import com.simsilica.lemur.core.VersionedObject;
import com.simsilica.lemur.core.VersionedReference;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class VersionedSet<T>
extends AbstractSet<T>
implements VersionedObject<Set<T>> {
    private long version = 0L;
    private Set<T> set = new HashSet<T>();

    public VersionedSet() {
    }

    public VersionedSet(Collection<T> items) {
        this.set.addAll(items);
    }

    protected void incrementVersion() {
        ++this.version;
    }

    public long getVersion() {
        return this.version;
    }

    public Set<T> getObject() {
        return this;
    }

    public VersionedReference<Set<T>> createReference() {
        return new VersionedReference((VersionedObject)this);
    }

    @Override
    public boolean add(T val) {
        boolean result = this.set.add(val);
        if (result) {
            this.incrementVersion();
        }
        return result;
    }

    @Override
    public Iterator<T> iterator() {
        return new IteratorWrapper<T>(this.set.iterator());
    }

    @Override
    public int size() {
        return this.set.size();
    }

    private class IteratorWrapper<T>
    implements Iterator<T> {
        private Iterator<T> delegate;

        public IteratorWrapper(Iterator<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public T next() {
            return this.delegate.next();
        }

        @Override
        public void remove() {
            this.delegate.remove();
            VersionedSet.this.incrementVersion();
        }
    }
}

