/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.list;

import com.simsilica.lemur.Panel;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.core.VersionedObject;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.grid.GridModel;
import com.simsilica.lemur.list.CellRenderer;

public class ListModel<T>
implements GridModel<Panel> {
    private VersionedList<T> list;
    private CellRenderer<T> cellRenderer;

    public ListModel(VersionedList<T> list, CellRenderer<T> renderer) {
        this.list = list;
        this.cellRenderer = renderer;
    }

    public T getItem(int index) {
        return this.list.get(index);
    }

    @Override
    public int getRowCount() {
        return this.list.size();
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public Panel getCell(int row, int col, Panel existing) {
        T value = this.list.get(row);
        return this.cellRenderer.getView(value, false, existing);
    }

    @Override
    public void setCell(int row, int col, Panel value) {
        throw new UnsupportedOperationException("ListModel is read only.");
    }

    public long getVersion() {
        return this.list.getVersion();
    }

    public GridModel<Panel> getObject() {
        return this;
    }

    public VersionedReference<GridModel<Panel>> createReference() {
        return new VersionedReference((VersionedObject)this);
    }
}

