/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.list;

import com.google.common.base.Objects;
import com.simsilica.lemur.core.VersionedSet;

public class SelectionModel
extends VersionedSet<Integer> {
    private SelectionMode mode = SelectionMode.Single;
    private Integer lastAdd;

    public void setSelectionMode(SelectionMode mode) {
        if (this.mode == mode) {
            return;
        }
        if (mode == SelectionMode.Contiguous) {
            throw new UnsupportedOperationException("Contiguous selection mode not yet implemented.");
        }
        this.mode = mode;
        if (mode == SelectionMode.Single && this.size() > 1) {
            if (this.contains(this.lastAdd)) {
                this.clear();
                this.add(this.lastAdd);
            } else {
                Integer temp = (Integer)this.iterator().next();
                this.clear();
                this.add(temp);
            }
        }
    }

    public SelectionMode getSelectionMode() {
        return this.mode;
    }

    public Integer getSelection() {
        if (this.size() != 1) {
            return null;
        }
        return this.lastAdd;
    }

    public void setSelection(Integer selection) {
        if (Objects.equal((Object)selection, (Object)this.lastAdd) && this.size() == 1) {
            return;
        }
        this.clear();
        if (selection >= 0) {
            this.add(selection);
        }
    }

    @Override
    public boolean add(Integer selection) {
        if (this.mode == SelectionMode.Single) {
            if (Objects.equal((Object)selection, (Object)this.lastAdd) && this.size() == 1) {
                return false;
            }
            this.clear();
        }
        this.lastAdd = selection;
        return super.add(selection);
    }

    public static enum SelectionMode {
        Single,
        Contiguous,
        Multi;

    }
}

