/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.asset.AssetManager;
import com.jme3.asset.TextureKey;
import com.jme3.font.BitmapFont;
import com.jme3.material.MatParam;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.GeometryComparator;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Spatial;
import com.jme3.texture.Texture;
import com.simsilica.lemur.LayerComparator;
import com.simsilica.lemur.core.GuiMaterial;
import com.simsilica.lemur.core.LightingMaterialAdapter;
import com.simsilica.lemur.core.UnshadedMaterialAdapter;
import com.simsilica.lemur.event.KeyInterceptState;
import com.simsilica.lemur.event.KeyListener;
import com.simsilica.lemur.event.MouseAppState;
import com.simsilica.lemur.event.TouchAppState;
import com.simsilica.lemur.focus.FocusManagerState;
import com.simsilica.lemur.input.InputMapper;
import com.simsilica.lemur.style.Styles;
import java.io.IOException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuiGlobals {
    static Logger log = LoggerFactory.getLogger(GuiGlobals.class);
    private static GuiGlobals instance;
    private AssetManager assets;
    private InputMapper inputMapper;
    private KeyInterceptState keyInterceptor;
    private MouseAppState mouseState;
    private TouchAppState touchState;
    private FocusManagerState focusState;
    private String iconBase;
    private Styles styles;

    public static void initialize(Application app) {
        GuiGlobals.setInstance(new GuiGlobals(app));
    }

    public static void setInstance(GuiGlobals globals) {
        instance = globals;
        log.info("Initializing GuiGlobals with:" + globals);
        instance.logBuildInfo();
    }

    public static GuiGlobals getInstance() {
        return instance;
    }

    protected GuiGlobals(Application app) {
        this.assets = app.getAssetManager();
        this.keyInterceptor = new KeyInterceptState(app);
        if (app.getContext().getTouchInput() == null) {
            this.mouseState = new MouseAppState(app);
        } else {
            this.touchState = new TouchAppState(app);
        }
        this.inputMapper = new InputMapper(app.getInputManager());
        this.focusState = new FocusManagerState();
        app.getStateManager().attach((AppState)this.keyInterceptor);
        if (this.mouseState != null) {
            app.getStateManager().attach((AppState)this.mouseState);
        }
        if (this.touchState != null) {
            app.getStateManager().attach((AppState)this.touchState);
        }
        app.getStateManager().attach((AppState)this.focusState);
        this.styles = new Styles();
        this.setDefaultStyles();
        this.iconBase = this.getClass().getPackage().getName().replace('.', '/') + "/icons";
        ViewPort main = app.getViewPort();
        this.setupGuiComparators(main);
    }

    protected AssetManager getAssetManager() {
        return this.assets;
    }

    protected String getIconBase() {
        return this.iconBase;
    }

    protected void logBuildInfo() {
        try {
            URL u = Resources.getResource("lemur.build.date");
            String build = Resources.toString(u, Charsets.UTF_8);
            log.info("Lemur build date:" + build);
        }
        catch (IOException e) {
            log.error("Error reading build info", e);
        }
    }

    public void setupGuiComparators(ViewPort view) {
        RenderQueue rq = view.getQueue();
        rq.setGeometryComparator(RenderQueue.Bucket.Opaque, (GeometryComparator)new LayerComparator(rq.getGeometryComparator(RenderQueue.Bucket.Opaque), -1));
        rq.setGeometryComparator(RenderQueue.Bucket.Transparent, (GeometryComparator)new LayerComparator(rq.getGeometryComparator(RenderQueue.Bucket.Transparent), -1));
        rq.setGeometryComparator(RenderQueue.Bucket.Gui, (GeometryComparator)new LayerComparator(rq.getGeometryComparator(RenderQueue.Bucket.Gui), -1));
    }

    protected void setDefaultStyles() {
        this.styles.setDefault(this.loadFont("Interface/Fonts/Default.fnt"));
        this.styles.setDefault(ColorRGBA.LightGray);
        this.styles.getSelector(null).set("color", ColorRGBA.White);
    }

    public Styles getStyles() {
        return this.styles;
    }

    public InputMapper getInputMapper() {
        return this.inputMapper;
    }

    public void fixFont(BitmapFont font) {
        for (int i = 0; i < font.getPageSize(); ++i) {
            Material m = font.getPage(i);
            m.getAdditionalRenderState().setAlphaTest(true);
            m.getAdditionalRenderState().setAlphaFallOff(0.1f);
            m.setFloat("AlphaDiscardThreshold", 0.1f);
        }
    }

    private Texture getTexture(Material mat, String name) {
        MatParam mp = mat.getParam(name);
        if (mp == null) {
            return null;
        }
        return (Texture)mp.getValue();
    }

    public void lightFont(BitmapFont font) {
        Material[] pages = new Material[font.getPageSize()];
        for (int i = 0; i < pages.length; ++i) {
            Material original = font.getPage(i);
            Material m = new Material(this.assets, "Common/MatDefs/Light/Lighting.j3md");
            m.setTexture("DiffuseMap", this.getTexture(original, "ColorMap"));
            pages[i] = m;
        }
        font.setPages(pages);
    }

    public BitmapFont loadFont(String path) {
        BitmapFont result = this.assets.loadFont(path);
        this.fixFont(result);
        return result;
    }

    public GuiMaterial createMaterial(boolean lit) {
        if (lit) {
            return new LightingMaterialAdapter(new Material(this.assets, "Common/MatDefs/Light/Lighting.j3md"));
        }
        return new UnshadedMaterialAdapter(new Material(this.assets, "Common/MatDefs/Misc/Unshaded.j3md"));
    }

    public GuiMaterial createMaterial(ColorRGBA color, boolean lit) {
        GuiMaterial mat = this.createMaterial(lit);
        mat.setColor(color);
        return mat;
    }

    public GuiMaterial createMaterial(Texture texture, boolean lit) {
        GuiMaterial mat = this.createMaterial(lit);
        mat.setTexture(texture);
        return mat;
    }

    public Texture loadDefaultIcon(String name) {
        return this.loadTexture(this.iconBase + "/" + name, false, false);
    }

    public Texture loadTexture(String path, boolean repeat, boolean generateMips) {
        TextureKey key = new TextureKey(path);
        key.setGenerateMips(generateMips);
        Texture t = this.assets.loadTexture(key);
        if (t == null) {
            throw new RuntimeException("Error loading texture:" + path);
        }
        if (repeat) {
            t.setWrap(Texture.WrapMode.Repeat);
        } else {
            t.setWrap(Texture.WrapMode.Clamp);
        }
        return t;
    }

    public void requestFocus(Spatial s) {
        this.focusState.setFocus(s);
    }

    public void addKeyListener(KeyListener l) {
        this.keyInterceptor.addKeyListener(l);
    }

    public void removeKeyListener(KeyListener l) {
        this.keyInterceptor.removeKeyListener(l);
    }

    @Deprecated
    public ViewPort getCollisionViewPort(Spatial s) {
        if (this.mouseState != null) {
            return this.mouseState.findViewPort(s);
        }
        if (this.touchState != null) {
            return this.touchState.findViewPort(s);
        }
        return null;
    }

    @Deprecated
    public void setMouseEventsEnabled(boolean f) {
        this.setCursorEventsEnabled(f);
    }

    public void setCursorEventsEnabled(boolean f) {
        if (this.mouseState != null) {
            this.mouseState.setEnabled(f);
        }
        if (this.touchState != null) {
            this.touchState.setEnabled(f);
        }
    }

    @Deprecated
    public boolean isMouseEventsEnabled() {
        return this.isCursorEventsEnabled();
    }

    public boolean isCursorEventsEnabled() {
        if (this.mouseState != null) {
            return this.mouseState.isEnabled();
        }
        if (this.touchState != null) {
            return this.touchState.isEnabled();
        }
        return false;
    }

    @Deprecated
    public Vector3f getScreenCoordinates(Spatial relativeTo, Vector3f pos) {
        ViewPort vp = this.getCollisionViewPort(relativeTo);
        if (vp == null) {
            throw new RuntimeException("Could not find viewport for:" + relativeTo);
        }
        pos = relativeTo.localToWorld(pos, null);
        Camera cam = vp.getCamera();
        if (cam.isParallelProjection()) {
            return pos.clone();
        }
        return cam.getScreenCoordinates(pos);
    }
}

