/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.component;

import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.component.AbstractGuiComponent;
import com.simsilica.lemur.core.GuiControl;
import com.simsilica.lemur.core.GuiLayout;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SpringGridLayout
extends AbstractGuiComponent
implements GuiLayout,
Cloneable {
    private GuiControl parent;
    private Axis mainAxis;
    private Axis minorAxis;
    private Axis altAxis;
    private FillMode mainFill;
    private FillMode minorFill;
    private int rowCount;
    private int columnCount;
    private float[] rowPrefs;
    private float[] colPrefs;
    private Map<Integer, Map<Integer, Entry>> children = new HashMap<Integer, Map<Integer, Entry>>();
    private Map<Node, Entry> lookup = new HashMap<Node, Entry>();
    private Vector3f lastPreferredSize = new Vector3f();

    public SpringGridLayout() {
        this(Axis.Y, Axis.X, FillMode.Even, FillMode.Even);
    }

    public SpringGridLayout(Axis mainAxis, Axis minorAxis) {
        this(mainAxis, minorAxis, FillMode.Even, FillMode.Even);
    }

    public SpringGridLayout(Axis mainAxis, Axis minorAxis, FillMode mainFill, FillMode minorFill) {
        this.mainAxis = mainAxis;
        this.minorAxis = minorAxis;
        this.mainFill = mainFill;
        this.minorFill = minorFill;
        for (Axis a : Axis.values()) {
            if (a == mainAxis || a == minorAxis) continue;
            this.altAxis = a;
            break;
        }
    }

    @Override
    public SpringGridLayout clone() {
        SpringGridLayout result = new SpringGridLayout(this.mainAxis, this.minorAxis, this.mainFill, this.minorFill);
        return result;
    }

    @Override
    protected void invalidate() {
        if (this.parent != null) {
            this.parent.invalidate();
        }
    }

    protected final float getMajor(Vector3f v) {
        return v.get(this.mainAxis.index());
    }

    protected final float getMinor(Vector3f v) {
        return v.get(this.minorAxis.index());
    }

    protected final float getAlternate(Vector3f v) {
        return v.get(this.altAxis.index());
    }

    protected final void setMajor(Vector3f v, float f) {
        v.set(this.mainAxis.index(), f);
    }

    protected final void setMinor(Vector3f v, float f) {
        v.set(this.minorAxis.index(), f);
    }

    protected final void setAlternate(Vector3f v, float f) {
        v.set(this.altAxis.index(), f);
    }

    protected final void addMajor(Vector3f v, float f) {
        this.setMajor(v, this.getMajor(v) + f);
    }

    protected final void addMinor(Vector3f v, float f) {
        this.setMinor(v, this.getMinor(v) + f);
    }

    protected final void addAlternate(Vector3f v, float f) {
        this.setAlternate(v, this.getAlternate(v) + f);
    }

    protected float refreshRowColPrefs() {
        if (this.rowPrefs == null || this.rowPrefs.length != this.rowCount) {
            this.rowPrefs = new float[this.rowCount];
        } else {
            Arrays.fill(this.rowPrefs, 0.0f);
        }
        if (this.colPrefs == null || this.colPrefs.length != this.columnCount) {
            this.colPrefs = new float[this.columnCount];
        } else {
            Arrays.fill(this.colPrefs, 0.0f);
        }
        float maxAlternate = 0.0f;
        for (Map.Entry<Integer, Map<Integer, Entry>> rowEntry : this.children.entrySet()) {
            int row = rowEntry.getKey();
            for (Map.Entry<Integer, Entry> colEntry : rowEntry.getValue().entrySet()) {
                int col = colEntry.getKey();
                Entry e = colEntry.getValue();
                Vector3f v = e.getPreferredSize();
                this.rowPrefs[row] = Math.max(this.rowPrefs[row], this.getMajor(v));
                this.colPrefs[col] = Math.max(this.colPrefs[col], this.getMinor(v));
                maxAlternate = Math.max(this.getAlternate(v), maxAlternate);
            }
        }
        return maxAlternate;
    }

    @Override
    public void calculatePreferredSize(Vector3f size) {
        float max;
        float maxAlternate = this.refreshRowColPrefs();
        this.lastPreferredSize.set(0.0f, 0.0f, 0.0f);
        if (this.mainFill == FillMode.ForcedEven) {
            max = 0.0f;
            for (float f : this.rowPrefs) {
                max = Math.max(max, f);
            }
            this.addMajor(this.lastPreferredSize, max * (float)this.rowCount);
        } else {
            float[] arr$ = this.rowPrefs;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                float f = arr$[i$];
                this.addMajor(this.lastPreferredSize, f);
            }
        }
        if (this.minorFill == FillMode.ForcedEven) {
            max = 0.0f;
            for (float f : this.colPrefs) {
                max = Math.max(max, f);
            }
            this.addMinor(this.lastPreferredSize, max * (float)this.columnCount);
        } else {
            for (float f : this.colPrefs) {
                this.addMinor(this.lastPreferredSize, f);
            }
        }
        this.addAlternate(this.lastPreferredSize, maxAlternate);
        size.addLocal(this.lastPreferredSize);
    }

    protected float weighted(int index, float pref, float totalSize, float totalPref, int count, FillMode fill, Axis axis) {
        switch (fill) {
            case None: {
                return pref;
            }
            case First: {
                if (index == 0) {
                    return pref + (totalSize - totalPref);
                }
                return pref;
            }
            case Last: {
                if (index == count - 1) {
                    return pref + (totalSize - totalPref);
                }
                return pref;
            }
            case Even: {
                return pref + (totalSize - totalPref) / (float)count;
            }
            case ForcedEven: {
                return totalSize / (float)count;
            }
            case Proportional: {
                float relation = pref / totalPref;
                return relation * totalSize;
            }
        }
        return pref;
    }

    protected void distribute(float[] sizes, float[] prefs, float totalSize, float totalPref, FillMode fill, Axis axis) {
        for (int i = 0; i < sizes.length; ++i) {
            sizes[i] = this.weighted(i, prefs[i], totalSize, totalPref, sizes.length, fill, axis);
        }
    }

    @Override
    public void reshape(Vector3f pos, Vector3f size) {
        this.calculatePreferredSize(new Vector3f());
        float[] rowSizes = new float[this.rowCount];
        this.distribute(rowSizes, this.rowPrefs, this.getMajor(size), this.getMajor(this.lastPreferredSize), this.mainFill, this.mainAxis);
        float[] colSizes = new float[this.columnCount];
        this.distribute(colSizes, this.colPrefs, this.getMinor(size), this.getMinor(this.lastPreferredSize), this.minorFill, this.minorAxis);
        float[] rowOffsets = new float[this.rowCount];
        float f = 0.0f;
        for (int i = 0; i < rowOffsets.length; ++i) {
            rowOffsets[i] = f;
            f += rowSizes[i];
        }
        float[] colOffsets = new float[this.columnCount];
        f = 0.0f;
        for (int i = 0; i < colOffsets.length; ++i) {
            colOffsets[i] = f;
            f += colSizes[i];
        }
        for (Map<Integer, Entry> r : this.children.values()) {
            for (Entry e : r.values()) {
                Vector3f offset = new Vector3f();
                this.addMajor(offset, rowOffsets[e.row]);
                this.addMinor(offset, colOffsets[e.col]);
                offset.y *= -1.0f;
                e.setTranslation(pos.add(offset));
                Vector3f childSize = size.clone();
                this.setMajor(childSize, rowSizes[e.row]);
                this.setMinor(childSize, colSizes[e.col]);
                e.setSize(childSize);
            }
        }
    }

    protected Map<Integer, Entry> getRow(int row, boolean create) {
        Map<Integer, Entry> result = this.children.get(row);
        if (result == null && create) {
            result = new HashMap<Integer, Entry>();
            this.children.put(row, result);
        }
        return result;
    }

    public <T extends Node> T addChild(int row, int column, T n) {
        Entry previous;
        if (n != null && n.getControl(GuiControl.class) == null) {
            throw new IllegalArgumentException("Child is not GUI element.");
        }
        Map<Integer, Entry> rowMap = this.getRow(row, true);
        Entry existing = rowMap.get(column);
        if (existing != null) {
            this.remove(existing);
        }
        if ((previous = this.lookup.get(n)) != null) {
            this.remove(previous);
        }
        Entry entry = new Entry(row, column, n);
        rowMap.put(column, entry);
        if (n != null) {
            this.lookup.put(n, entry);
        }
        this.rowCount = Math.max(this.rowCount, row + 1);
        this.columnCount = Math.max(this.columnCount, column + 1);
        entry.attach();
        this.invalidate();
        return n;
    }

    @Override
    public <T extends Node> T addChild(T n, Object ... constraints) {
        int row = -1;
        int col = -1;
        for (Object o : constraints) {
            if (!(o instanceof Number)) {
                throw new IllegalArgumentException("Unknown SpringGridLayout constraint:" + o);
            }
            Number num = (Number)o;
            if (row == -1) {
                row = num.intValue();
                continue;
            }
            if (col == -1) {
                col = num.intValue();
                continue;
            }
            throw new IllegalArgumentException("Extra constraint not recognized:" + o);
        }
        if (col == -1 && row != -1) {
            col = row;
            row = this.rowCount == 0 ? 0 : this.rowCount - 1;
        } else {
            if (row == -1) {
                row = this.rowCount;
            }
            if (col == -1) {
                col = this.getRow(row, true).size();
            }
        }
        this.addChild(row, col, n);
        return n;
    }

    public Node getChild(int row, int column) {
        Map<Integer, Entry> rowMap = this.getRow(row, false);
        if (rowMap == null) {
            return null;
        }
        Entry existing = rowMap.get(column);
        if (existing == null) {
            return null;
        }
        return existing.child;
    }

    @Override
    public void removeChild(Node n) {
        Entry entry = this.lookup.remove(n);
        if (entry != null) {
            this.remove(entry);
        }
    }

    @Override
    public Collection<Node> getChildren() {
        return Collections.unmodifiableSet(this.lookup.keySet());
    }

    @Override
    public void clearChildren() {
        if (this.parent != null) {
            for (Entry e : this.lookup.values()) {
                e.detach();
            }
        }
        this.children.clear();
        this.lookup.clear();
        this.children.clear();
        this.rowCount = 0;
        this.columnCount = 0;
        this.invalidate();
    }

    protected void remove(Entry e) {
        e.detach();
        Map<Integer, Entry> rowMap = this.getRow(e.row, false);
        if (rowMap == null) {
            return;
        }
        rowMap.remove(e.col);
        if (e.child != null) {
            this.lookup.remove(e.child);
        }
        this.rowCount = 0;
        this.columnCount = 0;
        for (Entry child : this.lookup.values()) {
            if (child.row + 1 > this.rowCount) {
                this.rowCount = child.row + 1;
            }
            if (child.col + 1 <= this.columnCount) continue;
            this.columnCount = child.col + 1;
        }
        this.invalidate();
    }

    @Override
    public void attach(GuiControl parent) {
        this.parent = parent;
        Node self = parent.getNode();
        for (Map<Integer, Entry> r : this.children.values()) {
            for (Entry e : r.values()) {
                e.attach();
            }
        }
    }

    @Override
    public void detach(GuiControl parent) {
        this.parent = null;
        for (Map<Integer, Entry> r : this.children.values()) {
            for (Entry e : r.values()) {
                e.detach();
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + "[mainAxis=" + (Object)((Object)this.mainAxis) + ", minorAxis=" + (Object)((Object)this.minorAxis) + ", mainFill=" + (Object)((Object)this.mainFill) + ", minorFill=" + (Object)((Object)this.minorFill) + "]";
    }

    protected class Entry {
        int row;
        int col;
        Node child;

        public Entry(int row, int col, Node child) {
            this.row = row;
            this.col = col;
            this.child = child;
        }

        public Vector3f getPreferredSize() {
            if (this.child == null) {
                return new Vector3f(0.0f, 0.0f, 0.0f);
            }
            return ((GuiControl)this.child.getControl(GuiControl.class)).getPreferredSize();
        }

        public void setTranslation(Vector3f v) {
            if (this.child == null) {
                return;
            }
            this.child.setLocalTranslation(v);
        }

        public void setSize(Vector3f v) {
            if (this.child == null) {
                return;
            }
            ((GuiControl)this.child.getControl(GuiControl.class)).setSize(v);
        }

        public void attach() {
            if (this.child == null) {
                return;
            }
            if (SpringGridLayout.this.parent == null) {
                return;
            }
            SpringGridLayout.this.parent.getNode().attachChild((Spatial)this.child);
        }

        public void detach() {
            if (this.child == null) {
                return;
            }
            if (SpringGridLayout.this.parent == null) {
                return;
            }
            SpringGridLayout.this.parent.getNode().detachChild((Spatial)this.child);
        }
    }
}

