/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.component;

import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.component.AbstractGuiComponent;
import com.simsilica.lemur.component.ColoredComponent;
import com.simsilica.lemur.core.GuiControl;
import com.simsilica.lemur.core.GuiMaterial;
import com.simsilica.lemur.geom.TbtQuad;

public class TbtQuadBackgroundComponent
extends AbstractGuiComponent
implements Cloneable,
ColoredComponent {
    private TbtQuad quad;
    private Geometry background;
    private Texture texture;
    private ColorRGBA color;
    private float alpha = 1.0f;
    private GuiMaterial material;
    private float xMargin = 0.0f;
    private float yMargin = 0.0f;
    private float zOffset = 0.01f;
    private boolean lit = false;

    public TbtQuadBackgroundComponent(TbtQuad quad) {
        this(quad, null, 0.0f, 0.0f, 0.01f, false);
    }

    public TbtQuadBackgroundComponent(TbtQuad quad, Texture texture) {
        this(quad, texture, 0.0f, 0.0f, 0.01f, false);
    }

    public TbtQuadBackgroundComponent(TbtQuad quad, Texture texture, float xMargin, float yMargin) {
        this(quad, texture, xMargin, yMargin, 0.01f, false);
    }

    public TbtQuadBackgroundComponent(TbtQuad quad, Texture texture, float xMargin, float yMargin, float zOffset, boolean lit) {
        this.quad = quad;
        this.xMargin = xMargin;
        this.yMargin = yMargin;
        this.zOffset = zOffset;
        this.lit = lit;
        this.setTexture(texture);
        this.createMaterial();
    }

    public static TbtQuadBackgroundComponent create(String texture, float imageScale, int x1, int y1, int x2, int y2, float zOffset, boolean lit) {
        Texture t = GuiGlobals.getInstance().loadTexture(texture, false, false);
        return TbtQuadBackgroundComponent.create(t, imageScale, x1, y1, x2, y2, zOffset, lit);
    }

    public static TbtQuadBackgroundComponent create(Texture t, float imageScale, int x1, int y1, int x2, int y2, float zOffset, boolean lit) {
        Image img = t.getImage();
        TbtQuad q = new TbtQuad(img.getWidth(), img.getHeight(), x1, y1, x2, y2, img.getWidth(), img.getHeight(), imageScale);
        TbtQuadBackgroundComponent c = new TbtQuadBackgroundComponent(q, t, x1, y1, zOffset, lit);
        return c;
    }

    @Override
    public TbtQuadBackgroundComponent clone() {
        TbtQuadBackgroundComponent result = (TbtQuadBackgroundComponent)super.clone();
        result.background = null;
        result.material = this.material.clone();
        result.quad = result.quad.clone();
        return result;
    }

    @Override
    public void attach(GuiControl parent) {
        super.attach(parent);
    }

    @Override
    public void detach(GuiControl parent) {
        if (this.background != null) {
            this.getNode().detachChild((Spatial)this.background);
        }
        super.detach(parent);
    }

    @Override
    public void setColor(ColorRGBA c) {
        this.color = c;
        this.resetColor();
    }

    protected void resetColor() {
        if (this.material == null) {
            return;
        }
        if (this.alpha >= 1.0f) {
            this.material.setColor(this.color);
        } else {
            ColorRGBA adjusted = this.color.clone();
            adjusted.a *= this.alpha;
            this.material.setColor(adjusted);
        }
    }

    @Override
    public ColorRGBA getColor() {
        return this.color;
    }

    @Override
    public void setAlpha(float f) {
        if (this.alpha == f) {
            return;
        }
        this.alpha = f;
        this.resetColor();
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    public void setTexture(Texture t) {
        if (this.texture == t) {
            return;
        }
        this.texture = t;
        if (this.material != null) {
            this.material.setTexture(this.texture);
        }
    }

    public Texture getTexture() {
        return this.texture;
    }

    public void setMargin(float x, float y) {
        this.xMargin = x;
        this.yMargin = y;
        this.invalidate();
    }

    public Vector2f getMargin() {
        return new Vector2f(this.xMargin, this.yMargin);
    }

    public void setZOffset(float z) {
        this.zOffset = z;
        this.invalidate();
    }

    public float getZOffset() {
        return this.zOffset;
    }

    public GuiMaterial getMaterial() {
        return this.material;
    }

    @Override
    public void calculatePreferredSize(Vector3f size) {
        size.x += this.xMargin * 2.0f;
        size.y += this.yMargin * 2.0f;
        size.z += Math.abs(this.zOffset);
    }

    @Override
    public void reshape(Vector3f pos, Vector3f size) {
        this.refreshBackground(size);
        this.background.setLocalTranslation(pos.x, pos.y - size.y, pos.z);
        pos.x += this.xMargin;
        pos.y -= this.yMargin;
        pos.z += this.zOffset;
        size.x -= this.xMargin * 2.0f;
        size.y -= this.yMargin * 2.0f;
        size.z -= Math.abs(this.zOffset);
    }

    protected void createMaterial() {
        this.material = GuiGlobals.getInstance().createMaterial(this.texture, this.lit);
        if (this.color != null) {
            this.material.setColor(this.color);
        }
        this.material.getMaterial().getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
    }

    protected void createGeometry() {
        this.background = new Geometry("background", (Mesh)this.quad);
        if (this.material == null) {
            this.createMaterial();
        }
        this.background.setMaterial(this.material.getMaterial());
        this.getNode().attachChild((Spatial)this.background);
    }

    protected void refreshBackground(Vector3f size) {
        if (this.background == null) {
            this.createGeometry();
        }
        TbtQuad q = (TbtQuad)this.background.getMesh();
        q.updateSize(size.x, size.y);
    }

    public String toString() {
        return this.getClass().getName() + "[texture=" + this.texture + ", color=" + this.color + ", alpha=" + this.alpha + ", margin=" + this.getMargin() + ", zOffset=" + this.zOffset + "]";
    }
}

