/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.es.sql;

import com.simsilica.es.ComponentFilter;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityId;
import com.simsilica.es.base.ComponentHandler;
import com.simsilica.es.sql.ComponentTable;
import com.simsilica.es.sql.SqlEntityData;
import com.simsilica.es.sql.SqlSession;
import java.sql.SQLException;
import java.util.Set;

public class SqlComponentHandler<T extends EntityComponent>
implements ComponentHandler<T> {
    private SqlEntityData parent;
    private Class<T> type;
    private ComponentTable<T> table;

    public SqlComponentHandler(SqlEntityData parent, Class<T> type) {
        this.parent = parent;
        this.type = type;
        try {
            this.table = ComponentTable.create(parent.getSession(), type);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error creating table for component type:" + type, e);
        }
    }

    protected SqlSession getSession() throws SQLException {
        return this.parent.getSession();
    }

    @Override
    public void setComponent(EntityId entityId, T component) {
        try {
            this.table.setComponent(this.getSession(), entityId, component);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error setting component:" + component + " on entity:" + entityId, e);
        }
    }

    @Override
    public boolean removeComponent(EntityId entityId) {
        try {
            return this.table.removeComponent(this.getSession(), entityId);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error removing component type:" + this.type + " from entity:" + entityId);
        }
    }

    @Override
    public T getComponent(EntityId entityId) {
        try {
            return (T)((EntityComponent)this.table.getComponent(this.getSession(), entityId));
        }
        catch (SQLException e) {
            throw new RuntimeException("Error retrieving component type:" + this.type + " for entity:" + entityId, e);
        }
    }

    @Override
    public Set<EntityId> getEntities() {
        try {
            return this.table.getEntityIds(this.getSession());
        }
        catch (SQLException e) {
            throw new RuntimeException("Error retrieving component entities for type:" + this.type);
        }
    }

    @Override
    public Set<EntityId> getEntities(ComponentFilter filter) {
        if (filter == null) {
            return this.getEntities();
        }
        try {
            return this.table.getEntityIds(this.getSession(), filter);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error retrieving component entities for type:" + this.type, e);
        }
    }

    @Override
    public EntityId findEntity(ComponentFilter filter) {
        if (filter == null) {
            return null;
        }
        try {
            return this.table.getEntityId(this.getSession(), filter);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error retrieving entity for filter:" + filter, e);
        }
    }
}

