/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur;

import com.jme3.renderer.Camera;
import com.jme3.renderer.queue.GeometryComparator;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;

public class LayerComparator
implements GeometryComparator {
    public static final String LAYER = "layer";
    public static final String EFFECTIVE_LAYER = "effectiveLayer";
    private GeometryComparator delegate;
    private int bias;

    public LayerComparator(GeometryComparator delegate) {
        this(delegate, 1);
    }

    public LayerComparator(GeometryComparator delegate, int bias) {
        this.delegate = delegate;
        this.bias = -bias;
    }

    public static void setLayer(Spatial s, int layer) {
        if (layer == 0) {
            s.setUserData(LAYER, null);
        } else {
            s.setUserData(LAYER, (Object)layer);
        }
    }

    public static void resetLayer(Spatial s, int layer) {
        LayerComparator.setLayer(s, layer);
        LayerComparator.clearEffectiveLayer(s);
    }

    public static Integer getLayer(Spatial s) {
        return (Integer)s.getUserData(LAYER);
    }

    public static void clearEffectiveLayer(Spatial s) {
        s.setUserData(EFFECTIVE_LAYER, null);
        if (s instanceof Node) {
            for (Spatial child : ((Node)s).getChildren()) {
                LayerComparator.clearEffectiveLayer(child);
            }
        }
    }

    public void setCamera(Camera cam) {
        this.delegate.setCamera(cam);
    }

    protected float calculateEffectiveLayer(Geometry g) {
        Integer childLayer = (Integer)g.getUserData(LAYER);
        float layer = childLayer != null ? (float)(childLayer + 1) : 1.0f;
        for (Node s = g.getParent(); s != null; s = s.getParent()) {
            Integer i = (Integer)s.getUserData(LAYER);
            if (i == null) continue;
            layer *= 0.1f;
            layer += i != null ? (float)(i + 1) : 1.0f;
        }
        return layer;
    }

    public float getLayer(Geometry g) {
        Float d = (Float)g.getUserData(EFFECTIVE_LAYER);
        if (d != null) {
            return d.floatValue();
        }
        d = Float.valueOf(this.calculateEffectiveLayer(g));
        g.setUserData(EFFECTIVE_LAYER, (Object)d);
        return d.floatValue();
    }

    public int compare(Geometry g1, Geometry g2) {
        float l2;
        float l1 = this.getLayer(g1);
        if (l1 < (l2 = this.getLayer(g2))) {
            return -1 * this.bias;
        }
        if (l2 < l1) {
            return 1 * this.bias;
        }
        return this.delegate.compare((Object)g1, (Object)g2);
    }
}

