/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur;

import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Insets3f;
import com.simsilica.lemur.component.ColoredComponent;
import com.simsilica.lemur.component.InsetsComponent;
import com.simsilica.lemur.component.QuadBackgroundComponent;
import com.simsilica.lemur.core.GuiComponent;
import com.simsilica.lemur.core.GuiControl;
import com.simsilica.lemur.effect.Effect;
import com.simsilica.lemur.effect.EffectControl;
import com.simsilica.lemur.event.MouseEventControl;
import com.simsilica.lemur.event.MouseListener;
import com.simsilica.lemur.style.Attributes;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.lemur.style.StyleAttribute;
import com.simsilica.lemur.style.StyleDefaults;
import com.simsilica.lemur.style.Styles;
import java.util.Collections;
import java.util.Map;

public class Panel
extends Node {
    public static final String ELEMENT_ID = "panel";
    public static final String LAYER_BACKGROUND = "background";
    public static final String LAYER_INSETS = "insets";
    public static final String LAYER_BORDER = "border";
    private ElementId elementId;
    private String style;

    public Panel() {
        this(true, new ElementId(ELEMENT_ID), null);
    }

    public Panel(String style) {
        this(true, new ElementId(ELEMENT_ID), style);
    }

    public Panel(ElementId elementId, String style) {
        this(true, elementId, style);
    }

    public Panel(float width, float height) {
        this(true, new ElementId(ELEMENT_ID), null);
        ((GuiControl)this.getControl(GuiControl.class)).setPreferredSize(new Vector3f(width, height, 0.0f));
    }

    public Panel(float width, float height, ElementId elementId, String style) {
        this(true, elementId, style);
        ((GuiControl)this.getControl(GuiControl.class)).setPreferredSize(new Vector3f(width, height, 0.0f));
    }

    public Panel(float width, float height, ColorRGBA backgroundColor) {
        this(true, new ElementId(ELEMENT_ID), null);
        ((GuiControl)this.getControl(GuiControl.class)).setPreferredSize(new Vector3f(width, height, 0.0f));
        if (this.getBackground() instanceof QuadBackgroundComponent) {
            ((QuadBackgroundComponent)this.getBackground()).setColor(backgroundColor);
        }
    }

    public Panel(float width, float height, ColorRGBA backgroundColor, String style) {
        this(true, new ElementId(ELEMENT_ID), style);
        ((GuiControl)this.getControl(GuiControl.class)).setPreferredSize(new Vector3f(width, height, 0.0f));
        if (this.getBackground() instanceof QuadBackgroundComponent) {
            ((QuadBackgroundComponent)this.getBackground()).setColor(backgroundColor);
        }
    }

    public Panel(float width, float height, String style) {
        this(true, new ElementId(ELEMENT_ID), style);
        ((GuiControl)this.getControl(GuiControl.class)).setPreferredSize(new Vector3f(width, height, 0.0f));
    }

    protected Panel(boolean applyStyles, float width, float height, ElementId elementId, String style) {
        this(applyStyles, elementId, style);
        ((GuiControl)this.getControl(GuiControl.class)).setPreferredSize(new Vector3f(width, height, 0.0f));
    }

    protected Panel(boolean applyStyles, ElementId elementId, String style) {
        this.elementId = elementId;
        this.style = style;
        GuiControl gui = new GuiControl(LAYER_INSETS, LAYER_BORDER, LAYER_BACKGROUND);
        this.addControl((Control)gui);
        if (applyStyles) {
            Styles styles = GuiGlobals.getInstance().getStyles();
            styles.applyStyles((Object)this, elementId.getId(), style);
        }
    }

    public ElementId getElementId() {
        return this.elementId;
    }

    public String getStyle() {
        return this.style;
    }

    public void setSize(Vector3f size) {
        ((GuiControl)this.getControl(GuiControl.class)).setSize(size);
    }

    public Vector3f getSize() {
        return ((GuiControl)this.getControl(GuiControl.class)).getSize();
    }

    @StyleAttribute(value="preferredSize", lookupDefault=false)
    public void setPreferredSize(Vector3f size) {
        ((GuiControl)this.getControl(GuiControl.class)).setPreferredSize(size);
    }

    public Vector3f getPreferredSize() {
        return ((GuiControl)this.getControl(GuiControl.class)).getPreferredSize();
    }

    public void addMouseListener(MouseListener l) {
        MouseEventControl mc = (MouseEventControl)this.getControl(MouseEventControl.class);
        if (mc == null) {
            this.addControl((Control)new MouseEventControl(l));
            return;
        }
        mc.addMouseListener(l);
    }

    public void removeMouseListener(MouseListener l) {
        MouseEventControl mc = (MouseEventControl)this.getControl(MouseEventControl.class);
        if (mc == null) {
            return;
        }
        mc.removeMouseListener(l);
        if (mc.isEmpty()) {
            this.removeControl((Control)mc);
        }
    }

    @StyleDefaults(value="panel")
    public static void initializeDefaultStyles(Attributes attrs) {
        attrs.set(LAYER_BACKGROUND, new QuadBackgroundComponent(ColorRGBA.Gray), false);
    }

    @StyleAttribute(value="background", lookupDefault=false)
    public void setBackground(GuiComponent bg) {
        ((GuiControl)this.getControl(GuiControl.class)).setComponent(LAYER_BACKGROUND, bg);
    }

    public GuiComponent getBackground() {
        return ((GuiControl)this.getControl(GuiControl.class)).getComponent(LAYER_BACKGROUND);
    }

    @StyleAttribute(value="border", lookupDefault=false)
    public void setBorder(GuiComponent bg) {
        ((GuiControl)this.getControl(GuiControl.class)).setComponent(LAYER_BORDER, bg);
    }

    public GuiComponent getBorder() {
        return ((GuiControl)this.getControl(GuiControl.class)).getComponent(LAYER_BORDER);
    }

    @StyleAttribute(value="insets", lookupDefault=false)
    public void setInsets(Insets3f i) {
        InsetsComponent ic = this.getInsetsComponent();
        if (i != null) {
            if (ic == null) {
                ic = new InsetsComponent(i);
            } else {
                ic.setInsets(i);
            }
        } else {
            ic = null;
        }
        this.setInsetsComponent(ic);
    }

    public Insets3f getInsets() {
        InsetsComponent ic = (InsetsComponent)((GuiControl)this.getControl(GuiControl.class)).getComponent(LAYER_INSETS);
        return ic == null ? null : ic.getInsets();
    }

    @StyleAttribute(value="insetsComponent", lookupDefault=false)
    public void setInsetsComponent(InsetsComponent ic) {
        ((GuiControl)this.getControl(GuiControl.class)).setComponent(LAYER_INSETS, ic);
    }

    public InsetsComponent getInsetsComponent() {
        InsetsComponent ic = (InsetsComponent)((GuiControl)this.getControl(GuiControl.class)).getComponent(LAYER_INSETS);
        return ic;
    }

    @StyleAttribute(value="alpha", lookupDefault=false)
    public void setAlpha(float alpha) {
        this.setAlpha(alpha, true);
    }

    public void setAlpha(float alpha, boolean recursive) {
        for (GuiComponent c : ((GuiControl)this.getControl(GuiControl.class)).getComponents()) {
            if (!(c instanceof ColoredComponent)) continue;
            ((ColoredComponent)((Object)c)).setAlpha(alpha);
        }
        if (recursive) {
            for (Spatial s : this.getChildren()) {
                this.setChildAlpha(s, alpha);
            }
        }
    }

    protected void setChildAlpha(Spatial child, float alpha) {
        if (child instanceof Panel) {
            ((Panel)child).setAlpha(alpha, true);
        } else if (child instanceof Node) {
            for (Spatial s : ((Node)child).getChildren()) {
                this.setChildAlpha(s, alpha);
            }
        }
    }

    public float getAlpha() {
        for (GuiComponent c : ((GuiControl)this.getControl(GuiControl.class)).getComponents()) {
            if (!(c instanceof ColoredComponent)) continue;
            return ((ColoredComponent)((Object)c)).getAlpha();
        }
        return 1.0f;
    }

    public void runEffect(String effectName) {
        EffectControl effects = (EffectControl)this.getControl(EffectControl.class);
        if (effects != null) {
            effects.runEffect(effectName);
        }
    }

    public void addEffect(String effectName, Effect<? super Panel> effect) {
        EffectControl<? super Panel> effects = (EffectControl<? super Panel>)this.getControl(EffectControl.class);
        if (effects == null) {
            effects = new EffectControl<Panel>();
            this.addControl((Control)effects);
        }
        effects.addEffect(effectName, effect);
    }

    public Effect<? super Panel> removeEffect(String effectName) {
        EffectControl effects = (EffectControl)this.getControl(EffectControl.class);
        if (effects == null) {
            return null;
        }
        return effects.removeEffect(effectName);
    }

    public boolean hasEffect(String effectName) {
        EffectControl effects = (EffectControl)this.getControl(EffectControl.class);
        if (effects == null) {
            return false;
        }
        return effects.hasEffect(effectName);
    }

    @StyleAttribute(value="effects", lookupDefault=false)
    public void setEffects(Map<String, Effect<? super Panel>> map) {
        for (Map.Entry<String, Effect<? super Panel>> e : map.entrySet()) {
            if (e.getValue() != null) {
                this.addEffect(e.getKey(), e.getValue());
                continue;
            }
            this.removeEffect(e.getKey());
        }
    }

    public Map<String, Effect<? super Panel>> getEffects() {
        EffectControl effects = (EffectControl)this.getControl(EffectControl.class);
        if (effects == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(effects.getEffects());
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "[elementId=" + this.getElementId() + "]";
    }
}

