/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur;

import com.simsilica.lemur.Axis;
import com.simsilica.lemur.Button;
import com.simsilica.lemur.CheckboxModel;
import com.simsilica.lemur.Command;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.DefaultCheckboxModel;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.component.BorderLayout;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiControl;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.lemur.style.Styles;

public class RollupPanel
extends Panel {
    private BorderLayout layout;
    private Container titleContainer;
    private Button title;
    private Panel contents;
    private CheckboxModel openModel = new OpenCheckboxModel(true);
    private VersionedReference<Boolean> openRef = this.openModel.createReference();

    public RollupPanel(String title, String style) {
        this(title, null, true, new ElementId("rollup"), style);
    }

    public RollupPanel(String title, ElementId elementId, String style) {
        this(title, null, true, elementId, style);
    }

    public RollupPanel(String title, Panel contents, String style) {
        this(title, contents, true, new ElementId("rollup"), style);
    }

    public RollupPanel(String title, Panel contents, ElementId elementId, String style) {
        this(title, contents, true, elementId, style);
    }

    protected RollupPanel(String titleString, Panel contents, boolean applyStyles, ElementId elementId, String style) {
        super(false, elementId, style);
        this.layout = new BorderLayout();
        ((GuiControl)this.getControl(GuiControl.class)).setLayout(this.layout);
        this.contents = contents;
        if (contents != null) {
            this.layout.addChild(contents, new Object[]{BorderLayout.Position.Center});
        }
        this.titleContainer = new Container(new SpringGridLayout(Axis.X, Axis.Y, FillMode.First, FillMode.Even), elementId.child("titlebar"), style);
        this.layout.addChild(this.titleContainer, new Object[]{BorderLayout.Position.North});
        this.title = new Button(titleString, elementId.child("title"), style);
        this.titleContainer.addChild(this.title, new Object[0]);
        this.title.addClickCommands(new ToggleOpenCommand());
        if (applyStyles) {
            Styles styles = GuiGlobals.getInstance().getStyles();
            styles.applyStyles((Object)this, elementId, style);
        }
        this.resetOpen();
    }

    public void setContents(Panel p) {
        if (this.contents == p) {
            return;
        }
        if (this.contents != null) {
            this.layout.removeChild(this.contents);
        }
        this.contents = p;
        if (this.contents != null) {
            this.resetOpen();
        }
    }

    public Panel getContents() {
        return this.contents;
    }

    public void setTitle(String titleString) {
        this.title.setText(titleString);
    }

    public String getTitle() {
        return this.title.getText();
    }

    public Button getTitleElement() {
        return this.title;
    }

    public Container getTitleContainer() {
        return this.titleContainer;
    }

    public void setOpen(boolean open) {
        this.openModel.setChecked(open);
        this.resetOpen();
    }

    public boolean isOpen() {
        return (Boolean)this.openModel.getObject();
    }

    public void setOpenModel(CheckboxModel cm) {
        if (this.openModel == cm) {
            return;
        }
        this.openModel = cm;
        this.openRef = this.openModel.createReference();
        this.resetOpen();
    }

    public CheckboxModel getOpenModel() {
        return this.openModel;
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        if (this.openRef != null && this.openRef.update()) {
            this.resetOpen();
        }
    }

    protected void resetOpen() {
        if (this.contents == null) {
            return;
        }
        if (this.isOpen()) {
            if (this.contents.getParent() == null) {
                this.layout.addChild(this.contents, new Object[]{BorderLayout.Position.Center});
            }
        } else if (this.contents.getParent() != null) {
            this.layout.removeChild(this.contents);
        }
    }

    protected class OpenCheckboxModel
    extends DefaultCheckboxModel {
        public OpenCheckboxModel(boolean initial) {
            super(initial);
        }

        @Override
        public void setChecked(boolean b) {
            super.setChecked(b);
            RollupPanel.this.resetOpen();
        }
    }

    protected class ToggleOpenCommand
    implements Command<Button> {
        protected ToggleOpenCommand() {
        }

        @Override
        public void execute(Button source) {
            RollupPanel.this.setOpen(!RollupPanel.this.isOpen());
        }
    }
}

