/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur;

import com.jme3.font.BitmapFont;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.control.Control;
import com.simsilica.lemur.DocumentModel;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.HAlignment;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.VAlignment;
import com.simsilica.lemur.component.QuadBackgroundComponent;
import com.simsilica.lemur.component.TextEntryComponent;
import com.simsilica.lemur.core.GuiControl;
import com.simsilica.lemur.event.FocusMouseListener;
import com.simsilica.lemur.event.KeyAction;
import com.simsilica.lemur.event.KeyActionListener;
import com.simsilica.lemur.event.MouseEventControl;
import com.simsilica.lemur.style.Attributes;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.lemur.style.StyleAttribute;
import com.simsilica.lemur.style.StyleDefaults;
import com.simsilica.lemur.style.Styles;
import java.util.Map;

public class TextField
extends Panel {
    public static final String ELEMENT_ID = "textField";
    public static final String LAYER_TEXT = "text";
    private TextEntryComponent text;

    public TextField(String text) {
        this(new DocumentModel(text), true, new ElementId(ELEMENT_ID), null);
    }

    public TextField(String text, String style) {
        this(new DocumentModel(text), true, new ElementId(ELEMENT_ID), style);
    }

    public TextField(String text, ElementId elementId) {
        this(new DocumentModel(text), true, elementId, null);
    }

    public TextField(String text, ElementId elementId, String style) {
        this(new DocumentModel(text), true, elementId, style);
    }

    public TextField(DocumentModel model, String style) {
        this(model, true, new ElementId(ELEMENT_ID), style);
    }

    protected TextField(DocumentModel model, boolean applyStyles, ElementId elementId, String style) {
        super(false, elementId, style);
        ((GuiControl)this.getControl(GuiControl.class)).setLayerOrder("insets", "border", "background", LAYER_TEXT);
        Styles styles = GuiGlobals.getInstance().getStyles();
        BitmapFont font = styles.getAttributes(elementId.getId(), style).get("font", BitmapFont.class);
        this.text = new TextEntryComponent(model, font);
        ((GuiControl)this.getControl(GuiControl.class)).setComponent(LAYER_TEXT, this.text);
        this.addControl((Control)new MouseEventControl(FocusMouseListener.INSTANCE));
        if (applyStyles) {
            styles.applyStyles((Object)this, elementId.getId(), style);
        }
    }

    @StyleDefaults(value="textField")
    public static void initializeDefaultStyles(Attributes attrs) {
        attrs.set("background", new QuadBackgroundComponent(new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f)), false);
        attrs.set("singleLine", true);
    }

    public Map<KeyAction, KeyActionListener> getActionMap() {
        return this.text.getActionMap();
    }

    public DocumentModel getDocumentModel() {
        return this.text.getDocumentModel();
    }

    @StyleAttribute(value="text", lookupDefault=false)
    public void setText(String s) {
        this.text.setText(s);
    }

    public String getText() {
        return this.text == null ? null : this.text.getText();
    }

    @StyleAttribute(value="textVAlignment", lookupDefault=false)
    public void setTextVAlignment(VAlignment a) {
        this.text.setVAlignment(a);
    }

    public VAlignment getTextVAlignment() {
        return this.text.getVAlignment();
    }

    @StyleAttribute(value="textHAlignment", lookupDefault=false)
    public void setTextHAlignment(HAlignment a) {
        this.text.setHAlignment(a);
    }

    public HAlignment getTextHAlignment() {
        return this.text.getHAlignment();
    }

    @StyleAttribute(value="font")
    public void setFont(BitmapFont f) {
        this.text.setFont(f);
    }

    public BitmapFont getFont() {
        return this.text.getFont();
    }

    @StyleAttribute(value="color")
    public void setColor(ColorRGBA color) {
        this.text.setColor(color);
    }

    public ColorRGBA getColor() {
        return this.text == null ? null : this.text.getColor();
    }

    @StyleAttribute(value="fontSize")
    public void setFontSize(float f) {
        this.text.setFontSize(f);
    }

    public float getFontSize() {
        return this.text == null ? 0.0f : this.text.getFontSize();
    }

    @StyleAttribute(value="singleLine")
    public void setSingleLine(boolean f) {
        this.text.setSingleLine(f);
    }

    public boolean isSingleLine() {
        return this.text.isSingleLine();
    }

    @StyleAttribute(value="preferredWidth")
    public void setPreferredWidth(float f) {
        this.text.setPreferredWidth(f);
    }

    public float getPreferredWidth() {
        return this.text.getPreferredWidth();
    }

    @Override
    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "[text=" + this.getText() + ", color=" + this.getColor() + ", elementId=" + this.getElementId() + "]";
    }
}

