/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.component;

import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.component.AbstractGuiComponent;
import com.simsilica.lemur.core.GuiControl;
import com.simsilica.lemur.core.GuiLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class BoxLayout
extends AbstractGuiComponent
implements GuiLayout,
Cloneable {
    private GuiControl parent;
    private Axis axis;
    private FillMode fill;
    private List<Node> children = new ArrayList<Node>();
    private List<Vector3f> preferredSizes = new ArrayList<Vector3f>();
    private Vector3f lastPreferredSize;

    public BoxLayout() {
        this(Axis.Y, FillMode.Even);
    }

    public BoxLayout(Axis axis, FillMode fill) {
        this.axis = axis;
        this.fill = fill;
    }

    @Override
    public BoxLayout clone() {
        BoxLayout result = (BoxLayout)super.clone();
        result.parent = null;
        result.children = new ArrayList<Node>();
        result.preferredSizes = new ArrayList<Vector3f>();
        result.lastPreferredSize = null;
        return result;
    }

    @Override
    protected void invalidate() {
        if (this.parent != null) {
            this.parent.invalidate();
        }
    }

    @Override
    public void calculatePreferredSize(Vector3f size) {
        Vector3f pref = new Vector3f();
        this.preferredSizes.clear();
        for (Node n : this.children) {
            Vector3f v = ((GuiControl)n.getControl(GuiControl.class)).getPreferredSize();
            this.preferredSizes.add(v.clone());
            switch (this.axis) {
                case X: {
                    v.x += pref.x;
                    break;
                }
                case Y: {
                    v.y += pref.y;
                    break;
                }
                case Z: {
                    v.z += pref.z;
                }
            }
            pref.maxLocal(v);
        }
        this.lastPreferredSize = pref.clone();
        size.set(pref);
    }

    @Override
    public void reshape(Vector3f pos, Vector3f size) {
        this.calculatePreferredSize(new Vector3f());
        float axisPrefTotal = 0.0f;
        float axisSizeTotal = 0.0f;
        switch (this.axis) {
            case X: {
                axisPrefTotal = this.lastPreferredSize.x;
                axisSizeTotal = size.x;
                break;
            }
            case Y: {
                axisPrefTotal = this.lastPreferredSize.y;
                axisSizeTotal = size.y;
                break;
            }
            case Z: {
                axisPrefTotal = this.lastPreferredSize.z;
                axisSizeTotal = size.z;
            }
        }
        Vector3f p = pos.clone();
        for (int i = 0; i < this.children.size(); ++i) {
            Node n = this.children.get(i);
            Vector3f pref = this.preferredSizes.get(i).clone();
            float axisPref = 0.0f;
            float axisSize = 0.0f;
            switch (this.axis) {
                case X: {
                    axisPref = pref.x;
                    axisSize = size.x;
                    pref.y = size.y;
                    pref.z = size.z;
                    break;
                }
                case Y: {
                    axisPref = pref.y;
                    axisSize = size.y;
                    pref.x = size.x;
                    pref.z = size.z;
                    break;
                }
                case Z: {
                    axisPref = pref.z;
                    axisSize = size.z;
                    pref.x = size.x;
                    pref.y = size.y;
                }
            }
            switch (this.fill) {
                case None: {
                    axisSize = axisPref;
                    break;
                }
                case Even: {
                    axisSize = axisPref + (axisSizeTotal - axisPrefTotal) / (float)this.children.size();
                    break;
                }
                case Proportional: {
                    float relation = axisPref / axisPrefTotal;
                    axisSize = relation * axisSizeTotal;
                }
            }
            n.setLocalTranslation(p.clone());
            switch (this.axis) {
                case X: {
                    pref.x = axisSize;
                    p.x += axisSize;
                    break;
                }
                case Y: {
                    pref.y = axisSize;
                    p.y -= axisSize;
                    break;
                }
                case Z: {
                    pref.z = axisSize;
                    p.z += axisSize;
                }
            }
            ((GuiControl)n.getControl(GuiControl.class)).setSize(pref);
        }
    }

    @Override
    public <T extends Node> T addChild(T n, Object ... constraints) {
        if (n.getControl(GuiControl.class) == null) {
            throw new IllegalArgumentException("Child is not GUI element.");
        }
        if (constraints != null && constraints.length > 0) {
            throw new IllegalArgumentException("Box layout does not take constraints.");
        }
        this.children.add(n);
        if (this.parent != null) {
            this.parent.getNode().attachChild(n);
        }
        this.invalidate();
        return n;
    }

    @Override
    public void removeChild(Node n) {
        if (!this.children.remove(n)) {
            return;
        }
        if (this.parent != null) {
            this.parent.getNode().detachChild((Spatial)n);
        }
        this.invalidate();
    }

    @Override
    public void attach(GuiControl parent) {
        this.parent = parent;
        Node self = parent.getNode();
        for (Node n : this.children) {
            self.attachChild((Spatial)n);
        }
    }

    @Override
    public void detach(GuiControl parent) {
        this.parent = null;
        for (Node n : this.children) {
            n.removeFromParent();
        }
    }

    @Override
    public Collection<Node> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public void clearChildren() {
        if (this.parent != null) {
            for (Node n : this.children) {
                this.parent.getNode().detachChild((Spatial)n);
            }
        }
        this.children.clear();
        this.invalidate();
    }
}

