/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.component;

import com.jme3.math.Vector3f;
import com.simsilica.lemur.Insets3f;
import com.simsilica.lemur.component.InsetsComponent;

public class DynamicInsetsComponent
extends InsetsComponent {
    private Vector3f lastPreferredSize;

    public DynamicInsetsComponent(float top, float left, float bottom, float right) {
        super(new Insets3f(top, left, bottom, right));
    }

    public DynamicInsetsComponent(float top, float left, float bottom, float right, float front, float back) {
        super(new Insets3f(top, left, bottom, right, front, back));
    }

    public DynamicInsetsComponent(Insets3f insets) {
        super(insets);
    }

    @Override
    public void setInsets(Insets3f insets) {
        Insets3f balanced = insets.clone();
        for (int i = 0; i < 3; ++i) {
            float min = balanced.min.get(i);
            float max = balanced.max.get(i);
            if (min == 0.0f && max == 0.0f) {
                min = 0.5f;
                max = 0.5f;
            }
            float size = min + max;
            float scale = 1.0f / size;
            balanced.min.set(i, min * scale);
            balanced.max.set(i, max * scale);
        }
        super.setInsets(balanced);
    }

    @Override
    public DynamicInsetsComponent clone() {
        DynamicInsetsComponent result = (DynamicInsetsComponent)super.clone();
        result.lastPreferredSize = null;
        return result;
    }

    @Override
    public void calculatePreferredSize(Vector3f size) {
        this.lastPreferredSize = size.clone();
    }

    @Override
    public void reshape(Vector3f pos, Vector3f size) {
        Vector3f prefSize = this.lastPreferredSize;
        if (prefSize == null) {
            if (this.isAttached()) {
                prefSize = this.getGuiControl().getPreferredSize();
            } else {
                return;
            }
        }
        Vector3f delta = size.subtract(prefSize);
        Insets3f insets = this.getInsets();
        for (int i = 0; i < 3; ++i) {
            float d = delta.get(i);
            if (d <= 0.0f) continue;
            float min = insets.min.get(i);
            float p = pos.get(i);
            float s = size.get(i);
            if (i == 1) {
                pos.set(i, p - min * d);
            } else {
                pos.set(i, p + min * d);
            }
            size.set(i, s - d);
        }
    }
}

