/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.event;

import com.jme3.collision.CollisionResult;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Spatial;

public abstract class AbstractCursorEvent {
    private boolean consumed = false;
    private ViewPort view;
    private Spatial target;
    private float x;
    private float y;
    private CollisionResult collision;

    protected AbstractCursorEvent(ViewPort view, Spatial target, float x, float y, CollisionResult collision) {
        this.view = view;
        this.target = target;
        this.x = x;
        this.y = y;
        this.collision = collision;
    }

    public ViewPort getViewPort() {
        return this.view;
    }

    public Spatial getTarget() {
        return this.target;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public CollisionResult getCollision() {
        return this.collision;
    }

    public void setConsumed() {
        this.consumed = true;
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    public Vector3f getRelativeViewCoordinates(Spatial relativeTo, Vector3f pos) {
        pos = relativeTo.localToWorld(pos, null);
        Camera cam = this.view.getCamera();
        if (cam.isParallelProjection()) {
            return pos.clone();
        }
        return cam.getScreenCoordinates(pos);
    }

    protected String parmsToString() {
        return "x=" + this.x + ", y=" + this.y + ", target=" + this.target + ", view=" + this.view + ", collision=" + this.collision;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.parmsToString() + "]";
    }
}

