/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.fbx.mesh;

import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.asset.AssetManager;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.plugins.IrBoneWeightIndex;
import com.jme3.scene.plugins.IrMesh;
import com.jme3.scene.plugins.IrPolygon;
import com.jme3.scene.plugins.IrUtils;
import com.jme3.scene.plugins.IrVertex;
import com.jme3.scene.plugins.fbx.anim.FbxCluster;
import com.jme3.scene.plugins.fbx.anim.FbxLimbNode;
import com.jme3.scene.plugins.fbx.anim.FbxSkinDeformer;
import com.jme3.scene.plugins.fbx.file.FbxElement;
import com.jme3.scene.plugins.fbx.mesh.FbxLayer;
import com.jme3.scene.plugins.fbx.mesh.FbxLayerElement;
import com.jme3.scene.plugins.fbx.mesh.FbxMeshUtil;
import com.jme3.scene.plugins.fbx.mesh.FbxPolygon;
import com.jme3.scene.plugins.fbx.node.FbxNodeAttribute;
import com.jme3.scene.plugins.fbx.obj.FbxObject;
import com.jme3.util.IntMap;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FbxMesh
extends FbxNodeAttribute<IntMap<Mesh>> {
    private static final Logger logger = Logger.getLogger(FbxMesh.class.getName());
    private FbxPolygon[] polygons;
    private int[] edges;
    private FbxLayerElement[] layerElements;
    private Vector3f[] positions;
    private FbxLayer[] layers;
    private ArrayList<Integer>[] boneIndices;
    private ArrayList<Float>[] boneWeights;
    private FbxSkinDeformer skinDeformer;

    public FbxMesh(AssetManager assetManager, String sceneFolderName) {
        super(assetManager, sceneFolderName);
    }

    @Override
    public void fromElement(FbxElement element) {
        super.fromElement(element);
        ArrayList<FbxLayerElement> layerElementsList = new ArrayList<FbxLayerElement>();
        ArrayList<FbxLayer> layersList = new ArrayList<FbxLayer>();
        for (FbxElement e : element.children) {
            if (e.id.equals("Vertices")) {
                this.setPositions(FbxMeshUtil.getDoubleArray(e));
                continue;
            }
            if (e.id.equals("PolygonVertexIndex")) {
                this.setPolygonVertexIndices(FbxMeshUtil.getIntArray(e));
                continue;
            }
            if (e.id.equals("Edges")) {
                this.setEdges(FbxMeshUtil.getIntArray(e));
                continue;
            }
            if (e.id.startsWith("LayerElement")) {
                layerElementsList.add(FbxLayerElement.fromElement(e));
                continue;
            }
            if (!e.id.equals("Layer")) continue;
            layersList.add(FbxLayer.fromElement(e));
        }
        for (FbxLayer layer : layersList) {
            layer.setLayerElements(layerElementsList);
        }
        this.layerElements = new FbxLayerElement[layerElementsList.size()];
        layerElementsList.toArray(this.layerElements);
        this.layers = new FbxLayer[layersList.size()];
        layersList.toArray(this.layers);
    }

    public FbxSkinDeformer getSkinDeformer() {
        return this.skinDeformer;
    }

    public void applyCluster(FbxCluster cluster) {
        if (this.boneIndices == null) {
            this.boneIndices = new ArrayList[this.positions.length];
            this.boneWeights = new ArrayList[this.positions.length];
        }
        FbxLimbNode limb = cluster.getLimb();
        Bone bone = limb.getJmeBone();
        Skeleton skeleton = limb.getSkeletonHolder().getJmeSkeleton();
        int boneIndex = skeleton.getBoneIndex(bone);
        int[] positionIndices = cluster.getVertexIndices();
        double[] weights = cluster.getWeights();
        for (int i = 0; i < positionIndices.length; ++i) {
            int positionIndex = positionIndices[i];
            float boneWeight = (float)weights[i];
            ArrayList<Integer> boneIndicesForVertex = this.boneIndices[positionIndex];
            ArrayList<Float> boneWeightsForVertex = this.boneWeights[positionIndex];
            if (boneIndicesForVertex == null) {
                boneIndicesForVertex = new ArrayList();
                boneWeightsForVertex = new ArrayList();
                this.boneIndices[positionIndex] = boneIndicesForVertex;
                this.boneWeights[positionIndex] = boneWeightsForVertex;
            }
            boneIndicesForVertex.add(boneIndex);
            boneWeightsForVertex.add(Float.valueOf(boneWeight));
        }
    }

    @Override
    public void connectObject(FbxObject object) {
        if (object instanceof FbxSkinDeformer) {
            if (this.skinDeformer != null) {
                logger.log(Level.WARNING, "This mesh already has a skin deformer attached. Ignoring.");
                return;
            }
            this.skinDeformer = (FbxSkinDeformer)object;
        } else {
            this.unsupportedConnectObject(object);
        }
    }

    @Override
    public void connectObjectProperty(FbxObject object, String property) {
        this.unsupportedConnectObjectProperty(object, property);
    }

    private void setPositions(double[] positions) {
        this.positions = FbxLayerElement.toVector3(positions);
    }

    private void setEdges(int[] edges) {
        this.edges = edges;
    }

    private void setPolygonVertexIndices(int[] polygonVertexIndices) {
        ArrayList<FbxPolygon> polygonList = new ArrayList<FbxPolygon>();
        boolean finishPolygon = false;
        ArrayList<Integer> vertexIndices = new ArrayList<Integer>();
        for (int i = 0; i < polygonVertexIndices.length; ++i) {
            int vertexIndex = polygonVertexIndices[i];
            if (vertexIndex < 0) {
                vertexIndex ^= 0xFFFFFFFF;
                finishPolygon = true;
            }
            vertexIndices.add(vertexIndex);
            if (!finishPolygon) continue;
            finishPolygon = false;
            polygonList.add(FbxPolygon.fromIndices(vertexIndices));
            vertexIndices.clear();
        }
        this.polygons = new FbxPolygon[polygonList.size()];
        polygonList.toArray(this.polygons);
    }

    private static IrBoneWeightIndex[] toBoneWeightIndices(List<Integer> boneIndices, List<Float> boneWeights) {
        IrBoneWeightIndex[] boneWeightIndices = new IrBoneWeightIndex[boneIndices.size()];
        for (int i = 0; i < boneIndices.size(); ++i) {
            boneWeightIndices[i] = new IrBoneWeightIndex(boneIndices.get(i), boneWeights.get(i).floatValue());
        }
        return boneWeightIndices;
    }

    @Override
    protected IntMap<Mesh> toJmeObject() {
        if (this.skinDeformer != null) {
            for (FbxCluster cluster : (List)this.skinDeformer.getJmeObject()) {
                this.applyCluster(cluster);
            }
        }
        IrMesh irMesh = this.toIRMesh();
        IrUtils.trimBoneWeights(irMesh);
        IrUtils.toTangentsWithParity(irMesh);
        IrUtils.triangulate(irMesh);
        IntMap<IrMesh> irMeshes = IrUtils.splitByMaterial(irMesh);
        IntMap jmeMeshes = new IntMap();
        for (IntMap.Entry irMeshEntry : irMeshes) {
            Mesh jmeMesh = IrUtils.convertIrMeshToJmeMesh((IrMesh)irMeshEntry.getValue());
            jmeMeshes.put(irMeshEntry.getKey(), (Object)jmeMesh);
        }
        if (jmeMeshes.size() == 0) {
            logger.log(Level.WARNING, "Empty FBX mesh found (unusual).");
        }
        if (jmeMeshes.containsKey(-1) && jmeMeshes.size() > 1) {
            logger.log(Level.WARNING, "Mesh has polygons with no material indices (unusual) - they will use material index 0.");
        }
        return jmeMeshes;
    }

    public IrMesh toIRMesh() {
        IrMesh newMesh = new IrMesh();
        newMesh.polygons = new IrPolygon[this.polygons.length];
        int polygonVertexIndex = 0;
        int positionIndex = 0;
        FbxLayer layer0 = this.layers[0];
        FbxLayer layer1 = this.layers.length > 1 ? this.layers[1] : null;
        for (int i = 0; i < this.polygons.length; ++i) {
            FbxPolygon polygon = this.polygons[i];
            IrPolygon irPolygon = new IrPolygon();
            irPolygon.vertices = new IrVertex[polygon.indices.length];
            for (int j = 0; j < polygon.indices.length; ++j) {
                positionIndex = polygon.indices[j];
                IrVertex irVertex = new IrVertex();
                irVertex.pos = this.positions[positionIndex];
                if (layer0 != null) {
                    irVertex.norm = (Vector3f)layer0.getVertexData(FbxLayerElement.Type.Normal, i, polygonVertexIndex, positionIndex, 0);
                    irVertex.tang = (Vector3f)layer0.getVertexData(FbxLayerElement.Type.Tangent, i, polygonVertexIndex, positionIndex, 0);
                    irVertex.bitang = (Vector3f)layer0.getVertexData(FbxLayerElement.Type.Binormal, i, polygonVertexIndex, positionIndex, 0);
                    irVertex.uv0 = (Vector2f)layer0.getVertexData(FbxLayerElement.Type.UV, i, polygonVertexIndex, positionIndex, 0);
                    irVertex.color = (ColorRGBA)layer0.getVertexData(FbxLayerElement.Type.Color, i, polygonVertexIndex, positionIndex, 0);
                    irVertex.material = (Integer)layer0.getVertexData(FbxLayerElement.Type.Material, i, polygonVertexIndex, positionIndex, 0);
                    irVertex.smoothing = (Integer)layer0.getVertexData(FbxLayerElement.Type.Smoothing, i, polygonVertexIndex, positionIndex, 0);
                }
                if (layer1 != null) {
                    irVertex.uv1 = (Vector2f)layer1.getVertexData(FbxLayerElement.Type.UV, i, polygonVertexIndex, positionIndex, 0);
                }
                if (this.boneIndices != null) {
                    ArrayList<Integer> boneIndicesForVertex = this.boneIndices[positionIndex];
                    ArrayList<Float> boneWeightsForVertex = this.boneWeights[positionIndex];
                    if (boneIndicesForVertex != null) {
                        irVertex.boneWeightsIndices = FbxMesh.toBoneWeightIndices(boneIndicesForVertex, boneWeightsForVertex);
                    }
                }
                irPolygon.vertices[j] = irVertex;
                ++polygonVertexIndex;
            }
            newMesh.polygons[i] = irPolygon;
        }
        if (this.boneIndices != null && newMesh.polygons[0].vertices[0] == null) {
            newMesh.polygons[0].vertices[0].boneWeightsIndices = new IrBoneWeightIndex[0];
        }
        return newMesh;
    }
}

