/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.fbx.obj;

import com.jme3.asset.AssetManager;
import com.jme3.scene.plugins.fbx.file.FbxElement;
import com.jme3.scene.plugins.fbx.file.FbxId;
import java.util.logging.Logger;

public abstract class FbxObject<JT> {
    private static final Logger logger = Logger.getLogger(FbxObject.class.getName());
    protected AssetManager assetManager;
    protected String sceneFolderName;
    protected FbxId id;
    protected String name;
    protected String className;
    protected String subclassName;
    protected JT jmeObject;

    protected FbxObject(AssetManager assetManager, String sceneFolderName) {
        this.assetManager = assetManager;
        this.sceneFolderName = sceneFolderName;
    }

    public FbxId getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.className;
    }

    public String getSubclassName() {
        return this.subclassName;
    }

    public String getFullClassName() {
        if (this.subclassName.equals("")) {
            return this.className;
        }
        return this.subclassName + " : " + this.className;
    }

    public String toString() {
        return this.name + " (" + this.id + ")";
    }

    protected void fromElement(FbxElement element) {
        String nameAndClass;
        this.id = FbxId.getObjectId(element);
        if (element.propertiesTypes.length == 3) {
            nameAndClass = (String)element.properties.get(1);
            this.subclassName = (String)element.properties.get(2);
        } else if (element.propertiesTypes.length == 2) {
            nameAndClass = (String)element.properties.get(0);
            this.subclassName = (String)element.properties.get(1);
        } else {
            throw new UnsupportedOperationException("This is not an FBX object: " + element.id);
        }
        int splitter = nameAndClass.indexOf("\u0000\u0001");
        if (splitter != -1) {
            this.name = nameAndClass.substring(0, splitter);
            this.className = nameAndClass.substring(splitter + 2);
        } else {
            this.name = nameAndClass;
            this.className = null;
        }
    }

    public final JT getJmeObject() {
        if (this.jmeObject == null) {
            this.jmeObject = this.toJmeObject();
            if (this.jmeObject == null) {
                throw new UnsupportedOperationException("FBX object subclass failed to resolve to a jME3 object");
            }
        }
        return this.jmeObject;
    }

    public final boolean isJmeObjectCreated() {
        return this.jmeObject != null;
    }

    protected final void unsupportedConnectObject(FbxObject object) {
        throw new IllegalArgumentException("Cannot attach objects of this class (" + object.getFullClassName() + ") to " + this.getClass().getSimpleName());
    }

    protected final void unsupportedConnectObjectProperty(FbxObject object, String property) {
        throw new IllegalArgumentException("Cannot attach objects of this class (" + object.getFullClassName() + ") to property " + this.getClass().getSimpleName() + "[\"" + property + "\"]");
    }

    protected abstract JT toJmeObject();

    public abstract void connectObject(FbxObject var1);

    public abstract void connectObjectProperty(FbxObject var1, String var2);
}

