/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.flac;

import de.jarnbjo.flac.Application;
import de.jarnbjo.flac.FlacFormatException;
import de.jarnbjo.flac.Padding;
import de.jarnbjo.flac.SeekTable;
import de.jarnbjo.flac.StreamInfo;
import de.jarnbjo.flac.VorbisComment;
import de.jarnbjo.util.io.BitInputStream;
import java.io.IOException;

public abstract class MetadataBlock {
    private static final int STREAMINFO = 0;
    private static final int PADDING = 1;
    private static final int APPLICATION = 2;
    private static final int SEEKTABLE = 3;
    private static final int VORBIS_COMMENT = 4;
    private boolean lastBlock;

    public static MetadataBlock createInstance(BitInputStream source) throws FlacFormatException, IOException {
        boolean lb = source.getBit();
        int blockType = source.getInt(7);
        switch (blockType) {
            case 0: {
                StreamInfo mb = new StreamInfo(source);
                mb.lastBlock = lb;
                return mb;
            }
            case 3: {
                SeekTable mb = new SeekTable(source);
                mb.lastBlock = lb;
                return mb;
            }
            case 4: {
                VorbisComment mb = new VorbisComment(source);
                mb.lastBlock = lb;
                return mb;
            }
            case 1: {
                Padding mb = new Padding(source);
                mb.lastBlock = lb;
                return mb;
            }
            case 2: {
                Application mb = new Application(source);
                mb.lastBlock = lb;
                return mb;
            }
        }
        throw new FlacFormatException("Unsupported block type " + blockType);
    }

    boolean isLastBlock() {
        return this.lastBlock;
    }
}

