/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input.lwjgl;

import com.jme3.cursors.plugins.JmeCursor;
import com.jme3.input.MouseInput;
import com.jme3.input.RawInputListener;
import com.jme3.input.event.MouseButtonEvent;
import com.jme3.input.event.MouseMotionEvent;
import com.jme3.system.lwjgl.LwjglAbstractDisplay;
import com.jme3.system.lwjgl.LwjglTimer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lwjgl.LWJGLException;
import org.lwjgl.Sys;
import org.lwjgl.input.Cursor;
import org.lwjgl.input.Mouse;

public class LwjglMouseInput
implements MouseInput {
    private static final Logger logger = Logger.getLogger(LwjglMouseInput.class.getName());
    private LwjglAbstractDisplay context;
    private RawInputListener listener;
    private boolean supportHardwareCursor = false;
    private boolean cursorVisible = true;
    private int curX;
    private int curY;
    private int curWheel;

    public LwjglMouseInput(LwjglAbstractDisplay context) {
        this.context = context;
    }

    public void initialize() {
        if (!this.context.isRenderable()) {
            return;
        }
        try {
            Mouse.create();
            logger.fine("Mouse created.");
            this.supportHardwareCursor = (Cursor.getCapabilities() & 1) != 0;
            Mouse.setGrabbed((!this.cursorVisible ? 1 : 0) != 0);
        }
        catch (LWJGLException ex) {
            logger.log(Level.SEVERE, "Error while creating mouse", ex);
        }
    }

    public boolean isInitialized() {
        return Mouse.isCreated();
    }

    public int getButtonCount() {
        return Mouse.getButtonCount();
    }

    public void update() {
        if (!this.context.isRenderable()) {
            return;
        }
        while (Mouse.next()) {
            MouseMotionEvent evt;
            int btn = Mouse.getEventButton();
            int wheelDelta = Mouse.getEventDWheel();
            int xDelta = Mouse.getEventDX();
            int yDelta = Mouse.getEventDY();
            int x = Mouse.getX();
            int y = Mouse.getY();
            this.curWheel += wheelDelta;
            if (this.cursorVisible) {
                xDelta = x - this.curX;
                yDelta = y - this.curY;
                this.curX = x;
                this.curY = y;
            } else {
                x = this.curX + xDelta;
                y = this.curY + yDelta;
                this.curX = x;
                this.curY = y;
            }
            if (xDelta != 0 || yDelta != 0 || wheelDelta != 0) {
                evt = new MouseMotionEvent(x, y, xDelta, yDelta, this.curWheel, wheelDelta);
                evt.setTime(Mouse.getEventNanoseconds());
                this.listener.onMouseMotionEvent(evt);
            }
            if (btn == -1) continue;
            evt = new MouseButtonEvent(btn, Mouse.getEventButtonState(), x, y);
            evt.setTime(Mouse.getEventNanoseconds());
            this.listener.onMouseButtonEvent((MouseButtonEvent)evt);
        }
    }

    public void destroy() {
        if (!this.context.isRenderable()) {
            return;
        }
        Mouse.destroy();
        logger.fine("Mouse destroyed.");
    }

    public void setCursorVisible(boolean visible) {
        this.cursorVisible = visible;
        if (!this.context.isRenderable()) {
            return;
        }
        Mouse.setGrabbed((!visible ? 1 : 0) != 0);
    }

    public void setInputListener(RawInputListener listener) {
        this.listener = listener;
    }

    public long getInputTimeNanos() {
        return Sys.getTime() * LwjglTimer.LWJGL_TIME_TO_NANOS;
    }

    public void setNativeCursor(JmeCursor jmeCursor) {
        try {
            Cursor newCursor = null;
            if (jmeCursor != null) {
                newCursor = new Cursor(jmeCursor.getWidth(), jmeCursor.getHeight(), jmeCursor.getXHotSpot(), jmeCursor.getYHotSpot(), jmeCursor.getNumImages(), jmeCursor.getImagesData(), jmeCursor.getImagesDelay());
            }
            Mouse.setNativeCursor(newCursor);
        }
        catch (LWJGLException ex) {
            Logger.getLogger(LwjglMouseInput.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

