/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.service;

import com.jme3.network.service.Service;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class ServiceManager<T> {
    private List<Service<T>> services = new CopyOnWriteArrayList<Service<T>>();
    private volatile boolean started = false;

    protected ServiceManager() {
    }

    protected abstract T getParent();

    protected List<Service<T>> getServices() {
        return this.services;
    }

    public void start() {
        if (this.started) {
            return;
        }
        for (Service<T> s : this.services) {
            s.start();
        }
        this.started = true;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void stop() {
        if (!this.started) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " not started.");
        }
        for (Service<T> s : this.services) {
            s.stop();
        }
        this.started = false;
    }

    public <S extends Service<T>> void addService(S s) {
        this.services.add((Service<T>)s);
        s.initialize(this.getParent());
        if (this.started) {
            s.start();
        }
    }

    public <S extends Service<T>> void removeService(S s) {
        if (this.started) {
            s.stop();
        }
        this.services.remove(s);
        s.terminate(this.getParent());
    }

    public void terminate() {
        if (this.started) {
            this.stop();
        }
        for (Service<T> s : this.services) {
            s.terminate(this.getParent());
        }
    }

    public <S extends Service<T>> S getService(Class<S> type) {
        for (Service<T> s : this.services) {
            if (!type.isInstance(s)) continue;
            return (S)((Service)type.cast(s));
        }
        return null;
    }

    public String toString() {
        return this.getClass().getName() + "[services=" + this.services + "]";
    }
}

