/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.fbx.mesh;

import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.plugins.fbx.file.FbxElement;
import com.jme3.scene.plugins.fbx.mesh.FbxMeshUtil;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FbxLayerElement {
    private static final Logger logger = Logger.getLogger(FbxLayerElement.class.getName());
    private static final Set<String> indexTypes = new HashSet<String>();
    int index;
    Type type;
    ReferenceInformationType refInfoType;
    MappingInformationType mapInfoType;
    String name = "";
    Object[] data;
    int[] dataIndices;

    private FbxLayerElement() {
    }

    public String toString() {
        return "LayerElement[type=" + (Object)((Object)this.type) + ", layer=" + this.index + ", mapInfoType=" + (Object)((Object)this.mapInfoType) + ", refInfoType=" + (Object)((Object)this.refInfoType) + "]";
    }

    private Object getVertexDataIndexToDirect(int polygonIndex, int polygonVertexIndex, int positionIndex, int edgeIndex) {
        switch (this.mapInfoType) {
            case AllSame: {
                return this.data[this.dataIndices[0]];
            }
            case ByPolygon: {
                return this.data[this.dataIndices[polygonIndex]];
            }
            case ByPolygonVertex: {
                return this.data[this.dataIndices[polygonVertexIndex]];
            }
            case ByVertex: {
                return this.data[this.dataIndices[positionIndex]];
            }
            case ByEdge: {
                return this.data[this.dataIndices[edgeIndex]];
            }
        }
        throw new UnsupportedOperationException();
    }

    private Object getVertexDataDirect(int polygonIndex, int polygonVertexIndex, int positionIndex, int edgeIndex) {
        switch (this.mapInfoType) {
            case AllSame: {
                return this.data[0];
            }
            case ByPolygon: {
                return this.data[polygonIndex];
            }
            case ByPolygonVertex: {
                return this.data[polygonVertexIndex];
            }
            case ByVertex: {
                return this.data[positionIndex];
            }
            case ByEdge: {
                return this.data[edgeIndex];
            }
        }
        throw new UnsupportedOperationException();
    }

    public Object getVertexData(int polygonIndex, int polygonVertexIndex, int positionIndex, int edgeIndex) {
        switch (this.refInfoType) {
            case Direct: {
                return this.getVertexDataDirect(polygonIndex, polygonVertexIndex, positionIndex, edgeIndex);
            }
            case IndexToDirect: {
                return this.getVertexDataIndexToDirect(polygonIndex, polygonVertexIndex, positionIndex, edgeIndex);
            }
        }
        return null;
    }

    public static FbxLayerElement fromPositions(double[] positionData) {
        FbxLayerElement layerElement = new FbxLayerElement();
        layerElement.index = -1;
        layerElement.name = "";
        layerElement.type = Type.Position;
        layerElement.mapInfoType = MappingInformationType.ByVertex;
        layerElement.refInfoType = ReferenceInformationType.Direct;
        layerElement.data = FbxLayerElement.toVector3(positionData);
        layerElement.dataIndices = null;
        return layerElement;
    }

    public static FbxLayerElement fromElement(FbxElement element) {
        FbxLayerElement layerElement = new FbxLayerElement();
        if (!element.id.startsWith("LayerElement")) {
            throw new IllegalArgumentException("Not a layer element");
        }
        layerElement.index = (Integer)element.properties.get(0);
        String elementType = element.id.substring("LayerElement".length());
        try {
            layerElement.type = Type.valueOf(elementType);
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.WARNING, "Unsupported layer element: {0}. Ignoring.", elementType);
        }
        for (FbxElement child : element.children) {
            if (child.id.equals("MappingInformationType")) {
                String mapInfoTypeVal = (String)child.properties.get(0);
                if (mapInfoTypeVal.equals("ByVertice")) {
                    mapInfoTypeVal = "ByVertex";
                }
                layerElement.mapInfoType = MappingInformationType.valueOf(mapInfoTypeVal);
                continue;
            }
            if (child.id.equals("ReferenceInformationType")) {
                String refInfoTypeVal = (String)child.properties.get(0);
                if (refInfoTypeVal.equals("Index")) {
                    refInfoTypeVal = "IndexToDirect";
                }
                layerElement.refInfoType = ReferenceInformationType.valueOf(refInfoTypeVal);
                continue;
            }
            if (child.id.equals("Normals") || child.id.equals("Tangents") || child.id.equals("Binormals")) {
                layerElement.data = FbxLayerElement.toVector3(FbxMeshUtil.getDoubleArray(child));
                continue;
            }
            if (child.id.equals("Colors")) {
                layerElement.data = FbxLayerElement.toColorRGBA(FbxMeshUtil.getDoubleArray(child));
                continue;
            }
            if (child.id.equals("UV")) {
                layerElement.data = FbxLayerElement.toVector2(FbxMeshUtil.getDoubleArray(child));
                continue;
            }
            if (indexTypes.contains(child.id)) {
                layerElement.dataIndices = FbxMeshUtil.getIntArray(child);
                continue;
            }
            if (!child.id.equals("Name")) continue;
            layerElement.name = (String)child.properties.get(0);
        }
        if (layerElement.data == null) {
            layerElement.refInfoType = ReferenceInformationType.Direct;
            layerElement.data = new Integer[layerElement.dataIndices.length];
            for (int i = 0; i < layerElement.data.length; ++i) {
                layerElement.data[i] = layerElement.dataIndices[i];
            }
            layerElement.dataIndices = null;
        }
        return layerElement;
    }

    static Vector3f[] toVector3(double[] data) {
        Vector3f[] vectors = new Vector3f[data.length / 3];
        for (int i = 0; i < vectors.length; ++i) {
            float x = (float)data[i * 3];
            float y = (float)data[i * 3 + 1];
            float z = (float)data[i * 3 + 2];
            vectors[i] = new Vector3f(x, y, z);
        }
        return vectors;
    }

    static Vector2f[] toVector2(double[] data) {
        Vector2f[] vectors = new Vector2f[data.length / 2];
        for (int i = 0; i < vectors.length; ++i) {
            float x = (float)data[i * 2];
            float y = (float)data[i * 2 + 1];
            vectors[i] = new Vector2f(x, y);
        }
        return vectors;
    }

    static ColorRGBA[] toColorRGBA(double[] data) {
        ColorRGBA[] colors = new ColorRGBA[data.length / 4];
        for (int i = 0; i < colors.length; ++i) {
            float r = (float)data[i * 4];
            float g = (float)data[i * 4 + 1];
            float b = (float)data[i * 4 + 2];
            float a = (float)data[i * 4 + 3];
            colors[i] = new ColorRGBA(r, g, b, a);
        }
        return colors;
    }

    static {
        indexTypes.add("UVIndex");
        indexTypes.add("NormalsIndex");
        indexTypes.add("TangentsIndex");
        indexTypes.add("BinormalsIndex");
        indexTypes.add("Smoothing");
        indexTypes.add("Materials");
        indexTypes.add("TextureId");
        indexTypes.add("ColorIndex");
        indexTypes.add("PolygonGroup");
    }

    public static enum MappingInformationType {
        NoMappingInformation,
        AllSame,
        ByPolygonVertex,
        ByVertex,
        ByPolygon,
        ByEdge;

    }

    public static enum ReferenceInformationType {
        Direct,
        IndexToDirect;

    }

    public static enum TextureBlendMode {
        Translucent;

    }

    public static enum Type {
        Position,
        BoneIndex,
        BoneWeight,
        Normal,
        Binormal,
        Tangent,
        UV,
        TransparentUV,
        Color,
        Material,
        Smoothing,
        Visibility,
        Texture,
        PolygonGroup,
        NormalMapTextures,
        SpecularFactorUV,
        NormalMapUV,
        SpecularFactorTextures;

    }
}

