/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.animation;

import com.jme3.animation.AnimControl;
import com.jme3.animation.Animation;
import com.jme3.animation.AnimationUtils;
import com.jme3.animation.Bone;
import com.jme3.animation.LoopMode;
import com.jme3.math.FastMath;
import com.jme3.util.TempVars;
import java.util.BitSet;

public final class AnimChannel {
    private static final float DEFAULT_BLEND_TIME = 0.15f;
    private AnimControl control;
    private BitSet affectedBones;
    private Animation animation;
    private Animation blendFrom;
    private float time;
    private float speed;
    private float timeBlendFrom;
    private float blendTime;
    private float speedBlendFrom;
    private boolean notified = false;
    private LoopMode loopMode;
    private LoopMode loopModeBlendFrom;
    private float blendAmount = 1.0f;
    private float blendRate = 0.0f;

    AnimChannel(AnimControl control) {
        this.control = control;
    }

    public AnimControl getControl() {
        return this.control;
    }

    public String getAnimationName() {
        return this.animation != null ? this.animation.getName() : null;
    }

    public LoopMode getLoopMode() {
        return this.loopMode;
    }

    public void setLoopMode(LoopMode loopMode) {
        this.loopMode = loopMode;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
        if (this.blendTime > 0.0f) {
            this.speedBlendFrom = speed;
            this.blendTime = Math.min(this.blendTime, this.animation.getLength() / speed);
            this.blendRate = 1.0f / this.blendTime;
        }
    }

    public float getTime() {
        return this.time;
    }

    public void setTime(float time) {
        this.time = FastMath.clamp(time, 0.0f, this.getAnimMaxTime());
    }

    public float getAnimMaxTime() {
        return this.animation != null ? this.animation.getLength() : 0.0f;
    }

    public void setAnim(String name, float blendTime) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (blendTime < 0.0f) {
            throw new IllegalArgumentException("blendTime cannot be less than zero");
        }
        Animation anim = this.control.animationMap.get(name);
        if (anim == null) {
            throw new IllegalArgumentException("Cannot find animation named: '" + name + "'");
        }
        this.control.notifyAnimChange(this, name);
        if (this.animation != null && blendTime > 0.0f) {
            this.blendTime = blendTime;
            blendTime = Math.min(blendTime, anim.getLength() / this.speed);
            this.blendFrom = this.animation;
            this.timeBlendFrom = this.time;
            this.speedBlendFrom = this.speed;
            this.loopModeBlendFrom = this.loopMode;
            this.blendAmount = 0.0f;
            this.blendRate = 1.0f / blendTime;
        } else {
            this.blendFrom = null;
        }
        this.animation = anim;
        this.time = 0.0f;
        this.speed = 1.0f;
        this.loopMode = LoopMode.Loop;
        this.notified = false;
    }

    public void setAnim(String name) {
        this.setAnim(name, 0.15f);
    }

    public void addAllBones() {
        this.affectedBones = null;
    }

    public void addBone(String name) {
        this.addBone(this.control.getSkeleton().getBone(name));
    }

    public void addBone(Bone bone) {
        int boneIndex = this.control.getSkeleton().getBoneIndex(bone);
        if (this.affectedBones == null) {
            this.affectedBones = new BitSet(this.control.getSkeleton().getBoneCount());
        }
        this.affectedBones.set(boneIndex);
    }

    public void addToRootBone(String name) {
        this.addToRootBone(this.control.getSkeleton().getBone(name));
    }

    public void addToRootBone(Bone bone) {
        this.addBone(bone);
        while (bone.getParent() != null) {
            bone = bone.getParent();
            this.addBone(bone);
        }
    }

    public void addFromRootBone(String name) {
        this.addFromRootBone(this.control.getSkeleton().getBone(name));
    }

    public void addFromRootBone(Bone bone) {
        this.addBone(bone);
        if (bone.getChildren() == null) {
            return;
        }
        for (Bone childBone : bone.getChildren()) {
            this.addBone(childBone);
            this.addFromRootBone(childBone);
        }
    }

    BitSet getAffectedBones() {
        return this.affectedBones;
    }

    public void reset(boolean rewind) {
        if (rewind) {
            this.setTime(0.0f);
            if (this.control.getSkeleton() != null) {
                this.control.getSkeleton().resetAndUpdate();
            } else {
                TempVars vars = TempVars.get();
                this.update(0.0f, vars);
                vars.release();
            }
        }
        this.animation = null;
        this.notified = false;
    }

    void update(float tpf, TempVars vars) {
        if (this.animation == null) {
            return;
        }
        if (this.blendFrom != null && this.blendAmount != 1.0f) {
            this.blendFrom.setTime(this.timeBlendFrom, 1.0f - this.blendAmount, this.control, this, vars);
            this.timeBlendFrom += tpf * this.speedBlendFrom;
            this.timeBlendFrom = AnimationUtils.clampWrapTime(this.timeBlendFrom, this.blendFrom.getLength(), this.loopModeBlendFrom);
            if (this.timeBlendFrom < 0.0f) {
                this.timeBlendFrom = -this.timeBlendFrom;
                this.speedBlendFrom = -this.speedBlendFrom;
            }
            this.blendAmount += tpf * this.blendRate;
            if (this.blendAmount > 1.0f) {
                this.blendAmount = 1.0f;
                this.blendFrom = null;
            }
        }
        this.animation.setTime(this.time, this.blendAmount, this.control, this, vars);
        this.time += tpf * this.speed;
        if (this.animation.getLength() > 0.0f && !this.notified && (this.time >= this.animation.getLength() || this.time < 0.0f)) {
            if (this.loopMode == LoopMode.DontLoop) {
                this.notified = true;
            }
            this.control.notifyAnimCycleDone(this, this.animation.getName());
        }
        this.time = AnimationUtils.clampWrapTime(this.time, this.animation.getLength(), this.loopMode);
        if (this.time < 0.0f) {
            this.time = -this.time;
            this.speed = -this.speed;
        }
    }
}

