/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.app;

import com.jme3.app.Application;
import com.jme3.app.state.AbstractAppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.input.InputManager;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.AnalogListener;
import com.jme3.input.controls.MouseAxisTrigger;
import com.jme3.input.controls.MouseButtonTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.CameraNode;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.CameraControl;
import com.jme3.util.TempVars;

public class ChaseCameraAppState
extends AbstractAppState
implements ActionListener,
AnalogListener {
    protected Spatial spatial;
    protected Node target;
    protected CameraNode camNode;
    protected InputManager inputManager;
    protected boolean invertYaxis = false;
    protected boolean invertXaxis = false;
    protected boolean hideCursorOnRotate = true;
    protected boolean canRotate;
    protected boolean dragToRotate = true;
    protected float rotationSpeed = 1.0f;
    protected float zoomSpeed = 2.0f;
    protected float minDistance = 1.0f;
    protected float maxDistance = 40.0f;
    protected float distance = 20.0f;
    protected float maxVerticalRotation = 1.4f;
    protected float verticalRotation = 0.0f;
    protected float minVerticalRotation = 0.0f;
    protected float horizontalRotation = 0.0f;
    protected Vector3f upVector = new Vector3f();
    protected Vector3f leftVector = new Vector3f();
    protected Trigger[] zoomOutTrigger = new Trigger[]{new MouseAxisTrigger(2, true)};
    protected Trigger[] zoomInTrigger = new Trigger[]{new MouseAxisTrigger(2, false)};
    protected Trigger[] toggleRotateTrigger = new Trigger[]{new MouseButtonTrigger(0), new MouseButtonTrigger(1)};

    public ChaseCameraAppState() {
        this.camNode = new CameraNode("ChaseCameraNode", new CameraControl());
    }

    @Override
    public void initialize(AppStateManager stateManager, Application app) {
        super.initialize(stateManager, app);
        this.inputManager = app.getInputManager();
        this.target = new Node("ChaseCamTarget");
        this.camNode.setCamera(app.getCamera());
        this.camNode.setControlDir(CameraControl.ControlDirection.SpatialToCamera);
        this.target.attachChild(this.camNode);
        this.camNode.setLocalTranslation(0.0f, 0.0f, this.distance);
        this.upVector = app.getCamera().getUp().clone();
        this.leftVector = app.getCamera().getLeft().clone();
        this.registerWithInput();
        this.rotateCamera();
    }

    public final void registerWithInput() {
        String[] inputs = new String[]{"ChaseCamToggleRotate", "ChaseCamDown", "ChaseCamUp", "ChaseCamMoveLeft", "ChaseCamMoveRight", "ChaseCamZoomIn", "ChaseCamZoomOut"};
        this.initVerticalAxisInputs();
        this.initZoomInput();
        this.initHorizontalAxisInput();
        this.initTogleRotateInput();
        this.inputManager.addListener(this, inputs);
        this.inputManager.setCursorVisible(this.dragToRotate);
    }

    @Override
    public void onAction(String name, boolean keyPressed, float tpf) {
        if (this.isEnabled() && this.dragToRotate && name.equals("ChaseCamToggleRotate") && this.isEnabled()) {
            if (keyPressed) {
                this.canRotate = true;
                if (this.hideCursorOnRotate) {
                    this.inputManager.setCursorVisible(false);
                }
            } else {
                this.canRotate = false;
                if (this.hideCursorOnRotate) {
                    this.inputManager.setCursorVisible(true);
                }
            }
        }
    }

    @Override
    public void onAnalog(String name, float value, float tpf) {
        if (this.isEnabled()) {
            if (this.canRotate) {
                if (name.equals("ChaseCamMoveLeft")) {
                    this.horizontalRotation -= value * this.rotationSpeed;
                    this.rotateCamera();
                } else if (name.equals("ChaseCamMoveRight")) {
                    this.horizontalRotation += value * this.rotationSpeed;
                    this.rotateCamera();
                } else if (name.equals("ChaseCamUp")) {
                    this.verticalRotation += value * this.rotationSpeed;
                    this.rotateCamera();
                } else if (name.equals("ChaseCamDown")) {
                    this.verticalRotation -= value * this.rotationSpeed;
                    this.rotateCamera();
                }
            }
            if (name.equals("ChaseCamZoomIn")) {
                this.zoomCamera(-value * this.zoomSpeed);
            } else if (name.equals("ChaseCamZoomOut")) {
                this.zoomCamera(value * this.zoomSpeed);
            }
        }
    }

    protected void rotateCamera() {
        this.verticalRotation = FastMath.clamp(this.verticalRotation, this.minVerticalRotation, this.maxVerticalRotation);
        TempVars vars = TempVars.get();
        Quaternion rot = vars.quat1;
        Quaternion rot2 = vars.quat2;
        rot.fromAngleNormalAxis(this.verticalRotation, this.leftVector);
        rot2.fromAngleNormalAxis(this.horizontalRotation, this.upVector);
        rot2.multLocal(rot);
        this.target.setLocalRotation(rot2);
        vars.release();
    }

    protected void zoomCamera(float value) {
        this.distance = FastMath.clamp(this.distance + value, this.minDistance, this.maxDistance);
        this.camNode.setLocalTranslation(new Vector3f(0.0f, 0.0f, this.distance));
    }

    public void setTarget(Spatial targetSpatial) {
        this.spatial = targetSpatial;
    }

    @Override
    public void update(float tpf) {
        if (this.spatial == null) {
            throw new IllegalArgumentException("The spatial to follow is null, please use the setTarget method");
        }
        this.target.setLocalTranslation(this.spatial.getWorldTranslation());
        this.camNode.lookAt(this.target.getWorldTranslation(), this.upVector);
        this.target.updateLogicalState(tpf);
        this.target.updateGeometricState();
    }

    public void setToggleRotationTrigger(Trigger ... triggers) {
        this.toggleRotateTrigger = triggers;
        if (this.inputManager != null) {
            this.inputManager.deleteMapping("ChaseCamToggleRotate");
            this.initTogleRotateInput();
            this.inputManager.addListener(this, "ChaseCamToggleRotate");
        }
    }

    public void setZoomInTrigger(Trigger ... triggers) {
        this.zoomInTrigger = triggers;
        if (this.inputManager != null) {
            this.inputManager.deleteMapping("ChaseCamZoomIn");
            this.inputManager.addMapping("ChaseCamZoomIn", this.zoomInTrigger);
            this.inputManager.addListener(this, "ChaseCamZoomIn");
        }
    }

    public void setZoomOutTrigger(Trigger ... triggers) {
        this.zoomOutTrigger = triggers;
        if (this.inputManager != null) {
            this.inputManager.deleteMapping("ChaseCamZoomOut");
            this.inputManager.addMapping("ChaseCamZoomOut", this.zoomOutTrigger);
            this.inputManager.addListener(this, "ChaseCamZoomOut");
        }
    }

    public float getMaxDistance() {
        return this.maxDistance;
    }

    public void setMaxDistance(float maxDistance) {
        this.maxDistance = maxDistance;
        if (this.initialized) {
            this.zoomCamera(this.distance);
        }
    }

    public float getMinDistance() {
        return this.minDistance;
    }

    public void setMinDistance(float minDistance) {
        this.minDistance = minDistance;
        if (this.initialized) {
            this.zoomCamera(this.distance);
        }
    }

    public float getMaxVerticalRotation() {
        return this.maxVerticalRotation;
    }

    public void setMaxVerticalRotation(float maxVerticalRotation) {
        this.maxVerticalRotation = maxVerticalRotation;
        if (this.initialized) {
            this.rotateCamera();
        }
    }

    public float getMinVerticalRotation() {
        return this.minVerticalRotation;
    }

    public void setMinVerticalRotation(float minHeight) {
        this.minVerticalRotation = minHeight;
        if (this.initialized) {
            this.rotateCamera();
        }
    }

    public float getZoomSpeed() {
        return this.zoomSpeed;
    }

    public void setZoomSpeed(float zoomSpeed) {
        this.zoomSpeed = zoomSpeed;
    }

    public float getRotationSpeed() {
        return this.rotationSpeed;
    }

    public void setRotationSpeed(float rotationSpeed) {
        this.rotationSpeed = rotationSpeed;
    }

    public void setDefaultDistance(float defaultDistance) {
        this.distance = defaultDistance;
    }

    public void setDefaultHorizontalRotation(float angleInRad) {
        this.horizontalRotation = angleInRad;
    }

    public void setDefaultVerticalRotation(float angleInRad) {
        this.verticalRotation = angleInRad;
    }

    public boolean isDragToRotate() {
        return this.dragToRotate;
    }

    public void setDragToRotate(boolean dragToRotate) {
        this.dragToRotate = dragToRotate;
        boolean bl = this.canRotate = !dragToRotate;
        if (this.inputManager != null) {
            this.inputManager.setCursorVisible(dragToRotate);
        }
    }

    public void setInvertVerticalAxis(boolean invertYaxis) {
        this.invertYaxis = invertYaxis;
        if (this.inputManager != null) {
            this.inputManager.deleteMapping("ChaseCamDown");
            this.inputManager.deleteMapping("ChaseCamUp");
            this.initVerticalAxisInputs();
            this.inputManager.addListener(this, "ChaseCamDown", "ChaseCamUp");
        }
    }

    public void setInvertHorizontalAxis(boolean invertXaxis) {
        this.invertXaxis = invertXaxis;
        if (this.inputManager != null) {
            this.inputManager.deleteMapping("ChaseCamMoveLeft");
            this.inputManager.deleteMapping("ChaseCamMoveRight");
            this.initHorizontalAxisInput();
            this.inputManager.addListener(this, "ChaseCamMoveLeft", "ChaseCamMoveRight");
        }
    }

    private void initVerticalAxisInputs() {
        if (!this.invertYaxis) {
            this.inputManager.addMapping("ChaseCamDown", new MouseAxisTrigger(1, true));
            this.inputManager.addMapping("ChaseCamUp", new MouseAxisTrigger(1, false));
        } else {
            this.inputManager.addMapping("ChaseCamDown", new MouseAxisTrigger(1, false));
            this.inputManager.addMapping("ChaseCamUp", new MouseAxisTrigger(1, true));
        }
    }

    private void initHorizontalAxisInput() {
        if (!this.invertXaxis) {
            this.inputManager.addMapping("ChaseCamMoveLeft", new MouseAxisTrigger(0, true));
            this.inputManager.addMapping("ChaseCamMoveRight", new MouseAxisTrigger(0, false));
        } else {
            this.inputManager.addMapping("ChaseCamMoveLeft", new MouseAxisTrigger(0, false));
            this.inputManager.addMapping("ChaseCamMoveRight", new MouseAxisTrigger(0, true));
        }
    }

    private void initZoomInput() {
        this.inputManager.addMapping("ChaseCamZoomIn", this.zoomInTrigger);
        this.inputManager.addMapping("ChaseCamZoomOut", this.zoomOutTrigger);
    }

    private void initTogleRotateInput() {
        this.inputManager.addMapping("ChaseCamToggleRotate", this.toggleRotateTrigger);
    }
}

