/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shader;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.material.MatParam;
import com.jme3.material.TechniqueDef;
import com.jme3.shader.VarType;
import com.jme3.util.ListMap;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;

public final class DefineList
implements Savable,
Cloneable {
    private static final String ONE = "1";
    private TreeMap<String, String> defines = new TreeMap();
    private String compiled = null;
    private int cachedHashCode = 0;

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        String[] keys = new String[this.defines.size()];
        String[] vals = new String[this.defines.size()];
        int i = 0;
        for (Map.Entry<String, String> define : this.defines.entrySet()) {
            keys[i] = define.getKey();
            vals[i] = define.getValue();
            ++i;
        }
        oc.write(keys, "keys", null);
        oc.write(vals, "vals", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        String[] keys = ic.readStringArray("keys", null);
        String[] vals = ic.readStringArray("vals", null);
        for (int i = 0; i < keys.length; ++i) {
            this.defines.put(keys[i], vals[i]);
        }
    }

    public void clear() {
        this.defines.clear();
        this.compiled = "";
        this.cachedHashCode = 0;
    }

    public String get(String key) {
        return this.defines.get(key);
    }

    public DefineList clone() {
        try {
            DefineList clone = (DefineList)super.clone();
            clone.cachedHashCode = 0;
            clone.compiled = null;
            clone.defines = (TreeMap)this.defines.clone();
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public boolean set(String key, VarType type, Object val) {
        if (val == null) {
            this.defines.remove(key);
            this.compiled = null;
            this.cachedHashCode = 0;
            return true;
        }
        switch (type) {
            case Boolean: {
                if (((Boolean)val).booleanValue()) {
                    if (this.defines.put(key, ONE) == ONE) break;
                    this.compiled = null;
                    this.cachedHashCode = 0;
                    return true;
                }
                if (!this.defines.containsKey(key)) break;
                this.defines.remove(key);
                this.compiled = null;
                this.cachedHashCode = 0;
                return true;
            }
            case Float: 
            case Int: {
                String newValue = val.toString();
                String original = this.defines.put(key, newValue);
                if (val.equals(original)) break;
                this.compiled = null;
                this.cachedHashCode = 0;
                return true;
            }
            default: {
                if (this.defines.put(key, ONE) == ONE) break;
                this.compiled = null;
                this.cachedHashCode = 0;
                return true;
            }
        }
        return false;
    }

    public boolean remove(String key) {
        if (this.defines.remove(key) != null) {
            this.compiled = null;
            this.cachedHashCode = 0;
            return true;
        }
        return false;
    }

    public void addFrom(DefineList other) {
        if (other == null) {
            return;
        }
        this.compiled = null;
        this.cachedHashCode = 0;
        this.defines.putAll(other.defines);
    }

    public String getCompiled() {
        if (this.compiled == null) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : this.defines.entrySet()) {
                sb.append("#define ").append(entry.getKey()).append(" ");
                sb.append(entry.getValue()).append('\n');
            }
            this.compiled = sb.toString();
        }
        return this.compiled;
    }

    public boolean equals(Object obj) {
        DefineList other = (DefineList)obj;
        return this.defines.equals(other.defines);
    }

    public boolean update(ListMap params, TechniqueDef def) {
        if (this.equalsParams(params, def)) {
            return false;
        }
        this.clear();
        for (int i = 0; i < params.size(); ++i) {
            MatParam param = (MatParam)params.getValue(i);
            String defineName = def.getShaderParamDefine(param.getName());
            if (defineName == null) continue;
            this.set(defineName, param.getVarType(), param.getValue());
        }
        return true;
    }

    private boolean equalsParams(ListMap params, TechniqueDef def) {
        int size = 0;
        block4: for (int i = 0; i < params.size(); ++i) {
            Object val;
            MatParam param = (MatParam)params.getValue(i);
            String key = def.getShaderParamDefine(param.getName());
            if (key == null || (val = param.getValue()) == null) continue;
            switch (param.getVarType()) {
                case Boolean: {
                    String current = this.defines.get(key);
                    if (((Boolean)val).booleanValue()) {
                        if (current == null || current != ONE) {
                            return false;
                        }
                        ++size;
                        continue block4;
                    }
                    if (current == null) continue block4;
                    return false;
                }
                case Float: 
                case Int: {
                    String newValue = val.toString();
                    String current = this.defines.get(key);
                    if (!newValue.equals(current)) {
                        return false;
                    }
                    ++size;
                    continue block4;
                }
                default: {
                    if (!this.defines.containsKey(key)) {
                        return false;
                    }
                    ++size;
                }
            }
        }
        return size == this.defines.size();
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            this.cachedHashCode = this.defines.hashCode();
        }
        return this.cachedHashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (Map.Entry<String, String> entry : this.defines.entrySet()) {
            sb.append(entry.getKey()).append("=").append(entry.getValue());
            if (i != this.defines.size() - 1) {
                sb.append(", ");
            }
            ++i;
        }
        return sb.toString();
    }
}

