/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system;

import com.jme3.asset.AssetManager;
import com.jme3.asset.DesktopAssetManager;
import com.jme3.audio.AudioRenderer;
import com.jme3.input.SoftTextDialogInput;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeContext;
import com.jme3.system.JmeSystem;
import com.jme3.system.JmeVersion;
import com.jme3.system.Platform;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.EnumMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class JmeSystemDelegate {
    protected final Logger logger = Logger.getLogger(JmeSystem.class.getName());
    protected boolean initialized = false;
    protected boolean lowPermissions = false;
    protected Map<JmeSystem.StorageFolderType, File> storageFolders = new EnumMap<JmeSystem.StorageFolderType, File>(JmeSystem.StorageFolderType.class);
    protected SoftTextDialogInput softTextDialogInput = null;

    public synchronized File getStorageFolder(JmeSystem.StorageFolderType type) {
        File storageFolder = null;
        switch (type) {
            case Internal: 
            case External: {
                if (this.lowPermissions) {
                    throw new UnsupportedOperationException("File system access restricted");
                }
                storageFolder = this.storageFolders.get((Object)type);
                if (storageFolder != null) break;
                storageFolder = new File(System.getProperty("user.home"), ".jme3");
                if (!storageFolder.exists()) {
                    storageFolder.mkdir();
                }
                this.storageFolders.put(type, storageFolder);
                break;
            }
        }
        if (storageFolder != null) {
            this.logger.log(Level.FINE, "Storage Folder Path: {0}", storageFolder.getAbsolutePath());
        } else {
            this.logger.log(Level.FINE, "Storage Folder not found!");
        }
        return storageFolder;
    }

    public String getFullName() {
        return JmeVersion.FULL_NAME;
    }

    public InputStream getResourceAsStream(String name) {
        return this.getClass().getResourceAsStream(name);
    }

    public URL getResource(String name) {
        return this.getClass().getResource(name);
    }

    public boolean trackDirectMemory() {
        return false;
    }

    public void setLowPermissions(boolean lowPerm) {
        this.lowPermissions = lowPerm;
    }

    public boolean isLowPermissions() {
        return this.lowPermissions;
    }

    public void setSoftTextDialogInput(SoftTextDialogInput input) {
        this.softTextDialogInput = input;
    }

    public SoftTextDialogInput getSoftTextDialogInput() {
        return this.softTextDialogInput;
    }

    public final AssetManager newAssetManager(URL configFile) {
        return new DesktopAssetManager(configFile);
    }

    public final AssetManager newAssetManager() {
        return new DesktopAssetManager(null);
    }

    public abstract void writeImageFile(OutputStream var1, String var2, ByteBuffer var3, int var4, int var5) throws IOException;

    public abstract void showErrorDialog(String var1);

    public abstract boolean showSettingsDialog(AppSettings var1, boolean var2);

    private boolean is64Bit(String arch) {
        if (arch.equals("x86")) {
            return false;
        }
        if (arch.equals("amd64")) {
            return true;
        }
        if (arch.equals("x86_64")) {
            return true;
        }
        if (arch.equals("ppc") || arch.equals("PowerPC")) {
            return false;
        }
        if (arch.equals("ppc64")) {
            return true;
        }
        if (arch.equals("i386") || arch.equals("i686")) {
            return false;
        }
        if (arch.equals("universal")) {
            return false;
        }
        if (arch.equals("arm")) {
            return false;
        }
        throw new UnsupportedOperationException("Unsupported architecture: " + arch);
    }

    public Platform getPlatform() {
        String os = System.getProperty("os.name").toLowerCase();
        String arch = System.getProperty("os.arch").toLowerCase();
        boolean is64 = this.is64Bit(arch);
        if (os.contains("windows")) {
            return is64 ? Platform.Windows64 : Platform.Windows32;
        }
        if (os.contains("linux") || os.contains("freebsd") || os.contains("sunos")) {
            return is64 ? Platform.Linux64 : Platform.Linux32;
        }
        if (os.contains("mac os x") || os.contains("darwin")) {
            if (arch.startsWith("ppc")) {
                return is64 ? Platform.MacOSX_PPC64 : Platform.MacOSX_PPC32;
            }
            return is64 ? Platform.MacOSX64 : Platform.MacOSX32;
        }
        throw new UnsupportedOperationException("The specified platform: " + os + " is not supported.");
    }

    public String getBuildInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("Running on ").append(this.getFullName()).append("\n");
        sb.append(" * Branch: ").append(JmeVersion.BRANCH_NAME).append("\n");
        sb.append(" * Git Hash: ").append(JmeVersion.GIT_SHORT_HASH).append("\n");
        sb.append(" * Build Date: ").append(JmeVersion.BUILD_DATE);
        return sb.toString();
    }

    public abstract URL getPlatformAssetConfigURL();

    public abstract JmeContext newContext(AppSettings var1, JmeContext.Type var2);

    public abstract AudioRenderer newAudioRenderer(AppSettings var1);

    public abstract void initialize(AppSettings var1);

    public abstract void showSoftKeyboard(boolean var1);
}

