/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.app.state;

import com.jme3.app.Application;
import com.jme3.app.state.AbstractAppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Node;

public class RootNodeAppState
extends AbstractAppState {
    protected ViewPort viewPort;
    protected Node rootNode;

    public RootNodeAppState() {
    }

    public RootNodeAppState(ViewPort viewPort) {
        this.viewPort = viewPort;
    }

    public RootNodeAppState(Node rootNode) {
        this.rootNode = rootNode;
    }

    public RootNodeAppState(ViewPort viewPort, Node rootNode) {
        this.viewPort = viewPort;
        this.rootNode = rootNode;
    }

    @Override
    public void initialize(AppStateManager stateManager, Application app) {
        if (this.rootNode == null) {
            this.rootNode = new Node("Root Node");
        }
        if (this.viewPort == null) {
            this.viewPort = app.getViewPort();
        }
        this.viewPort.attachScene(this.rootNode);
        super.initialize(stateManager, app);
    }

    @Override
    public void update(float tpf) {
        super.update(tpf);
        this.rootNode.updateLogicalState(tpf);
        this.rootNode.updateGeometricState();
    }

    @Override
    public void cleanup() {
        this.viewPort.detachScene(this.rootNode);
        super.cleanup();
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public ViewPort getViewPort() {
        return this.viewPort;
    }
}

