/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.export.binary;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetManager;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeImporter;
import com.jme3.export.ReadListener;
import com.jme3.export.Savable;
import com.jme3.export.SavableClassUtil;
import com.jme3.export.binary.BinaryClassField;
import com.jme3.export.binary.BinaryClassObject;
import com.jme3.export.binary.BinaryInputCapsule;
import com.jme3.export.binary.ByteUtils;
import com.jme3.math.FastMath;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class BinaryImporter
implements JmeImporter {
    private static final Logger logger = Logger.getLogger(BinaryImporter.class.getName());
    private AssetManager assetManager;
    private HashMap<String, BinaryClassObject> classes = new HashMap();
    private HashMap<Integer, Savable> contentTable = new HashMap();
    private IdentityHashMap<Savable, BinaryInputCapsule> capsuleTable = new IdentityHashMap();
    private HashMap<Integer, Integer> locationTable = new HashMap();
    public static boolean debug = false;
    private byte[] dataArray;
    private int aliasWidth;
    private int formatVersion;
    private static final boolean fastRead = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;

    @Override
    public int getFormatVersion() {
        return this.formatVersion;
    }

    public static boolean canUseFastBuffers() {
        return fastRead;
    }

    public static BinaryImporter getInstance() {
        return new BinaryImporter();
    }

    public void setAssetManager(AssetManager manager) {
        this.assetManager = manager;
    }

    @Override
    public AssetManager getAssetManager() {
        return this.assetManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object load(AssetInfo info) {
        this.assetManager = info.getManager();
        InputStream is = null;
        try {
            Savable s;
            is = info.openStream();
            Savable savable = s = this.load(is);
            return savable;
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "An error occured while loading jME binary object", ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public Savable load(InputStream is) throws IOException {
        return this.load(is, null, null);
    }

    public Savable load(InputStream is, ReadListener listener) throws IOException {
        return this.load(is, listener, null);
    }

    public Savable load(InputStream is, ReadListener listener, ByteArrayOutputStream baos) throws IOException {
        int numClasses;
        this.contentTable.clear();
        BufferedInputStream bis = new BufferedInputStream(is);
        int maybeSignature = ByteUtils.readInt(bis);
        if (maybeSignature == 1246577971) {
            this.formatVersion = ByteUtils.readInt(bis);
            numClasses = ByteUtils.readInt(bis);
            if (this.formatVersion > 2) {
                throw new IOException("The binary file is of newer version than expected! " + this.formatVersion + " > " + 2);
            }
        } else {
            numClasses = maybeSignature;
            this.formatVersion = 0;
        }
        int bytes = 4;
        this.aliasWidth = (int)FastMath.log(numClasses, 256.0f) + 1;
        this.classes.clear();
        for (int i = 0; i < numClasses; ++i) {
            int[] classHierarchyVersions;
            String alias = this.readString(bis, this.aliasWidth);
            if (this.formatVersion >= 1) {
                int classHierarchySize = bis.read();
                classHierarchyVersions = new int[classHierarchySize];
                for (int j = 0; j < classHierarchySize; ++j) {
                    classHierarchyVersions[j] = ByteUtils.readInt(bis);
                }
            } else {
                classHierarchyVersions = new int[]{0};
            }
            int classLength = ByteUtils.readInt(bis);
            String className = this.readString(bis, classLength);
            BinaryClassObject bco = new BinaryClassObject();
            bco.alias = alias.getBytes();
            bco.className = className;
            bco.classHierarchyVersions = classHierarchyVersions;
            int fields = ByteUtils.readInt(bis);
            bytes += 8 + this.aliasWidth + classLength;
            bco.nameFields = new HashMap(fields);
            bco.aliasFields = new HashMap(fields);
            for (int x = 0; x < fields; ++x) {
                byte fieldAlias = (byte)bis.read();
                byte fieldType = (byte)bis.read();
                int fieldNameLength = ByteUtils.readInt(bis);
                String fieldName = this.readString(bis, fieldNameLength);
                BinaryClassField bcf = new BinaryClassField(fieldName, fieldAlias, fieldType);
                bco.nameFields.put(fieldName, bcf);
                bco.aliasFields.put(fieldAlias, bcf);
                bytes += 6 + fieldNameLength;
            }
            this.classes.put(alias, bco);
        }
        if (listener != null) {
            listener.readBytes(bytes);
        }
        int numLocs = ByteUtils.readInt(bis);
        bytes = 4;
        this.capsuleTable.clear();
        this.locationTable.clear();
        for (int i = 0; i < numLocs; ++i) {
            int id = ByteUtils.readInt(bis);
            int loc = ByteUtils.readInt(bis);
            this.locationTable.put(id, loc);
            bytes += 8;
        }
        int numbIDs = ByteUtils.readInt(bis);
        int id = ByteUtils.readInt(bis);
        bytes += 8;
        if (listener != null) {
            listener.readBytes(bytes);
        }
        if (baos == null) {
            baos = new ByteArrayOutputStream(bytes);
        } else {
            baos.reset();
        }
        int size = -1;
        byte[] cache = new byte[4096];
        while ((size = bis.read(cache)) != -1) {
            baos.write(cache, 0, size);
            if (listener == null) continue;
            listener.readBytes(size);
        }
        bis = null;
        this.dataArray = baos.toByteArray();
        baos = null;
        Savable rVal = this.readObject(id);
        if (debug) {
            logger.fine("Importer Stats: ");
            logger.log(Level.FINE, "Tags: {0}", numClasses);
            logger.log(Level.FINE, "Objects: {0}", numLocs);
            logger.log(Level.FINE, "Data Size: {0}", this.dataArray.length);
        }
        this.dataArray = null;
        return rVal;
    }

    public Savable load(URL f) throws IOException {
        return this.load(f, null);
    }

    public Savable load(URL f, ReadListener listener) throws IOException {
        InputStream is = f.openStream();
        Savable rVal = this.load(is, listener);
        is.close();
        return rVal;
    }

    public Savable load(File f) throws IOException {
        return this.load(f, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Savable load(File f, ReadListener listener) throws IOException {
        FileInputStream fis = new FileInputStream(f);
        try {
            Savable savable = this.load(fis, listener);
            return savable;
        }
        finally {
            fis.close();
        }
    }

    public Savable load(byte[] data) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        Savable rVal = this.load(bais);
        bais.close();
        return rVal;
    }

    @Override
    public InputCapsule getCapsule(Savable id) {
        return this.capsuleTable.get(id);
    }

    protected String readString(InputStream f, int length) throws IOException {
        byte[] data = new byte[length];
        for (int j = 0; j < length; ++j) {
            data[j] = (byte)f.read();
        }
        return new String(data);
    }

    protected String readString(int length, int offset) throws IOException {
        byte[] data = new byte[length];
        for (int j = 0; j < length; ++j) {
            data[j] = this.dataArray[j + offset];
        }
        return new String(data);
    }

    public Savable readObject(int id) {
        if (this.contentTable.get(id) != null) {
            return this.contentTable.get(id);
        }
        try {
            int loc = this.locationTable.get(id);
            String alias = this.readString(this.aliasWidth, loc);
            loc += this.aliasWidth;
            BinaryClassObject bco = this.classes.get(alias);
            if (bco == null) {
                logger.logp(Level.SEVERE, this.getClass().toString(), "readObject(int id)", "NULL class object: " + alias);
                return null;
            }
            int dataLength = ByteUtils.convertIntFromBytes(this.dataArray, loc);
            Savable out = null;
            out = this.assetManager != null ? SavableClassUtil.fromName(bco.className, this.assetManager.getClassLoaders()) : SavableClassUtil.fromName(bco.className);
            BinaryInputCapsule cap = new BinaryInputCapsule(this, out, bco);
            cap.setContent(this.dataArray, loc += 4, loc + dataLength);
            this.capsuleTable.put(out, cap);
            this.contentTable.put(id, out);
            out.read(this);
            this.capsuleTable.remove(out);
            return out;
        }
        catch (IOException e) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "readObject(int id)", "Exception", e);
            return null;
        }
        catch (ClassNotFoundException e) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "readObject(int id)", "Exception", e);
            return null;
        }
        catch (InstantiationException e) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "readObject(int id)", "Exception", e);
            return null;
        }
        catch (IllegalAccessException e) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "readObject(int id)", "Exception", e);
            return null;
        }
    }
}

