/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.material;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.material.RenderState;
import com.jme3.material.ShaderGenerationInfo;
import com.jme3.renderer.Caps;
import com.jme3.shader.DefineList;
import com.jme3.shader.Shader;
import com.jme3.shader.ShaderNode;
import com.jme3.shader.UniformBinding;
import com.jme3.shader.VarType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;

public class TechniqueDef
implements Savable {
    public static final int SAVABLE_VERSION = 1;
    private EnumSet<Caps> requiredCaps = EnumSet.noneOf(Caps.class);
    private String name;
    private EnumMap<Shader.ShaderType, String> shaderLanguages;
    private EnumMap<Shader.ShaderType, String> shaderNames;
    private DefineList presetDefines;
    private boolean usesNodes = false;
    private List<ShaderNode> shaderNodes;
    private ShaderGenerationInfo shaderGenerationInfo;
    private boolean noRender = false;
    private RenderState renderState;
    private RenderState forcedRenderState;
    private LightMode lightMode = LightMode.Disable;
    private ShadowMode shadowMode = ShadowMode.Disable;
    private HashMap<String, String> defineParams;
    private ArrayList<UniformBinding> worldBinds;

    public TechniqueDef(String name) {
        this();
        this.name = name == null ? "Default" : name;
    }

    public TechniqueDef() {
        this.shaderLanguages = new EnumMap(Shader.ShaderType.class);
        this.shaderNames = new EnumMap(Shader.ShaderType.class);
    }

    public String getName() {
        return this.name;
    }

    public LightMode getLightMode() {
        return this.lightMode;
    }

    public void setLightMode(LightMode lightMode) {
        this.lightMode = lightMode;
    }

    public ShadowMode getShadowMode() {
        return this.shadowMode;
    }

    public void setShadowMode(ShadowMode shadowMode) {
        this.shadowMode = shadowMode;
    }

    public RenderState getRenderState() {
        return this.renderState;
    }

    public void setRenderState(RenderState renderState) {
        this.renderState = renderState;
    }

    public void setNoRender(boolean noRender) {
        this.noRender = noRender;
    }

    public boolean isNoRender() {
        return this.noRender;
    }

    @Deprecated
    public boolean isUsingShaders() {
        return true;
    }

    public boolean isUsingShaderNodes() {
        return this.usesNodes;
    }

    public EnumSet<Caps> getRequiredCaps() {
        return this.requiredCaps;
    }

    public void setShaderFile(String vertexShader, String fragmentShader, String vertLanguage, String fragLanguage) {
        this.shaderLanguages.put(Shader.ShaderType.Vertex, vertLanguage);
        this.shaderNames.put(Shader.ShaderType.Vertex, vertexShader);
        this.shaderLanguages.put(Shader.ShaderType.Fragment, fragLanguage);
        this.shaderNames.put(Shader.ShaderType.Fragment, fragmentShader);
        this.requiredCaps.clear();
        Caps vertCap = Caps.valueOf(vertLanguage);
        this.requiredCaps.add(vertCap);
        Caps fragCap = Caps.valueOf(fragLanguage);
        this.requiredCaps.add(fragCap);
    }

    public void setShaderFile(EnumMap<Shader.ShaderType, String> shaderNames, EnumMap<Shader.ShaderType, String> shaderLanguages) {
        this.requiredCaps.clear();
        for (Shader.ShaderType shaderType : shaderNames.keySet()) {
            String language = shaderLanguages.get((Object)shaderType);
            String shaderFile = shaderNames.get((Object)shaderType);
            this.shaderLanguages.put(shaderType, language);
            this.shaderNames.put(shaderType, shaderFile);
            Caps vertCap = Caps.valueOf(language);
            this.requiredCaps.add(vertCap);
            if (shaderType.equals((Object)Shader.ShaderType.Geometry)) {
                this.requiredCaps.add(Caps.GeometryShader);
                continue;
            }
            if (!shaderType.equals((Object)Shader.ShaderType.TessellationControl)) continue;
            this.requiredCaps.add(Caps.TesselationShader);
        }
    }

    public String getShaderParamDefine(String paramName) {
        if (this.defineParams == null) {
            return null;
        }
        return this.defineParams.get(paramName);
    }

    public void addShaderParamDefine(String paramName, String defineName) {
        if (this.defineParams == null) {
            this.defineParams = new HashMap();
        }
        this.defineParams.put(paramName, defineName);
    }

    public DefineList getShaderPresetDefines() {
        return this.presetDefines;
    }

    public void addShaderPresetDefine(String defineName, VarType type, Object value) {
        if (this.presetDefines == null) {
            this.presetDefines = new DefineList();
        }
        this.presetDefines.set(defineName, type, value);
    }

    public String getFragmentShaderName() {
        return this.shaderNames.get((Object)Shader.ShaderType.Fragment);
    }

    public String getVertexShaderName() {
        return this.shaderNames.get((Object)Shader.ShaderType.Vertex);
    }

    public String getFragmentShaderLanguage() {
        return this.shaderLanguages.get((Object)Shader.ShaderType.Fragment);
    }

    public String getVertexShaderLanguage() {
        return this.shaderLanguages.get((Object)Shader.ShaderType.Vertex);
    }

    public String getShaderProgramLanguage(Shader.ShaderType shaderType) {
        return this.shaderLanguages.get((Object)shaderType);
    }

    public String getShaderProgramName(Shader.ShaderType shaderType) {
        return this.shaderNames.get((Object)shaderType);
    }

    public boolean addWorldParam(String name) {
        if (this.worldBinds == null) {
            this.worldBinds = new ArrayList();
        }
        try {
            this.worldBinds.add(UniformBinding.valueOf(name));
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public RenderState getForcedRenderState() {
        return this.forcedRenderState;
    }

    public void setForcedRenderState(RenderState forcedRenderState) {
        this.forcedRenderState = forcedRenderState;
    }

    public List<UniformBinding> getWorldBindings() {
        return this.worldBinds;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.name, "name", null);
        oc.write(this.shaderNames.get((Object)Shader.ShaderType.Vertex), "vertName", null);
        oc.write(this.shaderNames.get((Object)Shader.ShaderType.Fragment), "fragName", null);
        oc.write(this.shaderNames.get((Object)Shader.ShaderType.Geometry), "geomName", null);
        oc.write(this.shaderNames.get((Object)Shader.ShaderType.TessellationControl), "tsctrlName", null);
        oc.write(this.shaderNames.get((Object)Shader.ShaderType.TessellationEvaluation), "tsevalName", null);
        oc.write(this.shaderLanguages.get((Object)Shader.ShaderType.Vertex), "vertLanguage", null);
        oc.write(this.shaderLanguages.get((Object)Shader.ShaderType.Fragment), "fragLanguage", null);
        oc.write(this.shaderLanguages.get((Object)Shader.ShaderType.Geometry), "geomLanguage", null);
        oc.write(this.shaderLanguages.get((Object)Shader.ShaderType.TessellationControl), "tsctrlLanguage", null);
        oc.write(this.shaderLanguages.get((Object)Shader.ShaderType.TessellationEvaluation), "tsevalLanguage", null);
        oc.write(this.presetDefines, "presetDefines", null);
        oc.write(this.lightMode, "lightMode", LightMode.Disable);
        oc.write(this.shadowMode, "shadowMode", ShadowMode.Disable);
        oc.write(this.renderState, "renderState", null);
        oc.write(this.noRender, "noRender", false);
        oc.write(this.usesNodes, "usesNodes", false);
        oc.writeSavableArrayList((ArrayList)this.shaderNodes, "shaderNodes", null);
        oc.write(this.shaderGenerationInfo, "shaderGenerationInfo", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.name = ic.readString("name", null);
        this.shaderNames.put(Shader.ShaderType.Vertex, ic.readString("vertName", null));
        this.shaderNames.put(Shader.ShaderType.Fragment, ic.readString("fragName", null));
        this.shaderNames.put(Shader.ShaderType.Geometry, ic.readString("geomName", null));
        this.shaderNames.put(Shader.ShaderType.TessellationControl, ic.readString("tsctrlName", null));
        this.shaderNames.put(Shader.ShaderType.TessellationEvaluation, ic.readString("tsevalName", null));
        this.presetDefines = (DefineList)ic.readSavable("presetDefines", null);
        this.lightMode = ic.readEnum("lightMode", LightMode.class, LightMode.Disable);
        this.shadowMode = ic.readEnum("shadowMode", ShadowMode.class, ShadowMode.Disable);
        this.renderState = (RenderState)ic.readSavable("renderState", null);
        this.noRender = ic.readBoolean("noRender", false);
        if (ic.getSavableVersion(TechniqueDef.class) == 0) {
            this.shaderLanguages.put(Shader.ShaderType.Vertex, ic.readString("shaderLang", null));
            this.shaderLanguages.put(Shader.ShaderType.Fragment, this.shaderLanguages.get((Object)Shader.ShaderType.Vertex));
        } else {
            this.shaderLanguages.put(Shader.ShaderType.Vertex, ic.readString("vertLanguage", null));
            this.shaderLanguages.put(Shader.ShaderType.Fragment, ic.readString("fragLanguage", null));
            this.shaderLanguages.put(Shader.ShaderType.Geometry, ic.readString("geomLanguage", null));
            this.shaderLanguages.put(Shader.ShaderType.TessellationControl, ic.readString("tsctrlLanguage", null));
            this.shaderLanguages.put(Shader.ShaderType.TessellationEvaluation, ic.readString("tsevalLanguage", null));
        }
        this.usesNodes = ic.readBoolean("usesNodes", false);
        this.shaderNodes = ic.readSavableArrayList("shaderNodes", null);
        this.shaderGenerationInfo = (ShaderGenerationInfo)ic.readSavable("shaderGenerationInfo", null);
    }

    public List<ShaderNode> getShaderNodes() {
        return this.shaderNodes;
    }

    public void setShaderNodes(List<ShaderNode> shaderNodes) {
        this.shaderNodes = shaderNodes;
        this.usesNodes = true;
    }

    public EnumMap<Shader.ShaderType, String> getShaderProgramNames() {
        return this.shaderNames;
    }

    public EnumMap<Shader.ShaderType, String> getShaderProgramLanguages() {
        return this.shaderLanguages;
    }

    public ShaderGenerationInfo getShaderGenerationInfo() {
        return this.shaderGenerationInfo;
    }

    public void setShaderGenerationInfo(ShaderGenerationInfo shaderGenerationInfo) {
        this.shaderGenerationInfo = shaderGenerationInfo;
    }

    public String toString() {
        return "TechniqueDef{requiredCaps=" + this.requiredCaps + ", name=" + this.name + ", presetDefines=" + this.presetDefines + ", usesNodes=" + this.usesNodes + ", shaderNodes=" + this.shaderNodes + ", shaderGenerationInfo=" + this.shaderGenerationInfo + ", renderState=" + this.renderState + ", forcedRenderState=" + this.forcedRenderState + ", lightMode=" + (Object)((Object)this.lightMode) + ", shadowMode=" + (Object)((Object)this.shadowMode) + ", defineParams=" + this.defineParams + ", worldBinds=" + this.worldBinds + ", noRender=" + this.noRender + '}';
    }

    public static enum LightMode {
        Disable,
        SinglePass,
        MultiPass,
        FixedPipeline;

    }

    public static enum ShadowMode {
        Disable,
        InPass,
        PostPass;

    }
}

