/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.material.plugins;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetLoadException;
import com.jme3.asset.AssetLoader;
import com.jme3.asset.AssetManager;
import com.jme3.asset.AssetNotFoundException;
import com.jme3.asset.MaterialKey;
import com.jme3.asset.TextureKey;
import com.jme3.material.MatParam;
import com.jme3.material.Material;
import com.jme3.material.MaterialDef;
import com.jme3.material.RenderState;
import com.jme3.material.TechniqueDef;
import com.jme3.material.plugins.MatParseException;
import com.jme3.material.plugins.ShaderNodeLoaderDelegate;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.shader.Shader;
import com.jme3.shader.VarType;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.texture.image.ColorSpace;
import com.jme3.util.PlaceholderAssets;
import com.jme3.util.blockparser.BlockLanguageParser;
import com.jme3.util.blockparser.Statement;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class J3MLoader
implements AssetLoader {
    private static final Logger logger = Logger.getLogger(J3MLoader.class.getName());
    private ShaderNodeLoaderDelegate nodesLoaderDelegate;
    boolean isUseNodes = false;
    private AssetManager assetManager;
    private AssetKey key;
    private MaterialDef materialDef;
    private Material material;
    private TechniqueDef technique;
    private RenderState renderState;
    private EnumMap<Shader.ShaderType, String> shaderLanguage = new EnumMap(Shader.ShaderType.class);
    private EnumMap<Shader.ShaderType, String> shaderName = new EnumMap(Shader.ShaderType.class);
    private static final String whitespacePattern = "\\p{javaWhitespace}+";

    private void readShaderStatement(String statement) throws IOException {
        String[] split = statement.split(":");
        if (split.length != 2) {
            throw new IOException("Shader statement syntax incorrect" + statement);
        }
        String[] typeAndLang = split[0].split(whitespacePattern);
        if (typeAndLang.length != 2) {
            throw new IOException("Shader statement syntax incorrect: " + statement);
        }
        for (Shader.ShaderType shaderType : Shader.ShaderType.values()) {
            if (!typeAndLang[0].equals(shaderType.toString() + "Shader")) continue;
            this.readShaderDefinition(shaderType, split[1].trim(), typeAndLang[1]);
        }
    }

    private void readShaderDefinition(Shader.ShaderType shaderType, String name, String language) {
        this.shaderName.put(shaderType, name);
        this.shaderLanguage.put(shaderType, language);
    }

    private void readLightMode(String statement) throws IOException {
        String[] split = statement.split(whitespacePattern);
        if (split.length != 2) {
            throw new IOException("LightMode statement syntax incorrect");
        }
        TechniqueDef.LightMode lm = TechniqueDef.LightMode.valueOf(split[1]);
        this.technique.setLightMode(lm);
    }

    private void readShadowMode(String statement) throws IOException {
        String[] split = statement.split(whitespacePattern);
        if (split.length != 2) {
            throw new IOException("ShadowMode statement syntax incorrect");
        }
        TechniqueDef.ShadowMode sm = TechniqueDef.ShadowMode.valueOf(split[1]);
        this.technique.setShadowMode(sm);
    }

    private Object readValue(VarType type, String value) throws IOException {
        if (type.isTextureType()) {
            Texture tex;
            String texturePath = value.trim();
            boolean flipY = false;
            boolean repeat = false;
            if (texturePath.startsWith("Flip Repeat ")) {
                texturePath = texturePath.substring(12).trim();
                flipY = true;
                repeat = true;
            } else if (texturePath.startsWith("Flip ")) {
                texturePath = texturePath.substring(5).trim();
                flipY = true;
            } else if (texturePath.startsWith("Repeat ")) {
                texturePath = texturePath.substring(7).trim();
                repeat = true;
            }
            TextureKey texKey = new TextureKey(texturePath, flipY);
            switch (type) {
                case Texture3D: {
                    texKey.setTextureTypeHint(Texture.Type.ThreeDimensional);
                    break;
                }
                case TextureArray: {
                    texKey.setTextureTypeHint(Texture.Type.TwoDimensionalArray);
                    break;
                }
                case TextureCubeMap: {
                    texKey.setTextureTypeHint(Texture.Type.CubeMap);
                }
            }
            texKey.setGenerateMips(true);
            try {
                tex = this.assetManager.loadTexture(texKey);
            }
            catch (AssetNotFoundException ex) {
                logger.log(Level.WARNING, "Cannot locate {0} for material {1}", new Object[]{texKey, this.key});
                tex = null;
            }
            if (tex != null) {
                if (repeat) {
                    tex.setWrap(Texture.WrapMode.Repeat);
                }
            } else {
                tex = new Texture2D(PlaceholderAssets.getPlaceholderImage(this.assetManager));
                if (repeat) {
                    tex.setWrap(Texture.WrapMode.Repeat);
                }
                tex.setKey(texKey);
                tex.setName(texKey.getName());
            }
            return tex;
        }
        String[] split = value.trim().split(whitespacePattern);
        switch (type) {
            case Float: {
                if (split.length != 1) {
                    throw new IOException("Float value parameter must have 1 entry: " + value);
                }
                return Float.valueOf(Float.parseFloat(split[0]));
            }
            case Vector2: {
                if (split.length != 2) {
                    throw new IOException("Vector2 value parameter must have 2 entries: " + value);
                }
                return new Vector2f(Float.parseFloat(split[0]), Float.parseFloat(split[1]));
            }
            case Vector3: {
                if (split.length != 3) {
                    throw new IOException("Vector3 value parameter must have 3 entries: " + value);
                }
                return new Vector3f(Float.parseFloat(split[0]), Float.parseFloat(split[1]), Float.parseFloat(split[2]));
            }
            case Vector4: {
                if (split.length != 4) {
                    throw new IOException("Vector4 value parameter must have 4 entries: " + value);
                }
                return new ColorRGBA(Float.parseFloat(split[0]), Float.parseFloat(split[1]), Float.parseFloat(split[2]), Float.parseFloat(split[3]));
            }
            case Int: {
                if (split.length != 1) {
                    throw new IOException("Int value parameter must have 1 entry: " + value);
                }
                return Integer.parseInt(split[0]);
            }
            case Boolean: {
                if (split.length != 1) {
                    throw new IOException("Boolean value parameter must have 1 entry: " + value);
                }
                return Boolean.parseBoolean(split[0]);
            }
        }
        throw new UnsupportedOperationException("Unknown type: " + (Object)((Object)type));
    }

    private void readParam(String statement) throws IOException {
        int startParen;
        String defaultVal = null;
        ColorSpace colorSpace = null;
        String[] split = statement.split(":");
        if (split.length != 1) {
            if (split.length != 2) {
                throw new IOException("Parameter statement syntax incorrect");
            }
            statement = split[0].trim();
            defaultVal = split[1].trim();
        }
        if (statement.endsWith("-LINEAR")) {
            colorSpace = ColorSpace.Linear;
            statement = statement.substring(0, statement.length() - "-LINEAR".length());
        }
        if ((startParen = statement.indexOf("(")) != -1) {
            int endParen = statement.indexOf(")", startParen);
            String bindingStr = statement.substring(startParen + 1, endParen).trim();
            statement = statement.substring(0, startParen);
        }
        if ((split = statement.split(whitespacePattern)).length != 2) {
            throw new IOException("Parameter statement syntax incorrect");
        }
        VarType type = split[0].equals("Color") ? VarType.Vector4 : VarType.valueOf(split[0]);
        String name = split[1];
        Object defaultValObj = null;
        if (defaultVal != null) {
            defaultValObj = this.readValue(type, defaultVal);
        }
        if (type.isTextureType()) {
            this.materialDef.addMaterialParamTexture(type, name, colorSpace);
        } else {
            this.materialDef.addMaterialParam(type, name, defaultValObj);
        }
    }

    private void readValueParam(String statement) throws IOException {
        String[] split = statement.split(":", 2);
        if (split.length != 2) {
            throw new IOException("Value parameter statement syntax incorrect");
        }
        String name = split[0].trim();
        MatParam p = this.material.getMaterialDef().getMaterialParam(name);
        if (p == null) {
            throw new IOException("The material parameter: " + name + " is undefined.");
        }
        Object valueObj = this.readValue(p.getVarType(), split[1]);
        if (p.getVarType().isTextureType()) {
            this.material.setTextureParam(name, p.getVarType(), (Texture)valueObj);
        } else {
            this.material.setParam(name, p.getVarType(), valueObj);
        }
    }

    private void readMaterialParams(List<Statement> paramsList) throws IOException {
        for (Statement statement : paramsList) {
            this.readParam(statement.getLine());
        }
    }

    private void readExtendingMaterialParams(List<Statement> paramsList) throws IOException {
        for (Statement statement : paramsList) {
            this.readValueParam(statement.getLine());
        }
    }

    private void readWorldParams(List<Statement> worldParams) throws IOException {
        for (Statement statement : worldParams) {
            this.technique.addWorldParam(statement.getLine());
        }
    }

    private boolean parseBoolean(String word) {
        return word != null && word.equals("On");
    }

    private void readRenderStateStatement(Statement statement) throws IOException {
        String[] split = statement.getLine().split(whitespacePattern);
        if (split[0].equals("Wireframe")) {
            this.renderState.setWireframe(this.parseBoolean(split[1]));
        } else if (split[0].equals("FaceCull")) {
            this.renderState.setFaceCullMode(RenderState.FaceCullMode.valueOf(split[1]));
        } else if (split[0].equals("DepthWrite")) {
            this.renderState.setDepthWrite(this.parseBoolean(split[1]));
        } else if (split[0].equals("DepthTest")) {
            this.renderState.setDepthTest(this.parseBoolean(split[1]));
        } else if (split[0].equals("Blend")) {
            this.renderState.setBlendMode(RenderState.BlendMode.valueOf(split[1]));
        } else if (split[0].equals("AlphaTestFalloff")) {
            this.renderState.setAlphaTest(true);
            this.renderState.setAlphaFallOff(Float.parseFloat(split[1]));
        } else if (split[0].equals("PolyOffset")) {
            float factor = Float.parseFloat(split[1]);
            float units = Float.parseFloat(split[2]);
            this.renderState.setPolyOffset(factor, units);
        } else if (split[0].equals("ColorWrite")) {
            this.renderState.setColorWrite(this.parseBoolean(split[1]));
        } else if (split[0].equals("PointSprite")) {
            this.renderState.setPointSprite(this.parseBoolean(split[1]));
        } else if (split[0].equals("DepthFunc")) {
            this.renderState.setDepthFunc(RenderState.TestFunction.valueOf(split[1]));
        } else if (split[0].equals("AlphaFunc")) {
            this.renderState.setAlphaFunc(RenderState.TestFunction.valueOf(split[1]));
        } else {
            throw new MatParseException(null, split[0], statement);
        }
    }

    private void readAdditionalRenderState(List<Statement> renderStates) throws IOException {
        this.renderState = this.material.getAdditionalRenderState();
        for (Statement statement : renderStates) {
            this.readRenderStateStatement(statement);
        }
        this.renderState = null;
    }

    private void readRenderState(List<Statement> renderStates) throws IOException {
        this.renderState = new RenderState();
        for (Statement statement : renderStates) {
            this.readRenderStateStatement(statement);
        }
        this.technique.setRenderState(this.renderState);
        this.renderState = null;
    }

    private void readForcedRenderState(List<Statement> renderStates) throws IOException {
        this.renderState = new RenderState();
        for (Statement statement : renderStates) {
            this.readRenderStateStatement(statement);
        }
        this.technique.setForcedRenderState(this.renderState);
        this.renderState = null;
    }

    private void readDefine(String statement) throws IOException {
        String[] split = statement.split(":");
        if (split.length == 1) {
            this.technique.addShaderPresetDefine(split[0].trim(), VarType.Boolean, true);
        } else if (split.length == 2) {
            this.technique.addShaderParamDefine(split[1].trim(), split[0].trim());
        } else {
            throw new IOException("Define syntax incorrect");
        }
    }

    private void readDefines(List<Statement> defineList) throws IOException {
        for (Statement statement : defineList) {
            this.readDefine(statement.getLine());
        }
    }

    private void readTechniqueStatement(Statement statement) throws IOException {
        String[] split = statement.getLine().split("[ \\{]");
        if (split[0].equals("VertexShader") || split[0].equals("FragmentShader") || split[0].equals("GeometryShader") || split[0].equals("TessellationControlShader") || split[0].equals("TessellationEvaluationShader")) {
            this.readShaderStatement(statement.getLine());
        } else if (split[0].equals("LightMode")) {
            this.readLightMode(statement.getLine());
        } else if (split[0].equals("ShadowMode")) {
            this.readShadowMode(statement.getLine());
        } else if (split[0].equals("WorldParameters")) {
            this.readWorldParams(statement.getContents());
        } else if (split[0].equals("RenderState")) {
            this.readRenderState(statement.getContents());
        } else if (split[0].equals("ForcedRenderState")) {
            this.readForcedRenderState(statement.getContents());
        } else if (split[0].equals("Defines")) {
            this.readDefines(statement.getContents());
        } else if (split[0].equals("ShaderNodesDefinitions")) {
            this.initNodesLoader();
            if (this.isUseNodes) {
                this.nodesLoaderDelegate.readNodesDefinitions(statement.getContents());
            }
        } else if (split[0].equals("VertexShaderNodes")) {
            this.initNodesLoader();
            if (this.isUseNodes) {
                this.nodesLoaderDelegate.readVertexShaderNodes(statement.getContents());
            }
        } else if (split[0].equals("FragmentShaderNodes")) {
            this.initNodesLoader();
            if (this.isUseNodes) {
                this.nodesLoaderDelegate.readFragmentShaderNodes(statement.getContents());
            }
        } else if (split[0].equals("NoRender")) {
            this.technique.setNoRender(true);
        } else {
            throw new MatParseException(null, split[0], statement);
        }
    }

    private void readTransparentStatement(String statement) throws IOException {
        String[] split = statement.split(whitespacePattern);
        if (split.length != 2) {
            throw new IOException("Transparent statement syntax incorrect");
        }
        this.material.setTransparent(this.parseBoolean(split[1]));
    }

    private void readTechnique(Statement techStat) throws IOException {
        this.isUseNodes = false;
        String[] split = techStat.getLine().split(whitespacePattern);
        if (split.length == 1) {
            this.technique = new TechniqueDef(null);
        } else if (split.length == 2) {
            String techName = split[1];
            this.technique = new TechniqueDef(techName);
        } else {
            throw new IOException("Technique statement syntax incorrect");
        }
        for (Statement statement : techStat.getContents()) {
            this.readTechniqueStatement(statement);
        }
        if (this.isUseNodes) {
            this.nodesLoaderDelegate.computeConditions();
            this.technique.setShaderFile(this.technique.hashCode() + "", this.technique.hashCode() + "", "GLSL100", "GLSL100");
        }
        if (this.shaderName.containsKey((Object)Shader.ShaderType.Vertex) && this.shaderName.containsKey((Object)Shader.ShaderType.Fragment)) {
            this.technique.setShaderFile(this.shaderName, this.shaderLanguage);
        }
        this.materialDef.addTechniqueDef(this.technique);
        this.technique = null;
        this.shaderLanguage.clear();
        this.shaderName.clear();
    }

    private void loadFromRoot(List<Statement> roots) throws IOException {
        if (roots.size() == 2) {
            Statement exception = roots.get(0);
            String line = exception.getLine();
            if (line.startsWith("Exception")) {
                throw new AssetLoadException(line.substring("Exception ".length()));
            }
            throw new IOException("In multiroot material, expected first statement to be 'Exception'");
        }
        if (roots.size() != 1) {
            throw new IOException("Too many roots in J3M/J3MD file");
        }
        boolean extending = false;
        Statement materialStat = roots.get(0);
        String materialName = materialStat.getLine();
        if (materialName.startsWith("MaterialDef")) {
            materialName = materialName.substring("MaterialDef ".length()).trim();
            extending = false;
        } else if (materialName.startsWith("Material")) {
            materialName = materialName.substring("Material ".length()).trim();
            extending = true;
        } else {
            throw new IOException("Specified file is not a Material file");
        }
        String[] split = materialName.split(":", 2);
        if (materialName.equals("")) {
            throw new MatParseException("Material name cannot be empty", materialStat);
        }
        if (split.length == 2) {
            if (!extending) {
                throw new MatParseException("Must use 'Material' when extending.", materialStat);
            }
            String extendedMat = split[1].trim();
            MaterialDef def = (MaterialDef)this.assetManager.loadAsset(new AssetKey(extendedMat));
            if (def == null) {
                throw new MatParseException("Extended material " + extendedMat + " cannot be found.", materialStat);
            }
            this.material = new Material(def);
            this.material.setKey(this.key);
        } else if (split.length == 1) {
            if (extending) {
                throw new MatParseException("Expected ':', got '{'", materialStat);
            }
            this.materialDef = new MaterialDef(this.assetManager, materialName);
            this.materialDef.setAssetName(this.key.getName());
        } else {
            throw new MatParseException("Cannot use colon in material name/path", materialStat);
        }
        for (Statement statement : materialStat.getContents()) {
            split = statement.getLine().split("[ \\{]");
            String statType = split[0];
            if (extending) {
                if (statType.equals("MaterialParameters")) {
                    this.readExtendingMaterialParams(statement.getContents());
                    continue;
                }
                if (statType.equals("AdditionalRenderState")) {
                    this.readAdditionalRenderState(statement.getContents());
                    continue;
                }
                if (!statType.equals("Transparent")) continue;
                this.readTransparentStatement(statement.getLine());
                continue;
            }
            if (statType.equals("Technique")) {
                this.readTechnique(statement);
                continue;
            }
            if (statType.equals("MaterialParameters")) {
                this.readMaterialParams(statement.getContents());
                continue;
            }
            throw new MatParseException("Expected material statement, got '" + statType + "'", statement);
        }
    }

    @Override
    public Object load(AssetInfo info) throws IOException {
        this.assetManager = info.getManager();
        InputStream in = info.openStream();
        try {
            this.key = info.getKey();
            if (this.key.getExtension().equals("j3m") && !(this.key instanceof MaterialKey)) {
                throw new IOException("Material instances must be loaded via MaterialKey");
            }
            if (this.key.getExtension().equals("j3md") && this.key instanceof MaterialKey) {
                throw new IOException("Material definitions must be loaded via AssetKey");
            }
            this.loadFromRoot(BlockLanguageParser.parse(in));
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        if (this.material != null) {
            return this.material;
        }
        return this.materialDef;
    }

    public MaterialDef loadMaterialDef(List<Statement> roots, AssetManager manager, AssetKey key) throws IOException {
        this.key = key;
        this.assetManager = manager;
        this.loadFromRoot(roots);
        return this.materialDef;
    }

    protected void initNodesLoader() {
        if (!this.isUseNodes) {
            boolean bl = this.isUseNodes = this.shaderName.get((Object)Shader.ShaderType.Vertex) == null && this.shaderName.get((Object)Shader.ShaderType.Fragment) == null;
            if (this.isUseNodes) {
                if (this.nodesLoaderDelegate == null) {
                    this.nodesLoaderDelegate = new ShaderNodeLoaderDelegate();
                } else {
                    this.nodesLoaderDelegate.clear();
                }
                this.nodesLoaderDelegate.setTechniqueDef(this.technique);
                this.nodesLoaderDelegate.setMaterialDef(this.materialDef);
                this.nodesLoaderDelegate.setAssetManager(this.assetManager);
            }
        }
    }
}

