/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.renderer.opengl;

import com.jme3.renderer.opengl.GL;
import com.jme3.renderer.opengl.GL2;
import com.jme3.renderer.opengl.GL3;
import com.jme3.renderer.opengl.GL4;
import com.jme3.renderer.opengl.GLExt;
import com.jme3.renderer.opengl.GLFbo;
import com.jme3.util.IntMap;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;

public final class GLTracer
implements InvocationHandler {
    private final Object obj;
    private final IntMap<String> constMap;
    private static final HashMap<String, IntMap<Void>> nonEnumArgMap = new HashMap();

    private static void noEnumArgs(String method, int ... argSlots) {
        IntMap<Void> argSlotsMap = new IntMap<Void>();
        for (int argSlot : argSlots) {
            argSlotsMap.put(argSlot, null);
        }
        nonEnumArgMap.put(method, argSlotsMap);
    }

    public GLTracer(Object obj, IntMap<String> constMap) {
        this.obj = obj;
        this.constMap = constMap;
    }

    private static IntMap<String> generateConstantMap(Class<?> ... classes) {
        IntMap<String> constMap = new IntMap<String>();
        for (Class<?> clazz : classes) {
            for (Field field : clazz.getFields()) {
                if (field.getType() != Integer.TYPE) continue;
                try {
                    int val = field.getInt(null);
                    String name = field.getName();
                    constMap.put(val, name);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        constMap.put(1, "GL_ONE");
        return constMap;
    }

    public static Object createGlesTracer(Object glInterface, Class<?> glInterfaceClass) {
        IntMap<String> constMap = GLTracer.generateConstantMap(GL.class, GLFbo.class, GLExt.class);
        return Proxy.newProxyInstance(glInterface.getClass().getClassLoader(), new Class[]{glInterfaceClass}, (InvocationHandler)new GLTracer(glInterface, constMap));
    }

    public static Object createDesktopGlTracer(Object glInterface, Class<?> ... glInterfaceClasses) {
        IntMap<String> constMap = GLTracer.generateConstantMap(GL2.class, GL3.class, GL4.class, GLFbo.class, GLExt.class);
        return Proxy.newProxyInstance(glInterface.getClass().getClassLoader(), glInterfaceClasses, (InvocationHandler)new GLTracer(glInterface, constMap));
    }

    private String translateInteger(String method, int value, int argIndex) {
        IntMap<Void> argSlotMap = nonEnumArgMap.get(method);
        if (argSlotMap != null && argSlotMap.containsKey(argIndex)) {
            return Integer.toString(value);
        }
        String enumName = this.constMap.get(value);
        if (enumName != null) {
            return enumName;
        }
        return "GL_ENUM_" + Integer.toHexString(value);
    }

    private String translateString(String value) {
        return "\"" + value.replaceAll("\u0000", "\\\\0") + "\"";
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = method.invoke(this.obj, args);
        String methodName = method.getName();
        if (methodName.startsWith("gl")) {
            System.out.print(methodName);
            System.out.print("(");
            if (args != null) {
                Class<?>[] paramTypes = method.getParameterTypes();
                for (int i = 0; i < args.length; ++i) {
                    if (paramTypes[i] == Integer.TYPE) {
                        int val = (Integer)args[i];
                        System.out.print(this.translateInteger(methodName, val, i));
                    } else if (paramTypes[i] == String.class) {
                        System.out.print(this.translateString((String)args[i]));
                    } else if (paramTypes[i] == String[].class) {
                        String[] arr = (String[])args[i];
                        if (arr.length == 1) {
                            if (arr[0].length() > 150) {
                                System.out.print("\"" + arr[0].substring(0, 150) + "...\"");
                            } else {
                                System.out.print("\"" + arr[0] + "\"");
                            }
                        } else {
                            System.out.print("String[" + arr.length + "]");
                        }
                    } else if (args[i] instanceof IntBuffer) {
                        IntBuffer buf = (IntBuffer)args[i];
                        if (buf.capacity() == 16) {
                            int val = buf.get(0);
                            System.out.print("out=" + this.translateInteger(methodName, val, i));
                        } else if (buf.capacity() == 1) {
                            System.out.print("out=" + buf.get(0));
                        } else {
                            System.out.print(args[i]);
                        }
                    } else if (args[i] instanceof ByteBuffer) {
                        ByteBuffer bb = (ByteBuffer)args[i];
                        if (bb.capacity() == 250) {
                            if (bb.get(0) != 0) {
                                System.out.print("out=GL_TRUE");
                            } else {
                                System.out.print("out=GL_FALSE");
                            }
                        } else {
                            System.out.print(args[i]);
                        }
                    } else {
                        System.out.print(args[i]);
                    }
                    if (i == args.length - 1) continue;
                    System.out.print(", ");
                }
            }
            System.out.print(")");
            if (method.getReturnType() != Void.TYPE) {
                if (result instanceof String) {
                    System.out.println(" = " + this.translateString((String)result));
                } else if (method.getReturnType() == Integer.TYPE) {
                    int val = (Integer)result;
                    System.out.println(" = " + this.translateInteger(methodName, val, -1));
                } else if (method.getReturnType() == Boolean.TYPE) {
                    boolean val = (Boolean)result;
                    if (val) {
                        System.out.println(" = GL_TRUE");
                    } else {
                        System.out.println(" = GL_FALSE");
                    }
                } else {
                    System.out.println(" = ???");
                }
            } else {
                System.out.println();
            }
        }
        return result;
    }

    static {
        GLTracer.noEnumArgs("glViewport", 0, 1, 2, 3);
        GLTracer.noEnumArgs("glScissor", 0, 1, 2, 3);
        GLTracer.noEnumArgs("glClear", 0);
        GLTracer.noEnumArgs("glGetInteger", 1);
        GLTracer.noEnumArgs("glGetString", 1);
        GLTracer.noEnumArgs("glBindTexture", 1);
        GLTracer.noEnumArgs("glPixelStorei", 1);
        GLTracer.noEnumArgs("glTexImage2D", 1, 3, 4, 5);
        GLTracer.noEnumArgs("glTexImage3D", 1, 3, 4, 5, 6);
        GLTracer.noEnumArgs("glTexSubImage2D", 1, 2, 3, 4, 5);
        GLTracer.noEnumArgs("glTexSubImage3D", 1, 2, 3, 4, 5, 6, 7);
        GLTracer.noEnumArgs("glCompressedTexImage2D", 1, 3, 4, 5);
        GLTracer.noEnumArgs("glCompressedTexSubImage3D", 1, 2, 3, 4, 5, 6, 7);
        GLTracer.noEnumArgs("glDeleteTextures", 0);
        GLTracer.noEnumArgs("glReadPixels", 0, 1, 2, 3);
        GLTracer.noEnumArgs("glBindBuffer", 1);
        GLTracer.noEnumArgs("glEnableVertexAttribArray", 0);
        GLTracer.noEnumArgs("glDisableVertexAttribArray", 0);
        GLTracer.noEnumArgs("glVertexAttribPointer", 0, 1, 4, 5);
        GLTracer.noEnumArgs("glDrawRangeElements", 1, 2, 3, 5);
        GLTracer.noEnumArgs("glDrawArrays", 1, 2);
        GLTracer.noEnumArgs("glDeleteBuffers", 0);
        GLTracer.noEnumArgs("glBindVertexArray", 0);
        GLTracer.noEnumArgs("glGenVertexArrays", 0);
        GLTracer.noEnumArgs("glBindFramebufferEXT", 1);
        GLTracer.noEnumArgs("glBindRenderbufferEXT", 1);
        GLTracer.noEnumArgs("glRenderbufferStorageEXT", 2, 3);
        GLTracer.noEnumArgs("glRenderbufferStorageMultisampleEXT", 1, 3, 4);
        GLTracer.noEnumArgs("glFramebufferRenderbufferEXT", 3);
        GLTracer.noEnumArgs("glFramebufferTexture2DEXT", 3, 4);
        GLTracer.noEnumArgs("glBlitFramebufferEXT", 0, 1, 2, 3, 4, 5, 6, 7, 8);
        GLTracer.noEnumArgs("glCreateProgram", -1);
        GLTracer.noEnumArgs("glCreateShader", -1);
        GLTracer.noEnumArgs("glShaderSource", 0);
        GLTracer.noEnumArgs("glCompileShader", 0);
        GLTracer.noEnumArgs("glGetShader", 0);
        GLTracer.noEnumArgs("glAttachShader", 0, 1);
        GLTracer.noEnumArgs("glLinkProgram", 0);
        GLTracer.noEnumArgs("glGetProgram", 0);
        GLTracer.noEnumArgs("glUseProgram", 0);
        GLTracer.noEnumArgs("glGetUniformLocation", 0, -1);
        GLTracer.noEnumArgs("glUniformMatrix3", 0);
        GLTracer.noEnumArgs("glUniformMatrix4", 0);
        GLTracer.noEnumArgs("glUniform1i", 0, 1);
        GLTracer.noEnumArgs("glUniform1f", 0);
        GLTracer.noEnumArgs("glUniform2f", 0);
        GLTracer.noEnumArgs("glUniform3f", 0);
        GLTracer.noEnumArgs("glUniform4", 0);
        GLTracer.noEnumArgs("glUniform4f", 0);
        GLTracer.noEnumArgs("glGetAttribLocation", 0, -1);
        GLTracer.noEnumArgs("glDetachShader", 0, 1);
        GLTracer.noEnumArgs("glDeleteShader", 0);
        GLTracer.noEnumArgs("glDeleteProgram", 0);
        GLTracer.noEnumArgs("glBindFragDataLocation", 0, 1);
    }
}

