/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.control;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.AbstractControl;
import com.jme3.scene.control.Control;
import com.jme3.util.TempVars;
import java.io.IOException;

public class CameraControl
extends AbstractControl {
    private Camera camera;
    private ControlDirection controlDir = ControlDirection.SpatialToCamera;
    private static final String CONTROL_DIR_NAME = "controlDir";
    private static final String CAMERA_NAME = "camera";

    public CameraControl() {
    }

    public CameraControl(Camera camera) {
        this.camera = camera;
    }

    public CameraControl(Camera camera, ControlDirection controlDir) {
        this.camera = camera;
        this.controlDir = controlDir;
    }

    public Camera getCamera() {
        return this.camera;
    }

    public void setCamera(Camera camera) {
        this.camera = camera;
    }

    public ControlDirection getControlDir() {
        return this.controlDir;
    }

    public void setControlDir(ControlDirection controlDir) {
        this.controlDir = controlDir;
    }

    @Override
    protected void controlUpdate(float tpf) {
        if (this.spatial != null && this.camera != null) {
            switch (this.controlDir) {
                case SpatialToCamera: {
                    this.camera.setLocation(this.spatial.getWorldTranslation());
                    this.camera.setRotation(this.spatial.getWorldRotation());
                    break;
                }
                case CameraToSpatial: {
                    TempVars vars = TempVars.get();
                    Vector3f vecDiff = vars.vect1.set(this.camera.getLocation()).subtractLocal(this.spatial.getWorldTranslation());
                    this.spatial.setLocalTranslation(vecDiff.addLocal(this.spatial.getLocalTranslation()));
                    Quaternion worldDiff = vars.quat1.set(this.camera.getRotation()).subtractLocal(this.spatial.getWorldRotation());
                    this.spatial.setLocalRotation(worldDiff.addLocal(this.spatial.getLocalRotation()));
                    vars.release();
                }
            }
        }
    }

    @Override
    protected void controlRender(RenderManager rm, ViewPort vp) {
    }

    @Override
    public Control cloneForSpatial(Spatial newSpatial) {
        CameraControl control = new CameraControl(this.camera, this.controlDir);
        control.setSpatial(newSpatial);
        control.setEnabled(this.isEnabled());
        return control;
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.controlDir = ic.readEnum(CONTROL_DIR_NAME, ControlDirection.class, ControlDirection.SpatialToCamera);
        this.camera = (Camera)ic.readSavable(CAMERA_NAME, null);
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.controlDir, CONTROL_DIR_NAME, ControlDirection.SpatialToCamera);
        oc.write(this.camera, CAMERA_NAME, null);
    }

    public static enum ControlDirection {
        CameraToSpatial,
        SpatialToCamera;

    }
}

