/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.debug;

import com.jme3.bounding.BoundingSphere;
import com.jme3.math.FastMath;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

public class WireSphere
extends Mesh {
    private static final int samples = 30;
    private static final int zSamples = 10;

    public WireSphere() {
        this(1.0f);
    }

    public WireSphere(float radius) {
        this.updatePositions(radius);
        ShortBuffer ib = BufferUtils.createShortBuffer(720);
        this.setBuffer(VertexBuffer.Type.Index, 2, ib);
        int curNum = 0;
        for (int j = 0; j < 12; ++j) {
            for (int i = curNum; i < curNum + 30 - 1; ++i) {
                ib.put((short)i).put((short)(i + 1));
            }
            ib.put((short)(curNum + 30 - 1)).put((short)curNum);
            curNum += 30;
        }
        this.setMode(Mesh.Mode.Lines);
        this.updateBound();
        this.updateCounts();
    }

    public void updatePositions(float radius) {
        float y;
        float x;
        int i;
        FloatBuffer pb;
        VertexBuffer pvb = this.getBuffer(VertexBuffer.Type.Position);
        if (pvb == null) {
            pvb = new VertexBuffer(VertexBuffer.Type.Position);
            pb = BufferUtils.createVector3Buffer(360);
            pvb.setupData(VertexBuffer.Usage.Dynamic, 3, VertexBuffer.Format.Float, pb);
            this.setBuffer(pvb);
        } else {
            pb = (FloatBuffer)pvb.getData();
        }
        pb.rewind();
        float rate = 0.20943952f;
        float angle = 0.0f;
        for (i = 0; i < 30; ++i) {
            x = radius * FastMath.cos(angle);
            y = radius * FastMath.sin(angle);
            pb.put(x).put(y).put(0.0f);
            angle += rate;
        }
        angle = 0.0f;
        for (i = 0; i < 30; ++i) {
            x = radius * FastMath.cos(angle);
            y = radius * FastMath.sin(angle);
            pb.put(0.0f).put(x).put(y);
            angle += rate;
        }
        float zRate = radius * 2.0f / 10.0f;
        float zHeight = -radius + zRate / 2.0f;
        float rb = 0.1f;
        float b = rb / 2.0f;
        for (int k = 0; k < 10; ++k) {
            angle = 0.0f;
            float scale = FastMath.sin(b * (float)Math.PI);
            for (int i2 = 0; i2 < 30; ++i2) {
                float x2 = radius * FastMath.cos(angle);
                float y2 = radius * FastMath.sin(angle);
                pb.put(x2 * scale).put(zHeight).put(y2 * scale);
                angle += rate;
            }
            zHeight += zRate;
            b += rb;
        }
    }

    public void fromBoundingSphere(BoundingSphere bsph) {
        this.updatePositions(bsph.getRadius());
    }
}

