/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.json;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.progeeks.json.JsonParseException;
import org.progeeks.json.JsonPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonParser {
    private static final boolean debug = false;

    public Object parse(Reader in) throws IOException {
        return this.parseValue(new CharStream(in));
    }

    public Object parse(String json) {
        try {
            return this.parse(new StringReader(json));
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IO exception reading from string.");
        }
    }

    protected boolean isWhitespace(int c) {
        return c <= 32;
    }

    protected boolean isValueBreak(int c) {
        return c < 32 || ",:]}/\\\"[{;=#".indexOf((char)c) >= 0;
    }

    protected int nextNonWhitespace(CharStream in) throws IOException {
        int c;
        while ((c = in.read()) >= 0) {
            if (this.isWhitespace(c)) continue;
            return c;
        }
        return -1;
    }

    protected Object parseValue(CharStream in) throws IOException {
        String value;
        int c = this.nextNonWhitespace(in);
        switch (c) {
            case 34: 
            case 39: {
                return this.parseString(in, c);
            }
            case 123: {
                return this.parseObject(in);
            }
            case 91: {
                return this.parseArray(in, 93);
            }
            case 40: {
                return this.parseArray(in, 41);
            }
        }
        in.pushBack(c);
        StringBuilder sb = new StringBuilder();
        while ((c = in.read()) >= 0) {
            if (this.isValueBreak(c)) {
                in.pushBack(c);
                break;
            }
            sb.append((char)c);
        }
        if ((value = sb.toString().trim()).length() == 0) {
            throw this.createParseException("Missing value", in);
        }
        return this.toValue(value);
    }

    protected char unescape(int c, CharStream in) {
        switch (c) {
            case 98: {
                return '\b';
            }
            case 116: {
                return '\t';
            }
            case 110: {
                return '\n';
            }
            case 102: {
                return '\f';
            }
            case 114: {
                return '\r';
            }
            case 34: 
            case 39: 
            case 47: 
            case 92: {
                return (char)c;
            }
        }
        throw this.createParseException("Invalid escape character:" + (char)c, in);
    }

    protected String parseString(CharStream in, int end) throws IOException {
        int c;
        StringBuilder sb = new StringBuilder();
        block4: while ((c = in.read()) >= 0 && c != end) {
            switch (c) {
                case 92: {
                    sb.append(this.unescape(in.read(), in));
                    continue block4;
                }
                case 0: 
                case 10: 
                case 13: {
                    throw this.createParseException("Unterminated string", in);
                }
            }
            sb.append((char)c);
        }
        return sb.toString();
    }

    protected Map<String, Object> parseObject(CharStream in) throws IOException {
        int c;
        HashMap<String, Object> result = new HashMap<String, Object>();
        while ((c = this.nextNonWhitespace(in)) != 125) {
            in.pushBack(c);
            Object o = this.parseValue(in);
            if (!(o instanceof String)) {
                throw this.createParseException("Encountered non-string value for key:" + o, in);
            }
            String key = (String)o;
            this.parseKeySeparator(in);
            o = this.parseValue(in);
            result.put(key, o);
            c = this.nextNonWhitespace(in);
            if (c == 125) break;
            if (c == 44 || c == 59) continue;
            throw this.createParseException("Missing ',' or '}' at:" + (char)c, in);
        }
        return result;
    }

    protected void parseKeySeparator(CharStream in) throws IOException {
        int c = this.nextNonWhitespace(in);
        if (c == 58) {
            return;
        }
        if (c == 61) {
            c = in.read();
            if (c != 62) {
                in.pushBack(c);
            }
            return;
        }
        throw this.createParseException("Encountered invalid key/value separator:" + (char)c, in);
    }

    protected List<Object> parseArray(CharStream in, int end) throws IOException {
        int c;
        ArrayList<Object> result = new ArrayList<Object>();
        while ((c = this.nextNonWhitespace(in)) != end) {
            if (c == 93 || c == 41) {
                throw this.createParseException("Mismatched terminator '" + (char)c + "', expected:'" + (char)c + "'", in);
            }
            in.pushBack(c);
            Object o = this.parseValue(in);
            result.add(o);
            c = this.nextNonWhitespace(in);
            if (c == end) break;
            if (c == 44 || c == 59) continue;
            throw this.createParseException("Missing ',' or '" + (char)end + "' at:" + (char)c, in);
        }
        return result;
    }

    protected Number reduce(BigDecimal bd) {
        if (bd.scale() > 0) {
            double d = bd.doubleValue();
            if (d == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY) {
                return bd;
            }
            return d;
        }
        try {
            long l = bd.longValueExact();
            if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
                return (int)l;
            }
            return l;
        }
        catch (ArithmeticException e) {
            return bd;
        }
    }

    protected Object toValue(String s) {
        if ("true".equalsIgnoreCase(s)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(s)) {
            return Boolean.FALSE;
        }
        if ("null".equalsIgnoreCase(s)) {
            return null;
        }
        boolean negative = false;
        String sub = s;
        if (s.charAt(0) == '-') {
            negative = true;
            sub = s.substring(1);
        } else if (s.charAt(0) == '+') {
            sub = s.substring(1);
        }
        if (sub.length() > 2 && (sub.startsWith("0x") || sub.startsWith("0X"))) {
            sub = sub.substring(2);
            return Integer.parseInt(sub, 16) * (negative ? -1 : 1);
        }
        if (sub.length() > 1 && sub.startsWith("0") && sub.charAt(1) != '.') {
            sub = sub.substring(1);
            return Integer.parseInt(sub, 8) * (negative ? -1 : 1);
        }
        try {
            BigDecimal bd = new BigDecimal(s);
            return this.reduce(bd);
        }
        catch (NumberFormatException e) {
            return s;
        }
    }

    protected JsonParseException createParseException(String message, CharStream in) {
        return new JsonParseException(message, in.line, in.column);
    }

    public static void main(String[] args) throws Exception {
        JsonParser parser = new JsonParser();
        Object o = parser.parse(new InputStreamReader(System.in));
        System.out.println("Result:" + o);
        System.out.println("Formatted:");
        JsonPrinter p = new JsonPrinter();
        p.write(o, new PrintWriter(System.out));
    }

    protected class CharStream {
        private PushbackReader in;
        private int column = 1;
        private int line = 1;

        public CharStream(Reader in) {
            this.in = in instanceof PushbackReader ? (PushbackReader)in : new PushbackReader(in);
        }

        public void pushBack(int c) throws IOException {
            this.in.unread(c);
            --this.column;
        }

        public int read() throws IOException {
            int c = this.in.read();
            if (c <= 0) {
                return c;
            }
            if (c == 10) {
                ++this.line;
                this.column = 1;
            } else {
                ++this.column;
            }
            return c;
        }
    }
}

