/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.util;

import com.simsilica.util.Reporter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class ReportSystem {
    public static final String REPORT_CACHE = "cache";
    private static Map<String, List<Reporter>> reporters = new ConcurrentHashMap<String, List<Reporter>>();

    private static List<Reporter> getList(String reportType) {
        List<Reporter> list = reporters.get(reportType);
        if (list == null) {
            list = new CopyOnWriteArrayList<Reporter>();
            reporters.put(reportType, list);
        }
        return list;
    }

    public static void registerCacheReporter(Reporter r) {
        ReportSystem.registerReporter(REPORT_CACHE, r);
    }

    public static void registerReporter(String type, Reporter r) {
        ReportSystem.getList(type).add(r);
    }

    public static void printReport(String type, PrintWriter out) {
        for (Reporter r : ReportSystem.getList(type)) {
            r.printReport(type, out);
        }
    }

    public static String getReport(String type) {
        StringWriter sOut = new StringWriter();
        PrintWriter out = new PrintWriter(sOut);
        ReportSystem.printReport(type, out);
        out.close();
        return sOut.toString();
    }
}

