/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.component;

import com.jme3.font.BitmapFont;
import com.jme3.font.BitmapText;
import com.jme3.font.LineWrapMode;
import com.jme3.font.Rectangle;
import com.jme3.input.event.KeyInputEvent;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Quad;
import com.simsilica.lemur.DocumentModel;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.HAlignment;
import com.simsilica.lemur.VAlignment;
import com.simsilica.lemur.component.AbstractGuiComponent;
import com.simsilica.lemur.core.GuiControl;
import com.simsilica.lemur.core.GuiMaterial;
import com.simsilica.lemur.event.KeyAction;
import com.simsilica.lemur.event.KeyActionListener;
import com.simsilica.lemur.event.KeyListener;
import com.simsilica.lemur.focus.FocusTarget;
import java.util.HashMap;
import java.util.Map;

public class TextEntryComponent
extends AbstractGuiComponent
implements FocusTarget {
    public static final KeyActionListener DOC_HOME = new DocumentHome();
    public static final KeyActionListener DOC_END = new DocumentEnd();
    public static final KeyActionListener LINE_HOME = new LineHome();
    public static final KeyActionListener LINE_END = new LineEnd();
    public static final KeyActionListener PREV_LINE = new PreviousLine();
    public static final KeyActionListener NEXT_LINE = new NextLine();
    public static final KeyActionListener LEFT = new CaratLeft();
    public static final KeyActionListener RIGHT = new CaratRight();
    public static final KeyActionListener NO_OP = new NullAction();
    public static final KeyActionListener BACKSPACE = new Backspace();
    public static final KeyActionListener NEW_LINE = new NewLine();
    public static final KeyActionListener DELETE = new Delete();
    private static final Map<KeyAction, KeyActionListener> standardActions = new HashMap<KeyAction, KeyActionListener>();
    private BitmapFont font;
    private BitmapText bitmapText;
    private Rectangle textBox;
    private HAlignment hAlign = HAlignment.Left;
    private VAlignment vAlign = VAlignment.Top;
    private Vector3f preferredSize;
    private float preferredWidth;
    private KeyHandler keyHandler = new KeyHandler();
    private Quad cursorQuad;
    private Geometry cursor;
    private DocumentModel model;
    private boolean singleLine;
    private boolean focused;
    private boolean cursorVisible = true;
    private int textOffset = 0;
    private Map<KeyAction, KeyActionListener> actionMap = new HashMap<KeyAction, KeyActionListener>(standardActions);

    public TextEntryComponent(BitmapFont font) {
        this(new DocumentModel(), font);
    }

    public TextEntryComponent(DocumentModel model, BitmapFont font) {
        this.font = font;
        this.bitmapText = new BitmapText(font);
        this.bitmapText.setLineWrapMode(LineWrapMode.Clip);
        this.model = model;
        this.cursorQuad = new Quad(this.bitmapText.getLineHeight() / 16.0f, this.bitmapText.getLineHeight());
        this.cursor = new Geometry("cursor", (Mesh)this.cursorQuad);
        GuiMaterial mat = GuiGlobals.getInstance().createMaterial(new ColorRGBA(1.0f, 1.0f, 1.0f, 0.75f), false);
        this.cursor.setMaterial(mat.getMaterial());
        this.cursor.getMaterial().getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        this.cursor.setUserData("layer", (Object)1);
        this.bitmapText.attachChild((Spatial)this.cursor);
        if (model.getText() != null) {
            this.resetText();
        }
    }

    @Override
    public TextEntryComponent clone() {
        TextEntryComponent result = (TextEntryComponent)super.clone();
        result.bitmapText = new BitmapText(this.font);
        this.bitmapText.setLineWrapMode(LineWrapMode.Clip);
        result.model = new DocumentModel(this.model.getText());
        result.preferredSize = null;
        result.textBox = null;
        TextEntryComponent textEntryComponent = result;
        textEntryComponent.getClass();
        result.keyHandler = textEntryComponent.new KeyHandler();
        result.cursorQuad = new Quad(this.bitmapText.getLineHeight() / 16.0f, this.bitmapText.getLineHeight());
        result.cursor = new Geometry("cursor", (Mesh)this.cursorQuad);
        GuiMaterial mat = GuiGlobals.getInstance().createMaterial(new ColorRGBA(1.0f, 1.0f, 1.0f, 0.75f), false);
        result.cursor.setMaterial(mat.getMaterial());
        result.cursor.getMaterial().getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        result.bitmapText.attachChild((Spatial)this.cursor);
        result.resetText();
        return result;
    }

    @Override
    public void attach(GuiControl parent) {
        super.attach(parent);
        this.getNode().attachChild((Spatial)this.bitmapText);
        this.resetCursorPosition();
        this.resetCursorState();
        if (this.focused) {
            GuiGlobals.getInstance().addKeyListener(this.keyHandler);
        }
    }

    @Override
    public void detach(GuiControl parent) {
        GuiGlobals.getInstance().removeKeyListener(this.keyHandler);
        this.getNode().detachChild((Spatial)this.bitmapText);
        super.detach(parent);
    }

    @Override
    public boolean isFocused() {
        return this.focused;
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    public void focusGained() {
        if (this.focused) {
            return;
        }
        this.focused = true;
        GuiGlobals.getInstance().addKeyListener(this.keyHandler);
        this.resetCursorState();
    }

    @Override
    public void focusLost() {
        if (!this.focused) {
            return;
        }
        this.focused = false;
        GuiGlobals.getInstance().removeKeyListener(this.keyHandler);
        this.resetCursorState();
    }

    public Map<KeyAction, KeyActionListener> getActionMap() {
        return this.actionMap;
    }

    public DocumentModel getDocumentModel() {
        return this.model;
    }

    public void setSingleLine(boolean f) {
        this.singleLine = f;
        if (this.singleLine) {
            this.actionMap.remove(new KeyAction(28, new int[0]));
            this.actionMap.remove(new KeyAction(156, new int[0]));
        } else {
            this.actionMap.put(new KeyAction(28, new int[0]), NEW_LINE);
            this.actionMap.put(new KeyAction(156, new int[0]), NEW_LINE);
        }
    }

    public boolean isSingleLine() {
        return this.singleLine;
    }

    public void setFont(BitmapFont font) {
        if (font == this.bitmapText.getFont()) {
            return;
        }
        if (this.isAttached()) {
            this.bitmapText.removeFromParent();
        }
        BitmapText newText = new BitmapText(font);
        newText.setLineWrapMode(LineWrapMode.Clip);
        newText.setText(this.getText());
        newText.setColor(this.getColor());
        newText.setLocalTranslation(this.bitmapText.getLocalTranslation());
        newText.setSize(this.getFontSize());
        this.bitmapText = newText;
        this.bitmapText.attachChild((Spatial)this.cursor);
        this.resizeCursor();
        this.resetCursorPosition();
        this.resetText();
        if (this.isAttached()) {
            this.getNode().attachChild((Spatial)this.bitmapText);
        }
    }

    public BitmapFont getFont() {
        return this.bitmapText.getFont();
    }

    public void setFontSize(float f) {
        this.bitmapText.setSize(f);
        this.resizeCursor();
        this.resetCursorPosition();
        this.resetText();
    }

    public float getFontSize() {
        return this.bitmapText.getSize();
    }

    protected void resetText() {
        String text = this.model.getText();
        if (this.textOffset != 0) {
            float x;
            text = text.substring(this.textOffset);
            if (this.textBox != null && (x = this.getVisibleWidth(text)) < this.textBox.width) {
                while (this.textOffset > 0) {
                    --this.textOffset;
                    text = this.model.getText().substring(this.textOffset);
                    x = this.getVisibleWidth(text);
                    if (!(x > this.textBox.width)) continue;
                    ++this.textOffset;
                    text = this.model.getText().substring(this.textOffset);
                    break;
                }
            }
        }
        if (text != null && text.equals(this.bitmapText.getText())) {
            return;
        }
        this.bitmapText.setText(text);
        this.resetCursorPosition();
        this.invalidate();
    }

    protected float getVisibleWidth(String text) {
        float x = this.font.getLineWidth((CharSequence)(text + " "));
        x -= this.font.getLineWidth((CharSequence)" ");
        float scale = this.bitmapText.getSize() / this.font.getPreferredSize();
        return x *= scale;
    }

    protected void resizeCursor() {
        this.cursorQuad.updateGeometry(this.bitmapText.getLineHeight() / 16.0f, this.bitmapText.getLineHeight());
    }

    protected void resetCursorState() {
        if (this.isAttached() && this.focused && this.cursorVisible) {
            this.cursor.setCullHint(Spatial.CullHint.Inherit);
        } else {
            this.cursor.setCullHint(Spatial.CullHint.Always);
        }
    }

    protected void resetCursorPosition() {
        int line = this.model.getCaratLine();
        int column = this.model.getCaratColumn();
        if (column < this.textOffset) {
            this.textOffset = column;
            this.resetText();
        }
        String row = this.model.getLine(line);
        row = row.substring(this.textOffset, column);
        float x = this.font.getLineWidth((CharSequence)(row + " "));
        x -= this.font.getLineWidth((CharSequence)" ");
        float scale = this.bitmapText.getSize() / this.font.getPreferredSize();
        x *= scale;
        float y = (float)(-line) * this.bitmapText.getLineHeight();
        y -= this.bitmapText.getLineHeight();
        if (this.textBox != null && x > this.textBox.width) {
            if (this.singleLine) {
                ++this.textOffset;
                this.resetText();
                this.resetCursorPosition();
                return;
            }
            this.cursorVisible = false;
            this.resetCursorState();
        } else {
            this.cursorVisible = true;
            this.resetCursorState();
        }
        this.cursor.setLocalTranslation(x, y, 0.01f);
    }

    public void setText(String text) {
        if (text != null && text.equals(this.model.getText())) {
            return;
        }
        this.model.setText(text);
        this.resetText();
    }

    public String getText() {
        return this.model.getText();
    }

    public void setHAlignment(HAlignment a) {
        if (this.hAlign == a) {
            return;
        }
        this.hAlign = a;
        this.resetAlignment();
    }

    public HAlignment getHAlignment() {
        return this.hAlign;
    }

    public void setVAlignment(VAlignment a) {
        if (this.vAlign == a) {
            return;
        }
        this.vAlign = a;
        this.resetAlignment();
    }

    public VAlignment getVAlignment() {
        return this.vAlign;
    }

    public void setColor(ColorRGBA color) {
        this.bitmapText.setColor(color);
        this.cursor.getMaterial().setColor("Color", color);
    }

    public ColorRGBA getColor() {
        return this.bitmapText.getColor();
    }

    public void setPreferredSize(Vector3f v) {
        this.preferredSize = v;
        this.invalidate();
    }

    public Vector3f getPreferredSize() {
        return this.preferredSize;
    }

    public void setPreferredWidth(float f) {
        this.preferredWidth = f;
        this.invalidate();
    }

    public float getPreferredWidth() {
        return this.preferredWidth;
    }

    @Override
    public void reshape(Vector3f pos, Vector3f size) {
        this.bitmapText.setLocalTranslation(pos.x, pos.y, pos.z);
        this.textBox = new Rectangle(0.0f, 0.0f, size.x, size.y);
        this.bitmapText.setBox(this.textBox);
        this.resetAlignment();
    }

    @Override
    public void calculatePreferredSize(Vector3f size) {
        if (this.preferredSize != null) {
            size.set(this.preferredSize);
            return;
        }
        this.bitmapText.setBox(null);
        size.x = this.preferredWidth == 0.0f ? this.bitmapText.getLineWidth() : this.preferredWidth;
        size.y = this.bitmapText.getHeight();
        this.bitmapText.setBox(this.textBox);
    }

    protected void resetAlignment() {
        if (this.textBox == null) {
            return;
        }
        switch (this.hAlign) {
            case Left: {
                this.bitmapText.setAlignment(BitmapFont.Align.Left);
                break;
            }
            case Right: {
                this.bitmapText.setAlignment(BitmapFont.Align.Right);
                break;
            }
            case Center: {
                this.bitmapText.setAlignment(BitmapFont.Align.Center);
            }
        }
        switch (this.vAlign) {
            case Top: {
                this.bitmapText.setVerticalAlignment(BitmapFont.VAlign.Top);
                break;
            }
            case Bottom: {
                this.bitmapText.setVerticalAlignment(BitmapFont.VAlign.Bottom);
                break;
            }
            case Center: {
                this.bitmapText.setVerticalAlignment(BitmapFont.VAlign.Center);
            }
        }
    }

    static {
        standardActions.put(new KeyAction(199, new int[0]), LINE_HOME);
        standardActions.put(new KeyAction(207, new int[0]), LINE_END);
        standardActions.put(new KeyAction(199, 1), DOC_HOME);
        standardActions.put(new KeyAction(207, 1), DOC_END);
        standardActions.put(new KeyAction(200, new int[0]), PREV_LINE);
        standardActions.put(new KeyAction(208, new int[0]), NEXT_LINE);
        standardActions.put(new KeyAction(203, new int[0]), LEFT);
        standardActions.put(new KeyAction(205, new int[0]), RIGHT);
        standardActions.put(new KeyAction(14, new int[0]), BACKSPACE);
        standardActions.put(new KeyAction(28, new int[0]), NEW_LINE);
        standardActions.put(new KeyAction(156, new int[0]), NEW_LINE);
        standardActions.put(new KeyAction(211, new int[0]), DELETE);
    }

    private class KeyHandler
    implements KeyListener {
        private boolean shift = false;
        private boolean control = false;

        private KeyHandler() {
        }

        @Override
        public void onKeyEvent(KeyInputEvent evt) {
            int code = evt.getKeyCode();
            if (code == 42 || code == 54) {
                this.shift = evt.isPressed();
                return;
            }
            if (code == 29 || code == 157) {
                this.control = evt.isPressed();
                return;
            }
            if (evt.isPressed()) {
                KeyAction key = new KeyAction(code, this.control ? 1 : 0);
                KeyActionListener handler = (KeyActionListener)TextEntryComponent.this.actionMap.get(key);
                if (handler != null) {
                    handler.keyAction(TextEntryComponent.this, key);
                    evt.setConsumed();
                    return;
                }
                if (evt.getKeyChar() >= ' ') {
                    TextEntryComponent.this.model.insert(evt.getKeyChar());
                    evt.setConsumed();
                    TextEntryComponent.this.resetText();
                }
            }
        }
    }

    private static class Delete
    implements KeyActionListener {
        private Delete() {
        }

        @Override
        public void keyAction(TextEntryComponent source, KeyAction key) {
            source.model.delete();
            source.resetText();
        }
    }

    private static class NewLine
    implements KeyActionListener {
        private NewLine() {
        }

        @Override
        public void keyAction(TextEntryComponent source, KeyAction key) {
            source.model.insertNewLine();
            source.resetText();
        }
    }

    private static class Backspace
    implements KeyActionListener {
        private Backspace() {
        }

        @Override
        public void keyAction(TextEntryComponent source, KeyAction key) {
            source.model.backspace();
            source.resetText();
        }
    }

    private static class NullAction
    implements KeyActionListener {
        private NullAction() {
        }

        @Override
        public void keyAction(TextEntryComponent source, KeyAction key) {
        }
    }

    private static class CaratRight
    implements KeyActionListener {
        private CaratRight() {
        }

        @Override
        public void keyAction(TextEntryComponent source, KeyAction key) {
            source.model.right();
            source.resetCursorPosition();
        }
    }

    private static class CaratLeft
    implements KeyActionListener {
        private CaratLeft() {
        }

        @Override
        public void keyAction(TextEntryComponent source, KeyAction key) {
            source.model.left();
            source.resetCursorPosition();
        }
    }

    private static class NextLine
    implements KeyActionListener {
        private NextLine() {
        }

        @Override
        public void keyAction(TextEntryComponent source, KeyAction key) {
            source.model.down();
            source.resetCursorPosition();
        }
    }

    private static class PreviousLine
    implements KeyActionListener {
        private PreviousLine() {
        }

        @Override
        public void keyAction(TextEntryComponent source, KeyAction key) {
            source.model.up();
            source.resetCursorPosition();
        }
    }

    private static class LineEnd
    implements KeyActionListener {
        private LineEnd() {
        }

        @Override
        public void keyAction(TextEntryComponent source, KeyAction key) {
            source.model.end(true);
            source.resetCursorPosition();
        }
    }

    private static class DocumentEnd
    implements KeyActionListener {
        private DocumentEnd() {
        }

        @Override
        public void keyAction(TextEntryComponent source, KeyAction key) {
            source.model.end(false);
            source.resetCursorPosition();
        }
    }

    private static class LineHome
    implements KeyActionListener {
        private LineHome() {
        }

        @Override
        public void keyAction(TextEntryComponent source, KeyAction key) {
            source.model.home(true);
            source.resetCursorPosition();
        }
    }

    private static class DocumentHome
    implements KeyActionListener {
        private DocumentHome() {
        }

        @Override
        public void keyAction(TextEntryComponent source, KeyAction key) {
            source.model.home(false);
            source.resetCursorPosition();
        }
    }
}

