/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.core;

import com.simsilica.lemur.Command;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class CommandMap<S, K>
extends HashMap<K, List<Command<? super S>>> {
    private S source;

    public CommandMap(S source) {
        this.source = source;
    }

    public void runCommands(K key) {
        List<Command<S>> list = this.get(key, false);
        if (list == null) {
            return;
        }
        for (Command<S> c : list) {
            c.execute(this.source);
        }
    }

    public void addCommands(K key, Command<? super S> ... commands) {
        this.addCommands(key, Arrays.asList(commands));
    }

    public void addCommands(K key, Collection<Command<? super S>> commands) {
        if (commands == null) {
            this.get(key, true).clear();
            return;
        }
        this.get(key, true).addAll(commands);
    }

    public List<Command<? super S>> get(K key, boolean create) {
        CopyOnWriteArrayList result = (CopyOnWriteArrayList)super.get(key);
        if (result == null && create) {
            result = new CopyOnWriteArrayList();
            super.put(key, result);
        }
        return result;
    }
}

