/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.core;

import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.texture.Texture;
import com.simsilica.lemur.core.GuiMaterial;

public class UnshadedMaterialAdapter
implements GuiMaterial {
    private Material material;
    private ColorRGBA color;
    private Texture texture;

    public UnshadedMaterialAdapter(Material mat) {
        this.material = mat;
    }

    @Override
    public UnshadedMaterialAdapter clone() {
        try {
            UnshadedMaterialAdapter result = (UnshadedMaterialAdapter)super.clone();
            result.material = this.material.clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Error cloning", e);
        }
    }

    @Override
    public boolean isLit() {
        return false;
    }

    @Override
    public void setColor(ColorRGBA color) {
        this.color = color;
        if (color == null) {
            this.material.clearParam("Color");
        } else {
            this.material.setColor("Color", color);
        }
    }

    @Override
    public ColorRGBA getColor() {
        return this.color;
    }

    @Override
    public void setTexture(Texture t) {
        this.texture = t;
        if (this.texture == null) {
            this.material.clearParam("ColorMap");
        } else {
            this.material.setTexture("ColorMap", this.texture);
        }
    }

    @Override
    public Texture getTexture() {
        return this.texture;
    }

    @Override
    public Material getMaterial() {
        return this.material;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.material + "]";
    }
}

