/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.event;

import com.jme3.input.KeyNames;

public class KeyAction {
    public static final int CONTROL_DOWN = 1;
    private static final KeyNames names = new KeyNames();
    private int keyCode;
    private int modifiers;

    public KeyAction(int keyCode, int ... modifiers) {
        this.keyCode = keyCode;
        int m = 0;
        for (int i : modifiers) {
            m |= i;
        }
        this.modifiers = m;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        KeyAction other = (KeyAction)o;
        if (this.keyCode != other.keyCode) {
            return false;
        }
        return this.modifiers == other.modifiers;
    }

    public int hashCode() {
        return this.keyCode << 8 | this.modifiers;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public boolean hasModifier(int mod) {
        return (this.modifiers & mod) == mod;
    }

    public String toString() {
        String name = names.getName(this.keyCode);
        StringBuilder sb = new StringBuilder("KeyAction[");
        if (this.hasModifier(1)) {
            sb.append("Control ");
        }
        sb.append(name);
        return sb.toString();
    }
}

