/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.event;

import com.jme3.app.Application;
import com.jme3.input.RawInputListener;
import com.jme3.input.event.MouseButtonEvent;
import com.jme3.input.event.MouseMotionEvent;
import com.jme3.math.Vector2f;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.event.BaseAppState;
import com.simsilica.lemur.event.DefaultRawInputListener;
import com.simsilica.lemur.event.PickEventSession;

public class MouseAppState
extends BaseAppState {
    private boolean includeDefaultNodes = true;
    private MouseObserver mouseObserver = new MouseObserver();
    private long sampleFrequency = 16666666L;
    private long lastSample = 0L;
    private PickEventSession session = new PickEventSession();

    public MouseAppState(Application app) {
        this.setEnabled(true);
        app.getInputManager().addRawInputListener((RawInputListener)this.mouseObserver);
    }

    public void setIncludeDefaultCollisionRoots(boolean b) {
        this.includeDefaultNodes = b;
        if (this.isInitialized()) {
            if (b) {
                this.addCollisionRoot(this.getApplication().getGuiViewPort());
                this.addCollisionRoot(this.getApplication().getViewPort());
            } else {
                this.removeCollisionRoot(this.getApplication().getGuiViewPort());
                this.removeCollisionRoot(this.getApplication().getViewPort());
            }
        }
    }

    public boolean getIncludeDefaultCollisionRoots() {
        return this.includeDefaultNodes;
    }

    @Deprecated
    public ViewPort findViewPort(Spatial s) {
        return this.session.findViewPort(s);
    }

    public void addCollisionRoot(ViewPort viewPort) {
        this.session.addCollisionRoot(viewPort);
    }

    public void addCollisionRoot(Spatial root, ViewPort viewPort) {
        this.session.addCollisionRoot(root, viewPort);
    }

    public void removeCollisionRoot(ViewPort viewPort) {
        this.session.removeCollisionRoot(viewPort);
    }

    public void removeCollisionRoot(Spatial root) {
        this.session.removeCollisionRoot(root);
    }

    @Override
    protected void initialize(Application app) {
        if (this.includeDefaultNodes) {
            this.addCollisionRoot(app.getGuiViewPort());
            this.addCollisionRoot(app.getViewPort());
        }
    }

    @Override
    protected void cleanup(Application app) {
        app.getInputManager().removeRawInputListener((RawInputListener)this.mouseObserver);
        if (this.includeDefaultNodes) {
            this.removeCollisionRoot(app.getGuiViewPort());
            this.removeCollisionRoot(app.getViewPort());
        }
    }

    @Override
    protected void enable() {
        this.getApplication().getInputManager().setCursorVisible(true);
    }

    @Override
    protected void disable() {
        this.getApplication().getInputManager().setCursorVisible(false);
    }

    @Override
    public void update(float tpf) {
        super.update(tpf);
        long time = System.nanoTime();
        if (time - this.lastSample < this.sampleFrequency) {
            return;
        }
        this.lastSample = time;
        Vector2f cursor = this.getApplication().getInputManager().getCursorPosition();
        this.session.cursorMoved((int)cursor.x, (int)cursor.y);
    }

    protected void dispatch(MouseButtonEvent evt) {
        if (this.session.buttonEvent(evt.getButtonIndex(), evt.getX(), evt.getY(), evt.isPressed())) {
            evt.setConsumed();
        }
    }

    protected class MouseObserver
    extends DefaultRawInputListener {
        protected MouseObserver() {
        }

        @Override
        public void onMouseMotionEvent(MouseMotionEvent evt) {
        }

        @Override
        public void onMouseButtonEvent(MouseButtonEvent evt) {
            if (MouseAppState.this.isEnabled()) {
                MouseAppState.this.dispatch(evt);
            }
        }
    }
}

