/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mattacks;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityData;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.mattacks.EntityDataState;
import com.simsilica.mattacks.Main;
import com.simsilica.mattacks.es.Answer;
import com.simsilica.mattacks.es.Decay;
import com.simsilica.mattacks.es.Position;
import com.simsilica.mattacks.util.EntityContainer;

public class AnswerDisplayState
extends BaseAppState {
    private EntityData ed;
    private Node root;
    private LabelContainer labels;

    @Override
    protected void initialize(Application app) {
        this.root = new Node("answers");
        this.ed = this.getState(EntityDataState.class).getEntityData();
        this.labels = new LabelContainer(this.ed);
    }

    @Override
    protected void cleanup(Application app) {
    }

    @Override
    protected void onEnable() {
        ((Main)this.getApplication()).getGuiNode().attachChild(this.root);
        this.labels.start();
    }

    @Override
    public void update(float tpf) {
        this.labels.update();
    }

    @Override
    protected void onDisable() {
        this.labels.stop();
        this.root.removeFromParent();
    }

    private class LabelContainer
    extends EntityContainer<Label> {
        public LabelContainer(EntityData ed) {
            super(ed, Position.class, Answer.class);
        }

        @Override
        protected Label addObject(Entity e) {
            Decay decay = AnswerDisplayState.this.ed.getComponent(e.getId(), Decay.class);
            Answer a = e.get(Answer.class);
            ElementId id = decay == null ? new ElementId("answer.label") : (a.isCorrect() ? new ElementId("correct.answer.label") : new ElementId("incorrect.answer.label"));
            Label result = new Label(String.valueOf(a.getValue()), id);
            AnswerDisplayState.this.root.attachChild(result);
            this.updateObject(result, e);
            return result;
        }

        @Override
        protected void updateObject(Label object, Entity e) {
            Position pos = e.get(Position.class);
            Vector3f loc = pos.getLocation();
            Vector3f pref = object.getPreferredSize();
            object.setLocalTranslation(loc.x - pref.x * 0.5f, loc.y + pref.y * 0.5f, 10.0f);
            Decay decay = AnswerDisplayState.this.ed.getComponent(e.getId(), Decay.class);
            if (decay != null) {
                float alpha = (float)(1.0 - decay.getPercent());
                object.setAlpha(alpha);
            }
        }

        @Override
        protected void removeObject(Label object, Entity e) {
            object.removeFromParent();
        }
    }
}

