/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mattacks;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.Vector3f;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.mattacks.EntityDataState;
import com.simsilica.mattacks.es.Decay;
import com.simsilica.mattacks.es.Explosion;
import com.simsilica.mattacks.es.ModelType;
import com.simsilica.mattacks.es.Position;
import com.simsilica.mattacks.es.SoundType;
import com.simsilica.mattacks.es.Velocity;
import com.simsilica.mattacks.util.EntityContainer;

public class ExplosionState
extends BaseAppState {
    private EntityData ed;
    private Exploders exploders;
    private static final String[] SMOKE = new String[]{"Smoke/whitePuff00", "Smoke/whitePuff01", "Smoke/whitePuff02", "Smoke/whitePuff03", "Smoke/whitePuff04", "Smoke/whitePuff05", "Smoke/whitePuff06", "Smoke/whitePuff07", "Smoke/whitePuff08", "Smoke/whitePuff09", "Smoke/whitePuff10", "Smoke/whitePuff11", "Smoke/whitePuff12", "Smoke/whitePuff13", "Smoke/whitePuff14", "Smoke/whitePuff15", "Smoke/whitePuff16", "Smoke/whitePuff17", "Smoke/whitePuff18", "Smoke/whitePuff19", "Smoke/whitePuff20", "Smoke/whitePuff21", "Smoke/whitePuff22", "Smoke/whitePuff23", "Smoke/whitePuff24"};
    private static final String[] FLASH = new String[]{"Flash/flash00", "Flash/flash01", "Flash/flash02", "Flash/flash03", "Flash/flash04", "Flash/flash05", "Flash/flash06", "Flash/flash07", "Flash/flash08"};
    private static final String[] FIRE = new String[]{"Explosion/explosion00", "Explosion/explosion01", "Explosion/explosion02", "Explosion/explosion03", "Explosion/explosion04", "Explosion/explosion05", "Explosion/explosion06", "Explosion/explosion07", "Explosion/explosion08"};
    private ModelType[] smokeTypes;
    private ModelType[] flashTypes;
    private ModelType[] fireTypes;

    protected static ModelType[] modelTypes(String[] names, EntityData ed) {
        ModelType[] results = new ModelType[names.length];
        for (int i = 0; i < results.length; ++i) {
            results[i] = ModelType.create(names[i], ed);
        }
        return results;
    }

    protected static ModelType random(ModelType[] types) {
        int i = (int)(Math.random() * (double)types.length);
        return types[i];
    }

    @Override
    protected void initialize(Application app) {
        this.ed = this.getState(EntityDataState.class).getEntityData();
        this.smokeTypes = ExplosionState.modelTypes(SMOKE, this.ed);
        this.flashTypes = ExplosionState.modelTypes(FLASH, this.ed);
        this.fireTypes = ExplosionState.modelTypes(FIRE, this.ed);
        this.exploders = new Exploders(this.ed);
    }

    @Override
    protected void cleanup(Application app) {
    }

    @Override
    protected void onEnable() {
        this.exploders.start();
    }

    @Override
    public void update(float tpf) {
        this.exploders.update();
    }

    @Override
    protected void onDisable() {
        this.exploders.stop();
    }

    private class Exploders
    extends EntityContainer<Exploder> {
        public Exploders(EntityData ed) {
            super(ed, Position.class, Velocity.class, Explosion.class);
        }

        @Override
        protected Exploder addObject(Entity e) {
            return new Exploder(e);
        }

        @Override
        protected void updateObject(Exploder object, Entity e) {
        }

        @Override
        protected void removeObject(Exploder object, Entity e) {
        }
    }

    private class Exploder {
        Entity entity;

        public Exploder(Entity entity) {
            this.entity = entity;
            Position pos = entity.get(Position.class);
            Velocity vel = entity.get(Velocity.class);
            Vector3f loc = pos.getLocation();
            Vector3f v = vel.getLinear();
            float baseDuration = 0.5f;
            EntityId smoke = ExplosionState.this.ed.createEntity();
            ExplosionState.this.ed.setComponents(smoke, new Position(loc.subtract(0.0f, 0.0f, 2.0f)), ExplosionState.random(ExplosionState.this.smokeTypes), new Velocity(0.0f, 10.0f), Decay.futureSeconds(baseDuration));
            EntityId fire = ExplosionState.this.ed.createEntity();
            ExplosionState.this.ed.setComponents(fire, new Position(loc.subtract(0.0f, 0.0f, 1.0f)), new Velocity(v.mult(0.9f)), ExplosionState.random(ExplosionState.this.fireTypes), Decay.futureSeconds(baseDuration * 0.5f));
            EntityId flash = ExplosionState.this.ed.createEntity();
            ExplosionState.this.ed.setComponents(flash, pos, vel, ExplosionState.random(ExplosionState.this.flashTypes), Decay.futureSeconds(baseDuration * 0.2f));
            ExplosionState.this.ed.removeComponent(entity.getId(), ModelType.class);
            entity.set(Decay.futureSeconds(baseDuration * 2.0f));
            entity.set(SoundType.create("boom1", ExplosionState.this.ed));
        }

        public void update() {
        }
    }
}

