/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mattacks;

import com.simsilica.mattacks.Level;
import com.simsilica.mattacks.LevelFactory;
import com.simsilica.mattacks.ProblemSetFactory;
import com.simsilica.mattacks.es.FlashCard;
import com.simsilica.mattacks.es.ModelType;
import java.util.List;

public class LevelFactories {
    public static LevelFactory standard(String category, String name, String description, ModelType type, int lanes, float speed, int total, ProblemSetFactory factory) {
        return new DefaultFactory(category, name, description, type, lanes, speed, total, factory);
    }

    private static class DefaultFactory
    implements LevelFactory {
        private String category;
        private String name;
        private String description;
        private ModelType type;
        private int lanes;
        private float speed;
        private int total;
        private ProblemSetFactory factory;

        public DefaultFactory(String category, String name, String description, ModelType type, int lanes, float speed, int total, ProblemSetFactory factory) {
            this.category = category;
            this.name = name;
            this.description = description;
            this.type = type;
            this.lanes = lanes;
            this.speed = speed;
            this.total = total;
            this.factory = factory;
        }

        @Override
        public String getCategory() {
            return this.category;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Level createLevel() {
            List<FlashCard> problems = this.factory.createProblems(this.total);
            Level result = new Level(this.category, this.name, this.description, problems, this.lanes, this.type, this.speed, 1);
            return result;
        }
    }
}

