/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mattacks;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.mattacks.EntityDataState;
import com.simsilica.mattacks.GameState;
import com.simsilica.mattacks.Level;
import com.simsilica.mattacks.ScoreState;
import com.simsilica.mattacks.SoundState;
import com.simsilica.mattacks.es.Answer;
import com.simsilica.mattacks.es.FlashCard;
import com.simsilica.mattacks.es.ModelType;
import com.simsilica.mattacks.es.Position;
import com.simsilica.mattacks.es.Velocity;
import com.simsilica.mattacks.util.EntityContainer;
import java.util.ArrayList;
import java.util.List;

public class LevelState
extends BaseAppState {
    private EntityData ed;
    private Level level;
    private int laneCount = 4;
    private EntityId[] lanes;
    private int screenMargin = 32;
    private int stagger = 100;
    private float yNext;
    private MobContainer mobs;
    private final List<FlashCard> problems;
    private final ModelType modelType;
    private float speed;
    private final List<EntityId> created = new ArrayList<EntityId>();

    public LevelState(Level level) {
        this.level = level;
        this.problems = level.getProblems();
        this.modelType = level.getShipType();
        this.laneCount = level.getLanes();
        this.speed = level.getSpeed();
    }

    public Level getLevel() {
        return this.level;
    }

    @Override
    protected void initialize(Application app) {
        this.ed = this.getState(EntityDataState.class).getEntityData();
        this.getState(ScoreState.class).newStage(this.problems.size(), this.level.getTitle());
        this.mobs = new MobContainer(this.ed);
        this.lanes = new EntityId[this.laneCount];
        this.yNext = this.getApplication().getCamera().getHeight() + 64;
    }

    protected EntityId createAlien(FlashCard problem, float x, float y, float z) {
        Position pos = new Position(x, y, z);
        Velocity vel = new Velocity(0.0f, -this.speed);
        EntityId result = this.ed.createEntity();
        this.created.add(result);
        this.ed.setComponents(result, problem, pos, vel, this.modelType);
        return result;
    }

    @Override
    public void update(float tpf) {
        if (this.mobs.update()) {
            this.updateLanes();
            this.checkMisses();
        }
        this.yNext -= 30.0f * tpf;
    }

    @Override
    protected void cleanup(Application app) {
        for (EntityId id : this.created) {
            this.ed.removeEntity(id);
        }
    }

    @Override
    protected void onEnable() {
        this.mobs.start();
        this.updateLanes();
        this.getState(SoundState.class).playMusic("Sounds/SpaceRace.ogg");
    }

    @Override
    protected void onDisable() {
        this.mobs.stop();
    }

    protected void updateLanes() {
        if (this.mobs.size() >= this.laneCount) {
            return;
        }
        float y = Math.max(this.yNext, (float)(this.getApplication().getCamera().getHeight() + 64));
        float xSize = (this.getApplication().getCamera().getWidth() - this.screenMargin * 2) / this.lanes.length;
        int activeLanes = 0;
        for (int i = 0; i < this.lanes.length; ++i) {
            if (this.mobs.getObject(this.lanes[i]) != null) {
                ++activeLanes;
                continue;
            }
            if (this.problems.isEmpty()) continue;
            float xBase = (float)i * xSize + 32.0f + (float)this.screenMargin;
            float offset = (float)(Math.random() * (double)(xSize - 64.0f));
            float x = xBase + offset;
            FlashCard problem = this.problems.remove(0);
            this.lanes[i] = this.createAlien(problem, x, y, 0.0f);
            this.yNext = y += (float)this.stagger;
            ++activeLanes;
        }
        if (activeLanes <= 0) {
            System.out.println("Level DONE!");
            this.getState(GameState.class).levelComplete(this);
        }
    }

    protected void checkMisses() {
        for (Entity e : this.mobs.getArray()) {
            Position pos = e.get(Position.class);
            if (!(pos.getLocation().y < 41.0f)) continue;
            FlashCard problem = this.ed.getComponent(e.getId(), FlashCard.class);
            e.set(new Answer(problem, -1));
        }
    }

    private class MobContainer
    extends EntityContainer<Entity> {
        public MobContainer(EntityData ed) {
            super(ed, FlashCard.class, Position.class);
        }

        protected Entity[] getArray() {
            return (Entity[])super.getArray();
        }

        @Override
        protected Entity addObject(Entity e) {
            return e;
        }

        @Override
        protected void updateObject(Entity object, Entity e) {
        }

        @Override
        protected void removeObject(Entity object, Entity e) {
        }
    }
}

