/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mattacks;

import com.jme3.app.BasicProfilerState;
import com.jme3.app.DebugKeysAppState;
import com.jme3.app.SimpleApplication;
import com.jme3.app.StatsAppState;
import com.jme3.app.state.ScreenshotAppState;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import com.jme3.system.AppSettings;
import com.simsilica.es.base.DefaultEntityData;
import com.simsilica.lemur.Button;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Command;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.OptionPanelState;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.anim.AbstractTween;
import com.simsilica.lemur.anim.Animation;
import com.simsilica.lemur.anim.AnimationState;
import com.simsilica.lemur.anim.SpatialTweens;
import com.simsilica.lemur.anim.Tween;
import com.simsilica.lemur.anim.TweenAnimation;
import com.simsilica.lemur.anim.Tweens;
import com.simsilica.lemur.effect.Effect;
import com.simsilica.lemur.effect.EffectControl;
import com.simsilica.lemur.effect.EffectInfo;
import com.simsilica.lemur.input.InputMapper;
import com.simsilica.lemur.style.Attributes;
import com.simsilica.lemur.style.BaseStyles;
import com.simsilica.lemur.style.Styles;
import com.simsilica.mattacks.AchievementsState;
import com.simsilica.mattacks.DecayState;
import com.simsilica.mattacks.EntityDataState;
import com.simsilica.mattacks.GameState;
import com.simsilica.mattacks.IntroductionState;
import com.simsilica.mattacks.LevelSelectionState;
import com.simsilica.mattacks.MainFunctions;
import com.simsilica.mattacks.MainMenuState;
import com.simsilica.mattacks.ModelState;
import com.simsilica.mattacks.OptionConfigurationState;
import com.simsilica.mattacks.PhysicsState;
import com.simsilica.mattacks.PlayerDbState;
import com.simsilica.mattacks.SoundCommand;
import com.simsilica.mattacks.SoundState;
import com.simsilica.mattacks.StarFieldState;
import com.simsilica.mattacks.TimeState;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main
extends SimpleApplication {
    static Logger log = LoggerFactory.getLogger(Main.class);
    private static String entityDbLocation;

    public static void main(String ... args) throws Exception {
        Main main = new Main();
        AppSettings settings = new AppSettings(true);
        settings.load("Math Attack!");
        settings.setTitle("Math Attack!");
        settings.setSettingsDialogImage("/Interface/MathAttack-cropped.png");
        settings.setUseJoysticks(true);
        try {
            Object[] icons = new BufferedImage[]{ImageIO.read(Main.class.getResource("/Interface/mattacks-icon128.png")), ImageIO.read(Main.class.getResource("/Interface/mattacks-icon64.png")), ImageIO.read(Main.class.getResource("/Interface/mattacks-icon32.png")), ImageIO.read(Main.class.getResource("/Interface/mattacks-icon16.png"))};
            settings.setIcons(icons);
        }
        catch (IOException e) {
            log.warn("Error loading globe icons", e);
        }
        main.setSettings(settings);
        main.start();
    }

    public Main() {
        super(new StatsAppState(), new DebugKeysAppState(), new BasicProfilerState(false), new AnimationState(), new OptionPanelState(), new EntityDataState(new DefaultEntityData()), new TimeState(), new DecayState(), new PlayerDbState(), new AchievementsState(), new PhysicsState(), new ModelState(), new SoundState(), new LevelSelectionState(), new OptionConfigurationState(), new IntroductionState(), new StarFieldState(), new ScreenshotAppState("", System.currentTimeMillis()));
    }

    public void noop() {
    }

    @Override
    public void stop() {
        super.stop();
    }

    protected void disableState(Class type) {
        Object state = this.stateManager.getState(type);
        if (state != null) {
            state.setEnabled(false);
        }
    }

    public void fadeOut() {
        this.disableState(MainMenuState.class);
        this.disableState(LevelSelectionState.class);
        GameState gs = this.stateManager.getState(GameState.class);
        if (gs != null) {
            this.stateManager.detach(gs);
        }
        AnimationState anim = this.stateManager.getState(AnimationState.class);
        SoundState sound = this.stateManager.getState(SoundState.class);
        sound.fadeMusic(2.0f);
        Tween starFieldFade = new AbstractTween(2.0){

            @Override
            protected void doInterpolate(double t) {
                Main.this.stateManager.getState(StarFieldState.class).setAlpha(1.0f - (float)t);
            }
        };
        starFieldFade = Tweens.smoothStep(starFieldFade);
        anim.add(starFieldFade, Tweens.callMethod(this, "stop", new Object[0]));
    }

    public void exit() {
        System.out.println("User wants to exit.");
        this.stateManager.getState(OptionPanelState.class).show("Exit Game", "Really exit game?", new CallMethodAction("Yes", this, "fadeOut"), new CallMethodAction("No", this, "noop"), new CallMethodAction("Cancel", this, "noop"));
    }

    public void test1(float t) {
        System.out.println("test1(" + t + ")");
    }

    public void test2(double t) {
        System.out.println("test2(" + t + ")");
    }

    public void test1a(float t, String arg) {
        System.out.println("test1a(" + t + ", " + arg + ")");
    }

    public void test2a(double t, String arg) {
        System.out.println("test2a(" + t + ", " + arg + ")");
    }

    public void test1b(String arg, float t) {
        System.out.println("test1b(" + arg + ", " + t + ")");
    }

    public void test2b(String arg, double t) {
        System.out.println("test2b(" + arg + ", " + t + ")");
    }

    @Override
    public void simpleInitApp() {
        List<SoundCommand> click;
        this.setPauseOnLostFocus(false);
        this.setDisplayFps(false);
        this.setDisplayStatView(false);
        GuiGlobals.initialize(this);
        GuiGlobals globals = GuiGlobals.getInstance();
        BaseStyles.loadGlassStyle();
        globals.getStyles().setDefaultStyle("glass");
        BaseStyles.loadStyleResources("/com/simsilica/mattacks/mattacks-styles.groovy");
        Styles styles = globals.getStyles();
        SoundCommand beep1 = SoundCommand.create(this.assetManager, "Sounds/twoTone2.ogg", true);
        SoundCommand beep2 = SoundCommand.create(this.assetManager, "Sounds/tone1.ogg", true);
        Attributes attrs = styles.getSelector("button", "glass");
        System.out.println("glass button attrs:" + attrs);
        Map commands = (Map)attrs.get("buttonCommands");
        System.out.println("commands:" + commands);
        if (commands.get((Object)Button.ButtonAction.Click) != null) {
            click = (List)commands.get((Object)Button.ButtonAction.Click);
        } else {
            click = new ArrayList();
            commands.put(Button.ButtonAction.Click, click);
        }
        click.add(beep1);
        attrs = styles.getSelector("slider", "thumb.button", "glass");
        System.out.println("slider thumb buttons:" + attrs);
        HashMap commands2 = new HashMap();
        if (commands.containsKey((Object)Button.ButtonAction.Down)) {
            commands2.put(Button.ButtonAction.Down, null);
        }
        if (commands.containsKey((Object)Button.ButtonAction.Up)) {
            commands2.put(Button.ButtonAction.Up, null);
        }
        commands2.put(Button.ButtonAction.Click, null);
        attrs.set("buttonCommands", commands2);
        attrs = styles.getSelector("slider", "button", "glass");
        System.out.println("slider buttons:" + attrs);
        commands2 = new HashMap();
        if (commands.containsKey((Object)Button.ButtonAction.Down)) {
            commands2.put(Button.ButtonAction.Down, commands.get((Object)Button.ButtonAction.Down));
        }
        if (commands.containsKey((Object)Button.ButtonAction.Up)) {
            commands2.put(Button.ButtonAction.Up, commands.get((Object)Button.ButtonAction.Up));
        }
        attrs.set("buttonCommands", commands2);
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        MainFunctions.initializeDefaultMappings(inputMapper);
        this.inputManager.deleteMapping("SIMPLEAPP_Exit");
    }

    private void testAnimation() {
        AnimationState anim = this.stateManager.getState(AnimationState.class);
        Label testLabel1 = new Label("Testing 1");
        testLabel1.setLocalTranslation(100.0f, 100.0f, 100.0f);
        Label testLabel2 = new Label("Testing 2");
        testLabel2.setLocalTranslation(100.0f, 130.0f, 100.0f);
        Label testLabel3 = new Label("Testing 3");
        testLabel3.setLocalTranslation(100.0f, 160.0f, 100.0f);
        Tween attach1 = SpatialTweens.attach(testLabel1, this.guiNode);
        Tween attach2 = SpatialTweens.attach(testLabel2, this.guiNode);
        Tween attach3 = SpatialTweens.attach(testLabel3, this.guiNode);
        Tween detach1 = SpatialTweens.detach(testLabel1);
        Tween detach2 = SpatialTweens.detach(testLabel2);
        Tween detach3 = SpatialTweens.detach(testLabel3);
        Tween start1 = SpatialTweens.move(testLabel1, null, null, 0.0);
        Tween start2 = SpatialTweens.move(testLabel2, null, null, 0.0);
        Tween start3 = SpatialTweens.move(testLabel3, null, null, 0.0);
        Tween move1 = SpatialTweens.move(testLabel1, null, new Vector3f(800.0f, 100.0f, 100.0f), 15.0);
        Tween move2 = SpatialTweens.move(testLabel2, null, new Vector3f(800.0f, 130.0f, 100.0f), 15.0);
        Tween move3 = SpatialTweens.move(testLabel3, null, new Vector3f(800.0f, 160.0f, 100.0f), 15.0);
        Tween revMove1 = SpatialTweens.move(testLabel1, new Vector3f(800.0f, 100.0f, 100.0f), null, 15.0);
        Tween revMove2 = SpatialTweens.move(testLabel2, new Vector3f(800.0f, 130.0f, 100.0f), null, 15.0);
        Tween revMove3 = SpatialTweens.move(testLabel3, new Vector3f(800.0f, 160.0f, 100.0f), null, 15.0);
        Quaternion qFrom = new Quaternion();
        Quaternion qTo = new Quaternion().fromAngles(0.0f, 0.0f, (float)Math.PI);
        Tween rot1 = SpatialTweens.rotate(testLabel1, null, qTo, 15.0);
        Tween rot2 = SpatialTweens.rotate(testLabel2, null, qTo, 15.0);
        Tween rot3 = SpatialTweens.rotate(testLabel3, null, qTo, 15.0);
        Tween revRot1 = SpatialTweens.rotate(testLabel1, qTo, null, 15.0);
        Tween revRot2 = SpatialTweens.rotate(testLabel2, qTo, null, 15.0);
        Tween revRot3 = SpatialTweens.rotate(testLabel3, qTo, null, 15.0);
        Tween parallel = Tweens.parallel(move1, Tweens.smoothStep(move2), Tweens.sineStep(move3), rot1, Tweens.smoothStep(rot2), Tweens.sineStep(rot3));
        Tween revParallel = Tweens.parallel(revMove1, Tweens.smoothStep(revMove2), Tweens.sineStep(revMove3), revRot1, Tweens.smoothStep(revRot2), Tweens.sineStep(revRot3));
        Tween full = Tweens.sequence(Tweens.delay(2.0), attach1, attach2, attach3, start1, start2, start3, Tweens.delay(2.0), parallel, Tweens.delay(2.0), revParallel, Tweens.delay(2.0), detach1, detach2, detach3);
        anim.add(new TweenAnimation(true, full));
        Tween scale1 = SpatialTweens.scale((Spatial)testLabel1, 1.0f, 1.25f, 0.5);
        Tween scale2 = SpatialTweens.scale((Spatial)testLabel1, 1.25f, 1.0f, 0.5);
        Tween seq = Tweens.sequence(scale1, scale2);
        anim.add(new TweenAnimation(true, seq));
        scale1 = SpatialTweens.scale((Spatial)testLabel2, 1.0f, 1.25f, 0.5);
        scale2 = SpatialTweens.scale((Spatial)testLabel2, 1.25f, 1.0f, 0.5);
        seq = Tweens.sequence(Tweens.smoothStep(scale1), Tweens.smoothStep(scale2));
        anim.add(new TweenAnimation(true, seq));
        scale1 = SpatialTweens.scale((Spatial)testLabel3, 1.0f, 1.25f, 0.5);
        scale2 = SpatialTweens.scale((Spatial)testLabel3, 1.25f, 1.0f, 0.5);
        seq = Tweens.sequence(Tweens.sineStep(scale1), Tweens.sineStep(scale2));
        anim.add(new TweenAnimation(true, seq));
        Effect<Panel> startWave = new Effect<Panel>(){

            @Override
            public String getChannel() {
                return "wave";
            }

            @Override
            public Animation create(Panel target, EffectInfo last) {
                Tween upScale = SpatialTweens.scale((Spatial)target, 1.0f, 1.1f, 0.25);
                Tween downScale = SpatialTweens.scale((Spatial)target, 1.1f, 1.0f, 0.25);
                Tween all = Tweens.sequence(Tweens.smoothStep(upScale), Tweens.smoothStep(downScale));
                return new TweenAnimation(true, all);
            }
        };
        Effect<Panel> endWave = new Effect<Panel>(){

            @Override
            public String getChannel() {
                return "wave";
            }

            @Override
            public Animation create(Panel target, EffectInfo last) {
                Tween downScale = SpatialTweens.scale((Spatial)target, null, new Vector3f(1.0f, 1.0f, 1.0f), 0.1);
                return new TweenAnimation(Tweens.smoothStep(downScale));
            }
        };
        Button testButton = new Button("A Test Button");
        testButton.setLocalTranslation(200.0f, 300.0f, 100.0f);
        this.guiNode.attachChild(testButton);
        EffectControl<Panel> effects = new EffectControl<Panel>(anim);
        effects.addEffect("activate", startWave);
        effects.addEffect("deactivate", endWave);
        testButton.addControl(effects);
        Command<Button> on = new Command<Button>(){

            @Override
            public void execute(Button source) {
                EffectControl effects = source.getControl(EffectControl.class);
                if (effects != null) {
                    effects.runEffect("activate");
                }
            }
        };
        Command<Button> off = new Command<Button>(){

            @Override
            public void execute(Button source) {
                EffectControl effects = source.getControl(EffectControl.class);
                if (effects != null) {
                    effects.runEffect("deactivate");
                }
            }
        };
        testButton.addCommands(Button.ButtonAction.HighlightOn, on);
        testButton.addCommands(Button.ButtonAction.HighlightOff, off);
    }

    public void callTest(String parm1) {
        System.out.println("%%%%%%%%%%%%%%%%% call test:" + parm1);
    }

    private void callTest2(String parm1, Number parm2, Object parm3) {
        System.out.println("%%%%%%%%%%%%%%%%% call test2:" + parm1 + ", " + parm2 + ", " + parm3);
    }
}

