/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mattacks;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Checkbox;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.DefaultRangedValueModel;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.OptionPanel;
import com.simsilica.lemur.OptionPanelState;
import com.simsilica.lemur.RangedValueModel;
import com.simsilica.lemur.Slider;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedObject;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.mattacks.MainFunctions;
import com.simsilica.mattacks.SoundSettings;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class OptionConfigurationState
extends BaseAppState {
    private String configPath;
    private OptionPanel config;
    private Container window;
    private Container graphics;
    private Container sounds;
    private final RangedValueModel uiModel = new VolumeModel(SoundSettings.getInterfaceVo());
    private final RangedValueModel effectsModel = new VolumeModel(SoundSettings.getEffectsVo());
    private final RangedValueModel musicModel = new VolumeModel(SoundSettings.getMusicVo());
    private final VersionGroup updateGroup = new VersionGroup(SoundSettings.getInterfaceVo(), SoundSettings.getEffectsVo(), SoundSettings.getMusicVo(), SoundSettings.getInterfaceOnVo(), SoundSettings.getEffectsOnVo(), SoundSettings.getMusicOnVo());
    private final VersionedReference<VersionGroup> updateRef = this.updateGroup.createReference();
    private long nextCheck = 0L;
    private long nextSave = -1L;

    public OptionConfigurationState() {
        this("MathAttack");
    }

    public OptionConfigurationState(String configPath) {
        this.configPath = configPath;
        this.setEnabled(false);
        this.loadOptions();
    }

    protected Preferences getConfig() {
        Preferences prefs = Preferences.userRoot();
        return prefs.node(this.configPath);
    }

    protected void saveOptions() {
        System.out.println("Need to save configuration.");
        this.nextSave = -1L;
        Preferences prefs = this.getConfig();
        prefs.putFloat("uiVolume", SoundSettings.getInterfaceVolume());
        prefs.putBoolean("uiVolumeOn", SoundSettings.getInterfaceOnVo().isChecked());
        prefs.putFloat("effectsVolume", SoundSettings.getEffectsVolume());
        prefs.putBoolean("effectsVolumeOn", SoundSettings.getEffectsOnVo().isChecked());
        prefs.putFloat("musicVolume", SoundSettings.getMusicVolume());
        prefs.putBoolean("musicVolumeOn", SoundSettings.getMusicOnVo().isChecked());
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            throw new RuntimeException("Error saving settings", ex);
        }
    }

    protected void loadOptions() {
        Preferences prefs = this.getConfig();
        try {
            prefs.sync();
        }
        catch (BackingStoreException ex) {
            throw new RuntimeException("Error loading settings", ex);
        }
        SoundSettings.setInterfaceVolume(prefs.getFloat("uiVolume", 1.0f));
        SoundSettings.getInterfaceOnVo().setChecked(prefs.getBoolean("uiVolumeOn", true));
        SoundSettings.setEffectsVolume(prefs.getFloat("effectsVolume", 0.5f));
        SoundSettings.getEffectsOnVo().setChecked(prefs.getBoolean("effectsVolumeOn", true));
        SoundSettings.setMusicVolume(prefs.getFloat("musicVolume", 0.5f));
        SoundSettings.getMusicOnVo().setChecked(prefs.getBoolean("musicVolumeOn", true));
    }

    public void open(float x, float y, float z) {
        this.setEnabled(true);
    }

    public void close() {
        this.setEnabled(false);
    }

    @Override
    protected void initialize(Application app) {
        this.window = new Container(new ElementId("options.container"));
        this.config = new OptionPanel("Configuration", (String)null, null, new CallMethodAction(this, "close"));
        this.config.getContainer().addChild(this.window, new Object[0]);
        this.graphics = this.window.addChild(new Container(new ElementId("options.section.container")), new Object[0]);
        this.graphics.addChild(new Label("Graphics", new ElementId("section.title.label")), new Object[0]);
        Container sub = this.graphics.addChild(new Container(new ElementId("nested.section.container")), new Object[0]);
        sub.addChild(new Label("Not yet implemented", new ElementId("disabled.label")), new Object[0]);
        this.sounds = this.window.addChild(new Container(new ElementId("options.section.container")), new Object[0]);
        this.sounds.addChild(new Label("Sound", new ElementId("section.title.label")), new Object[0]);
        sub = this.sounds.addChild(new Container(new ElementId("nested.section.container")), new Object[0]);
        sub.setLayout(new SpringGridLayout(Axis.Y, Axis.X, FillMode.None, FillMode.Last));
        sub.addChild(new Checkbox("", SoundSettings.getInterfaceOnVo()), new Object[0]);
        sub.addChild(new Label("UI:", new ElementId("option.label")), 1);
        sub.addChild(new Slider(this.uiModel, new ElementId("option.slider")), 2);
        sub.addChild(new Checkbox("", SoundSettings.getEffectsOnVo()), new Object[0]);
        sub.addChild(new Label("Effects:", new ElementId("option.label")), 1);
        sub.addChild(new Slider(this.effectsModel, new ElementId("option.slider")), 2);
        sub.addChild(new Checkbox("", SoundSettings.getMusicOnVo()), new Object[0]);
        sub.addChild(new Label("Music:", new ElementId("option.label")), 1);
        sub.addChild(new Slider(this.musicModel, new ElementId("option.slider")), 2);
    }

    @Override
    protected void cleanup(Application app) {
    }

    @Override
    protected void onEnable() {
        GuiGlobals.getInstance().getInputMapper().activateGroup(MainFunctions.IN_POPUP);
        GuiGlobals.getInstance().getInputMapper().addDelegate(MainFunctions.F_EXIT_POPUP, this, "close");
        this.getState(OptionPanelState.class).show(this.config);
    }

    @Override
    public void update(float tpf) {
        long time = System.currentTimeMillis();
        if (time > this.nextCheck) {
            this.nextCheck = time + 1000L;
            if (this.updateRef.update()) {
                this.nextSave = time + 1000L;
            }
        }
        if (this.nextSave > 0L && time > this.nextSave) {
            this.saveOptions();
        }
    }

    @Override
    protected void onDisable() {
        GuiGlobals.getInstance().getInputMapper().deactivateGroup(MainFunctions.IN_POPUP);
        GuiGlobals.getInstance().getInputMapper().removeDelegate(MainFunctions.F_EXIT_POPUP, this, "close");
        this.getState(OptionPanelState.class).close();
    }

    private class VersionGroup
    implements VersionedObject<VersionGroup> {
        private final VersionedReference[] refs;
        private long version;

        public VersionGroup(VersionedObject ... objects) {
            this.refs = new VersionedReference[objects.length];
            for (int i = 0; i < this.refs.length; ++i) {
                this.refs[i] = objects[i].createReference();
                this.version += this.refs[i].getLastVersion();
            }
        }

        @Override
        public long getVersion() {
            for (VersionedReference ref : this.refs) {
                if (!ref.needsUpdate()) continue;
                this.version -= ref.getLastVersion();
                ref.update();
                this.version += ref.getLastVersion();
            }
            return this.version;
        }

        @Override
        public VersionGroup getObject() {
            return this;
        }

        @Override
        public VersionedReference<VersionGroup> createReference() {
            return new VersionedReference<VersionGroup>(this);
        }
    }

    private class VolumeModel
    extends DefaultRangedValueModel {
        private final VersionedHolder<Float> volume;
        private long lastVersion;

        public VolumeModel(VersionedHolder<Float> volume) {
            super(0.0, 100.0, volume.getObject().floatValue() * 100.0f);
            this.lastVersion = -1L;
            this.volume = volume;
        }

        @Override
        public long getVersion() {
            long version = this.volume.getVersion();
            if (version != this.lastVersion) {
                this.lastVersion = version;
                super.setValue(this.volume.getObject().floatValue() * 100.0f);
            }
            return version;
        }

        @Override
        public void setValue(double val) {
            System.out.println("setValue(" + val + ")");
            super.setValue(val);
            this.volume.setObject(Float.valueOf((float)this.getValue() / 100.0f));
        }
    }
}

