/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mattacks;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.Vector3f;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityData;
import com.simsilica.mattacks.EntityDataState;
import com.simsilica.mattacks.TimeState;
import com.simsilica.mattacks.es.Position;
import com.simsilica.mattacks.es.Velocity;
import com.simsilica.mattacks.util.EntityContainer;

public class PhysicsState
extends BaseAppState {
    private EntityData ed;
    private MobContainer mobs;
    private TimeState timeState;
    private float base = 40.0f;

    @Override
    protected void initialize(Application app) {
        this.ed = this.getState(EntityDataState.class).getEntityData();
        this.timeState = this.getState(TimeState.class);
        this.mobs = new MobContainer(this.ed);
    }

    @Override
    protected void cleanup(Application app) {
    }

    @Override
    protected void onEnable() {
        this.mobs.start();
    }

    @Override
    public void update(float tpf) {
        this.mobs.update();
        double delta = this.timeState.getFrameDeltaSecs();
        for (Entity e : this.mobs.getArray()) {
            Position pos = e.get(Position.class);
            Velocity vel = e.get(Velocity.class);
            Vector3f v = vel.getLinear();
            if (v.lengthSquared() > 0.0f) {
                pos = pos.integrate(v, delta);
                e.set(pos);
            }
            Vector3f loc = pos.getLocation();
            if (!(loc.y <= this.base)) continue;
            loc.y = this.base;
            e.set(new Position(loc));
            this.ed.removeComponent(e.getId(), Velocity.class);
        }
    }

    @Override
    protected void onDisable() {
        this.mobs.stop();
    }

    private class MobContainer
    extends EntityContainer<Entity> {
        public MobContainer(EntityData ed) {
            super(ed, Position.class, Velocity.class);
        }

        protected Entity[] getArray() {
            return (Entity[])super.getArray();
        }

        @Override
        protected Entity addObject(Entity e) {
            return e;
        }

        @Override
        protected void updateObject(Entity object, Entity e) {
        }

        @Override
        protected void removeObject(Entity object, Entity e) {
        }
    }
}

