/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mattacks;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class ScriptManager {
    private final List<CompiledScript> api = new ArrayList<CompiledScript>();
    private final ScriptEngine engine;
    private Compilable compiler;
    private Bindings bindings;
    private final Map<CompiledScript, Object> sources = new HashMap<CompiledScript, Object>();
    private boolean initialized = false;

    public ScriptManager(Object ... apiScripts) {
        ScriptEngineManager factory = new ScriptEngineManager();
        this.engine = factory.getEngineByName("groovy");
        if (this.engine == null) {
            throw new RuntimeException("Groovy scripting engine not available.");
        }
        this.compiler = (Compilable)((Object)this.engine);
        this.bindings = this.engine.createBindings();
        this.compileApi(apiScripts);
    }

    protected final void compileApi(Object ... apiScripts) {
        for (Object o : apiScripts) {
            try {
                if (o instanceof String) {
                    this.compileApiResource((String)o);
                    continue;
                }
                if (!(o instanceof File)) continue;
                this.compileApiFile((File)o);
            }
            catch (ScriptException e) {
                throw new RuntimeException("Error compiling script:" + o, e);
            }
        }
    }

    protected void addApiScript(CompiledScript script, String source) {
        this.api.add(script);
        this.sources.put(script, source);
    }

    protected void compileApiResource(String s) throws ScriptException {
        InputStream rawIn = this.getClass().getResourceAsStream(s);
        if (rawIn == null) {
            throw new ScriptException("Script resource not found for:" + s);
        }
        InputStreamReader in = new InputStreamReader(rawIn);
        this.addApiScript(this.compiler.compile(in), "resource:" + s);
    }

    protected void compileApiFile(File f) throws ScriptException {
        try {
            FileReader in = new FileReader(f);
            this.addApiScript(this.compiler.compile(in), "file:" + f);
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
    }

    public void setBinding(String name, Object value) {
        this.bindings.put(name, value);
    }

    public Object getBinding(String name) {
        return this.bindings.get(name);
    }

    public void initializeApi() {
        for (CompiledScript script : this.api) {
            try {
                script.eval(this.bindings);
            }
            catch (ScriptException e) {
                throw new RuntimeException("Error running:" + script + " from:" + this.sources.get(script), e);
            }
        }
        this.initialized = true;
    }

    public Object runScriptResource(String s) {
        if (!this.initialized) {
            this.initializeApi();
        }
        try {
            InputStreamReader in = new InputStreamReader(this.getClass().getResourceAsStream(s));
            CompiledScript script = this.compiler.compile(in);
            int before = this.bindings.size();
            Object result = script.eval(this.bindings);
            if (before != this.bindings.size()) {
                // empty if block
            }
            return result;
        }
        catch (ScriptException e) {
            throw new RuntimeException("Error running resource:" + s, e);
        }
    }

    public Object runScript(URL u) {
        try {
            return this.runScript(u.toString(), new InputStreamReader(u.openStream()));
        }
        catch (IOException e) {
            throw new RuntimeException("Error opening stream for:" + u, e);
        }
    }

    public Object runScript(String name, Reader in) {
        if (!this.initialized) {
            this.initializeApi();
        }
        try {
            CompiledScript script = this.compiler.compile(in);
            int before = this.bindings.size();
            Object result = script.eval(this.bindings);
            if (before != this.bindings.size()) {
                // empty if block
            }
            return result;
        }
        catch (ScriptException e) {
            throw new RuntimeException("Error running resource:" + name, e);
        }
    }
}

