/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mattacks;

import com.jme3.app.DebugKeysAppState;
import com.jme3.app.FlyCamAppState;
import com.jme3.app.SimpleApplication;
import com.jme3.app.StatsAppState;
import com.jme3.app.state.ScreenshotAppState;
import com.jme3.bounding.BoundingBox;
import com.jme3.export.Savable;
import com.jme3.export.binary.BinaryExporter;
import com.jme3.light.AmbientLight;
import com.jme3.light.DirectionalLight;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.post.FilterPostProcessor;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.SceneGraphVisitorAdapter;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Cylinder;
import com.jme3.scene.shape.Sphere;
import com.jme3.shadow.DirectionalLightShadowFilter;
import com.simsilica.lemur.Button;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.component.IconComponent;
import com.simsilica.lemur.input.InputMapper;
import com.simsilica.mattacks.MainFunctions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class SimsilicaLogoSample
extends SimpleApplication {
    private Node hud;
    private Material treeMaterial;
    private Container treeSettingsPanel;
    private Button regenerate;
    private Node logo;
    private boolean hudOn = true;

    public static void main(String[] args) {
        SimsilicaLogoSample app = new SimsilicaLogoSample();
        app.start();
    }

    public SimsilicaLogoSample() {
        super(new StatsAppState(), new DebugKeysAppState(), new FlyCamAppState(), new ScreenshotAppState("", System.currentTimeMillis()));
    }

    public void toggleHud() {
        boolean bl = this.hudOn = !this.hudOn;
        if (this.hudOn) {
            this.hud.setCullHint(Spatial.CullHint.Inherit);
        } else {
            this.hud.setCullHint(Spatial.CullHint.Always);
        }
    }

    @Override
    public void simpleInitApp() {
        System.out.println("Test:" + Vector3f.UNIT_X.cross(Vector3f.UNIT_Z.mult(-1.0f)));
        System.out.println("Test:" + Vector3f.UNIT_X.cross(Vector3f.UNIT_Y));
        GuiGlobals.initialize(this);
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        MainFunctions.initializeDefaultMappings(inputMapper);
        boolean postProcessing = false;
        DirectionalLight sun = new DirectionalLight();
        sun.setColor(ColorRGBA.White.mult(2.0f));
        Vector3f lightDir = postProcessing ? new Vector3f(-0.65073013f, -0.2383759f, 0.7616849f).normalizeLocal() : new Vector3f(-0.2f, -1.0f, -0.3f).normalizeLocal();
        sun.setDirection(lightDir);
        AmbientLight ambient = new AmbientLight();
        ambient.setColor(new ColorRGBA(0.25f, 0.25f, 0.25f, 1.0f));
        this.hud = new Node("HUD");
        this.guiNode.attachChild(this.hud);
        FilterPostProcessor fpp = new FilterPostProcessor(this.assetManager);
        if (this.settings.getSamples() != 0) {
            fpp.setNumSamples(this.settings.getSamples());
        }
        DirectionalLightShadowFilter shadows = new DirectionalLightShadowFilter(this.assetManager, 4096, 4);
        shadows.setShadowIntensity(0.3f);
        shadows.setLight(sun);
        shadows.setEnabled(true);
        fpp.addFilter(shadows);
        this.logo = new Node("logo");
        this.logo.addLight(sun);
        this.logo.addLight(ambient);
        this.logo.setLocalTranslation(5.0f, 5.0f, -5.0f);
        this.rootNode.attachChild(this.logo);
        float size = 2.0f;
        Node unit = new Node("Unit");
        this.logo.attachChild(unit);
        unit.setLocalTranslation(-size, size, -size);
        this.createOuter(new Vector3f(-size, size, -size), size, unit);
        this.createOuter(new Vector3f(size, size, size), size, unit);
        this.createOuter(new Vector3f(-size, -size, size), size, unit);
        this.createOuter(new Vector3f(size, -size, -size), size, unit);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
        ColorRGBA color1 = new ColorRGBA(0.22745098f, 0.76862746f, 0.4392157f, 1.0f);
        mat.setColor("Diffuse", color1);
        ColorRGBA color2 = new ColorRGBA(0.4392157f, 0.2509804f, 0.6431373f, 1.0f);
        mat.setColor("Ambient", color2);
        mat.setColor("Specular", ColorRGBA.White);
        mat.setFloat("Shininess", 120.0f);
        mat.setBoolean("UseMaterialColors", true);
        Sphere s = new Sphere(24, 48, 1.0f);
        Geometry geom = new Geometry("Center", s);
        geom.setMaterial(mat);
        geom.setLocalTranslation(0.0f, 0.0f, 0.0f);
        unit.attachChild(geom);
        geom.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
        this.cam.setLocation(new Vector3f(-9.88f, 12.92f, -0.26f));
        Quaternion old = this.cam.getRotation();
        this.cam.lookAt(new Vector3f(5.0f, 5.0f, -5.0f), Vector3f.UNIT_Y);
        Vector3f dir = this.cam.getDirection();
        this.cam.setLocation(this.cam.getLocation().subtract(dir.mult(5.0f)));
        unit = (Node)unit.clone();
        this.logo.attachChild(unit);
        unit.setLocalTranslation(size, size, size);
        unit = (Node)unit.clone();
        this.logo.attachChild(unit);
        unit.setLocalTranslation(-size, -size, size);
        unit = (Node)unit.clone();
        this.logo.attachChild(unit);
        unit.setLocalTranslation(size, -size, -size);
        final ArrayList spheres = new ArrayList();
        this.logo.depthFirstTraversal(new SceneGraphVisitorAdapter(){

            @Override
            public void visit(Geometry geom) {
                if (geom.getMesh() instanceof Sphere) {
                    spheres.add(geom);
                }
            }
        });
        HashMap<String, Geometry> visited = new HashMap<String, Geometry>();
        for (Geometry g : spheres) {
            System.out.println("g:" + g + "  bb:" + g.getWorldBound());
            String id = String.valueOf(g.getWorldBound());
            if (visited.containsKey(id)) {
                System.out.println("  Removing.");
                g.removeFromParent();
                continue;
            }
            visited.put(id, g);
        }
        System.out.println("Logo rotation:" + this.logo.getWorldRotation());
        System.out.println("Logo location:" + this.logo.getWorldTranslation());
        System.out.println("Camera rotation:" + this.cam.getRotation());
        System.out.println("Camera location:" + this.cam.getLocation());
        System.out.println("Camera direction:" + this.cam.getDirection());
        float[] angles = this.cam.getRotation().toAngles(null);
        System.out.println("Angles:" + angles[0] + ", " + angles[1] + ", " + angles[2]);
        Quaternion unrotate = this.cam.getRotation().inverse();
        this.logo.rotate(unrotate);
        Quaternion camRot = this.cam.getRotation();
        this.cam.setRotation(unrotate.mult(camRot));
        Vector3f relative = this.cam.getLocation().subtract(this.logo.getWorldTranslation());
        relative = unrotate.mult(relative);
        this.cam.setLocation(this.logo.getWorldTranslation().add(relative));
        lightDir = unrotate.mult(lightDir);
        sun.setDirection(lightDir);
        System.out.println("Logo rotation:" + this.logo.getWorldRotation());
        System.out.println("Logo location:" + this.logo.getWorldTranslation());
        System.out.println("Camera rotation:" + this.cam.getRotation());
        System.out.println("Camera location:" + this.cam.getLocation());
        System.out.println("Camera direction:" + this.cam.getDirection());
        System.out.println("light direction:" + lightDir);
        angles = this.cam.getRotation().toAngles(null);
        System.out.println("Angles:" + angles[0] + ", " + angles[1] + ", " + angles[2]);
        this.logo.setLocalRotation(new Quaternion(-0.13721845f, -0.7851883f, 0.18772297f, 0.5739432f));
        sun.setDirection(new Vector3f(0.32600844f, -0.8813343f, 0.34200737f));
        this.cam.setLocation(new Vector3f(0.0f, 5.0f, -42.0f));
        Label simsilica = new Label("");
        IconComponent icon = new IconComponent("Interface/Simsilica-text1024.png");
        icon.setColor(new ColorRGBA(0.5f, 0.9f, 1.0f, 1.0f).mult(1.5f));
        simsilica.setIcon(icon);
        float scale = 0.025f;
        simsilica.setLocalScale(scale);
        Vector3f pref = simsilica.getPreferredSize();
        simsilica.setLocalTranslation(5.0f + pref.x * 0.5f * scale, -3.0f, 0.0f);
        simsilica.rotate(0.0f, (float)Math.PI, 0.0f);
        System.out.println("Preferred size:" + simsilica.getPreferredSize());
        this.rootNode.attachChild(simsilica);
        BoundingBox bb = (BoundingBox)this.rootNode.getWorldBound();
        this.cam.setLocation(bb.getCenter().add(0.0f, 0.0f, -39.0f));
        System.out.println("root world bound:" + this.rootNode.getWorldBound());
        BinaryExporter exporter = BinaryExporter.getInstance();
        File file = new File("simsilica.j3o");
        try {
            exporter.save((Savable)this.logo, file);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        Node test = (Node)this.assetManager.loadModel("Models/simsilica.j3o");
        test.center();
        this.rootNode.attachChild(test);
    }

    protected void createOuter(Vector3f pos, float size, Node parent) {
        Material mat = new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
        ColorRGBA color = new ColorRGBA(0.003921569f, 0.47058824f, 0.6431373f, 1.0f);
        color.multLocal(0.75f);
        mat.setColor("Diffuse", color);
        mat.setColor("Ambient", color);
        mat.setColor("Specular", ColorRGBA.White);
        mat.setFloat("Shininess", 120.0f);
        mat.setBoolean("UseMaterialColors", true);
        Sphere s = new Sphere(24, 48, 1.0f);
        Geometry geom = new Geometry("Sphere", s);
        geom.setMaterial(mat);
        geom.setLocalTranslation(pos);
        geom.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
        parent.attachChild(geom);
        color = new ColorRGBA(0.20392157f, 0.7372549f, 0.59607846f, 1.0f);
        color.multLocal(0.5f);
        mat = new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
        mat.setColor("Diffuse", color);
        mat.setColor("Ambient", color);
        mat.setColor("Specular", color);
        mat.setFloat("Shininess", 128.0f);
        mat.setBoolean("UseMaterialColors", true);
        float radialLength = FastMath.sqrt(size * size + size * size + size * size);
        Cylinder cyl = new Cylinder(5, 24, 0.2f, radialLength);
        geom = new Geometry("Connector1", cyl);
        geom.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
        geom.setMaterial(mat);
        Quaternion rot = new Quaternion();
        rot.lookAt(pos, Vector3f.UNIT_Y);
        geom.setLocalRotation(rot);
        geom.setLocalTranslation(rot.mult(Vector3f.UNIT_Z).mult(radialLength * 0.5f));
        parent.attachChild(geom);
    }

    @Override
    public void simpleUpdate(float tpf) {
        Quaternion rot = new Quaternion().fromAngles(0.0f, tpf * 2.0f, 0.0f);
        this.logo.setLocalRotation(rot.mult(this.logo.getLocalRotation()));
    }

    @Override
    public void simpleRender(RenderManager rm) {
    }
}

