/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mattacks;

import com.jme3.app.Application;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.shape.Quad;
import com.jme3.texture.Texture;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedObject;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.event.BaseAppState;
import com.simsilica.mattacks.TimeState;

public class StarFieldState
extends BaseAppState {
    private static VersionedHolder<Vector3f> DEFAULT_POS = new VersionedHolder<Vector3f>(new Vector3f());
    private TimeState timeState;
    private ViewPort viewPort;
    private Node root = new Node("starfieldRoot");
    private Node[] starLayers;
    private Vector2f[] textureOffsets;
    private VersionedReference<Vector3f> viewPosition = DEFAULT_POS.createReference();
    private float offsetScale;
    private final Vector3f velocity = new Vector3f(0.0f, 50.0f, 0.0f);
    private final ColorRGBA color = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
    float lastTpf;

    public StarFieldState() {
        this.root.setQueueBucket(RenderQueue.Bucket.Gui);
    }

    public void setAlpha(float alpha) {
        this.color.a = alpha;
    }

    public float getAlpha() {
        return this.color.a;
    }

    public void setVelocity(Vector3f v) {
        this.velocity.set(v);
    }

    public void setVelocity(float x, float y, float z) {
        System.out.println("Setting starfield velocity to:" + x + ", " + y + ", " + z);
        this.velocity.set(x, y, z);
    }

    public void setViewPosition(VersionedObject<Vector3f> pos) {
        this.viewPosition = pos.createReference();
    }

    public Vector3f getViewPosition() {
        return this.viewPosition.get();
    }

    public Node getRoot() {
        return this.root;
    }

    @Override
    protected void initialize(Application app) {
        this.timeState = this.getState(TimeState.class);
        Camera cam = app.getGuiViewPort().getCamera();
        this.viewPort = app.getRenderManager().createMainView("World2D", cam);
        this.viewPort.setEnabled(false);
        this.viewPort.attachScene(this.root);
        String[] starMaps = new String[]{"Textures/Skies0258_1_M.jpg", "Textures/Skies0258_2_M.jpg", "Textures/Skies0258_3_M.jpg", "Textures/Skies0258_4_M.jpg", "Textures/Skies0258_5_M.jpg"};
        Quad layer = new Quad(1600.0f, 1200.0f);
        this.starLayers = new Node[starMaps.length];
        this.textureOffsets = new Vector2f[starMaps.length];
        for (int i = 0; i < this.starLayers.length; ++i) {
            this.textureOffsets[i] = new Vector2f();
            Texture tex = GuiGlobals.getInstance().loadTexture(starMaps[i], true, false);
            Material mat = new Material(this.getApplication().getAssetManager(), "MatDefs/Beam.j3md");
            mat.setTexture("ColorMap", tex);
            mat.setColor("Color", this.color);
            mat.setVector2("TextureOffset", this.textureOffsets[i]);
            mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.AlphaAdditive);
            Geometry geom = new Geometry("layer[" + i + "]", layer);
            geom.setMaterial(mat);
            Node n = new Node("layer[" + i + "]");
            n.attachChild(geom);
            n.setLocalTranslation(0.0f, 0.0f, i);
            this.root.attachChild(n);
            this.starLayers[i] = n;
        }
        float xScale = (float)cam.getWidth() / 1600.0f;
        float yScale = (float)cam.getWidth() / 1200.0f;
        float scale = Math.max(xScale, yScale);
        this.root.setLocalScale(scale);
        this.offsetScale = 0.5f;
    }

    @Override
    protected void cleanup(Application app) {
        app.getRenderManager().removeMainView(this.viewPort);
    }

    @Override
    protected void enable() {
        this.viewPort.setEnabled(true);
    }

    @Override
    public void update(float tpf) {
        double delta = this.timeState.getFrameDeltaSecs();
        this.lastTpf = tpf = (float)delta;
        if (this.velocity.lengthSquared() != 0.0f && this.viewPosition.get() == DEFAULT_POS.getObject()) {
            DEFAULT_POS.getObject().addLocal(this.velocity.x * tpf, this.velocity.y * tpf, this.velocity.z * tpf);
            DEFAULT_POS.incrementVersion();
        }
        if (this.viewPosition.update()) {
            Vector3f offset = this.viewPosition.get();
            for (int i = 0; i < this.starLayers.length; ++i) {
                int index = this.starLayers.length - 1 - i;
                float scale = (float)index / (float)(this.starLayers.length - 1);
                scale = scale * scale * scale;
                this.textureOffsets[i].x = offset.x * (scale *= 0.001f) * this.offsetScale;
                this.textureOffsets[i].y = offset.y * scale * this.offsetScale;
            }
        }
    }

    @Override
    public void render(RenderManager rm) {
        this.root.updateLogicalState(this.lastTpf);
        this.root.updateGeometricState();
    }

    @Override
    protected void disable() {
        this.viewPort.setEnabled(false);
    }
}

